'use client'
import {
  useAccordionContext
} from "./chunk-74QY6M57.mjs";
import {
  useAccordionItemContext,
  useAccordionStyles
} from "./chunk-RUEU7BLR.mjs";

// src/accordion-panel.tsx
import { chakra, forwardRef } from "@chakra-ui/system";
import { Collapse } from "@chakra-ui/transition";
import { cx } from "@chakra-ui/shared-utils";
import { jsx } from "react/jsx-runtime";
var AccordionPanel = forwardRef(
  function AccordionPanel2(props, ref) {
    const { className, motionProps, ...rest } = props;
    const { reduceMotion } = useAccordionContext();
    const { getPanelProps, isOpen } = useAccordionItemContext();
    const panelProps = getPanelProps(rest, ref);
    const _className = cx("chakra-accordion__panel", className);
    const styles = useAccordionStyles();
    if (!reduceMotion) {
      delete panelProps.hidden;
    }
    const child = /* @__PURE__ */ jsx(chakra.div, { ...panelProps, __css: styles.panel, className: _className });
    if (!reduceMotion) {
      return /* @__PURE__ */ jsx(Collapse, { in: isOpen, ...motionProps, children: child });
    }
    return child;
  }
);
AccordionPanel.displayName = "AccordionPanel";

export {
  AccordionPanel
};
//# sourceMappingURL=chunk-5VAIMVHT.mjs.map