'use client'
import {
  AccordionProvider,
  useAccordion
} from "./chunk-74QY6M57.mjs";
import {
  AccordionDescendantsProvider,
  AccordionStylesProvider
} from "./chunk-RUEU7BLR.mjs";

// src/accordion.tsx
import {
  chakra,
  forwardRef,
  omitThemingProps,
  useMultiStyleConfig
} from "@chakra-ui/system";
import { cx } from "@chakra-ui/shared-utils";
import { useMemo } from "react";
import { jsx } from "react/jsx-runtime";
var Accordion = forwardRef(function Accordion2({ children, reduceMotion, ...props }, ref) {
  const styles = useMultiStyleConfig("Accordion", props);
  const ownProps = omitThemingProps(props);
  const { htmlProps, descendants, ...context } = useAccordion(ownProps);
  const ctx = useMemo(
    () => ({ ...context, reduceMotion: !!reduceMotion }),
    [context, reduceMotion]
  );
  return /* @__PURE__ */ jsx(AccordionDescendantsProvider, { value: descendants, children: /* @__PURE__ */ jsx(AccordionProvider, { value: ctx, children: /* @__PURE__ */ jsx(AccordionStylesProvider, { value: styles, children: /* @__PURE__ */ jsx(
    chakra.div,
    {
      ref,
      ...htmlProps,
      className: cx("chakra-accordion", props.className),
      __css: styles.root,
      children
    }
  ) }) }) });
});
Accordion.displayName = "Accordion";

export {
  Accordion
};
//# sourceMappingURL=chunk-CRBMUVJA.mjs.map