import * as _chakra_ui_system from '@chakra-ui/system';
import { SystemStyleObject } from '@chakra-ui/system';
import * as _chakra_ui_spinner from '@chakra-ui/spinner';
import * as react from 'react';
import { InfoIcon, WarningIcon, CheckIcon } from './icons.mjs';
import 'react/jsx-runtime';
import '@chakra-ui/icon';

declare const AlertProvider: react.Provider<AlertContext>;
declare const useAlertContext: () => AlertContext;
declare const AlertStylesProvider: react.Provider<Record<string, SystemStyleObject>>;
declare const useAlertStyles: () => Record<string, SystemStyleObject>;
declare const STATUSES: {
    info: {
        icon: typeof InfoIcon;
        colorScheme: string;
    };
    warning: {
        icon: typeof WarningIcon;
        colorScheme: string;
    };
    success: {
        icon: typeof CheckIcon;
        colorScheme: string;
    };
    error: {
        icon: typeof WarningIcon;
        colorScheme: string;
    };
    loading: {
        icon: _chakra_ui_system.ComponentWithAs<"div", _chakra_ui_spinner.SpinnerProps>;
        colorScheme: string;
    };
};
declare function getStatusColorScheme(status: AlertStatus): string;
declare function getStatusIcon(status: AlertStatus): typeof InfoIcon | typeof WarningIcon | typeof CheckIcon | _chakra_ui_system.ComponentWithAs<"div", _chakra_ui_spinner.SpinnerProps>;
type AlertStatus = keyof typeof STATUSES;
interface AlertContext {
    status: AlertStatus;
}

export { AlertContext, AlertProvider, AlertStatus, AlertStylesProvider, getStatusColorScheme, getStatusIcon, useAlertContext, useAlertStyles };
