import * as _chakra_ui_system from '@chakra-ui/system';
import { ThemingProps, HTMLChakraProps, PropsOf } from '@chakra-ui/system';
import { b as UseCheckboxProps, d as CheckboxOptions } from './checkbox-types-17f713ed.js';
import 'react';

type CheckboxControlProps = Omit<HTMLChakraProps<"div">, keyof UseCheckboxProps>;
type BaseInputProps = Pick<PropsOf<"input">, "onBlur" | "checked" | "defaultChecked">;
interface CheckboxProps extends CheckboxControlProps, BaseInputProps, ThemingProps<"Checkbox">, UseCheckboxProps, CheckboxOptions {
}
/**
 * Checkbox
 *
 * React component used in forms when a user needs to select
 * multiple values from several options.
 *
 * @see Docs https://chakra-ui.com/checkbox
 * @see WAI-ARIA https://www.w3.org/WAI/ARIA/apg/patterns/checkbox/
 */
declare const Checkbox: _chakra_ui_system.ComponentWithAs<"input", CheckboxProps>;

export { Checkbox, CheckboxProps };
