import * as react from 'react';
import { PropGetter } from '@chakra-ui/react-types';
import { b as UseCheckboxProps, a as CheckboxState } from './checkbox-types-17f713ed.js';
import '@chakra-ui/system';

/**
 * useCheckbox that provides all the state and focus management logic
 * for a checkbox. It is consumed by the `Checkbox` component
 *
 * @see Docs https://chakra-ui.com/checkbox#hooks
 * @see WAI-ARIA https://www.w3.org/WAI/ARIA/apg/patterns/checkbox/
 */
declare function useCheckbox(props?: UseCheckboxProps): {
    state: CheckboxState;
    getRootProps: PropGetter;
    getCheckboxProps: PropGetter;
    getIndicatorProps: PropGetter;
    getInputProps: PropGetter;
    getLabelProps: PropGetter;
    htmlProps: Omit<{
        isDisabled?: boolean | undefined;
        isReadOnly?: boolean | undefined;
        isInvalid?: boolean | undefined;
        isRequired?: boolean | undefined;
        onBlur?: ((event: react.FocusEvent<HTMLInputElement, Element>) => void) | undefined;
        onFocus?: ((event: react.FocusEvent<HTMLInputElement, Element>) => void) | undefined;
        id?: string | undefined;
        "aria-describedby"?: string | undefined;
    }, "isDisabled" | "id" | "aria-describedby" | "onFocus" | "onBlur" | "isRequired" | "isInvalid" | "isReadOnly">;
};
type UseCheckboxReturn = ReturnType<typeof useCheckbox>;

export { UseCheckboxReturn, useCheckbox };
