import * as react from 'react';

interface UseClickableProps extends React.HTMLAttributes<HTMLElement> {
    /**
     * If `true`, the element will be disabled.
     * It will set the `disabled` HTML attribute
     *
     * @default false
     */
    isDisabled?: boolean;
    /**
     * If `true` and isDisabled, the element will
     * have only `aria-disabled` set to `true`
     *
     * @default false
     */
    isFocusable?: boolean;
    /**
     * Whether or not trigger click on pressing `Enter`.
     *
     * @default true
     */
    clickOnEnter?: boolean;
    /**
     * Whether or not trigger click on pressing `Space`.
     *
     * @default true
     */
    clickOnSpace?: boolean;
    /**
     * The ref for the element
     */
    ref?: React.Ref<HTMLElement>;
}
/**
 * useClickable implements all the interactions of a native `button`
 * component with support for making it focusable even if it is disabled.
 *
 * It can be used with both native button elements or other elements (like `div`).
 */
declare function useClickable(props?: UseClickableProps): {
    ref: (node: any) => void;
    type: "reset" | "submit" | "button" | undefined;
    "aria-disabled": boolean | undefined;
    disabled: boolean | undefined;
    onClick: (event: React.MouseEvent<HTMLElement>) => void;
    onMouseDown: react.MouseEventHandler<HTMLElement> | undefined;
    onMouseUp: react.MouseEventHandler<HTMLElement> | undefined;
    onKeyUp: react.KeyboardEventHandler<HTMLElement> | undefined;
    onKeyDown: react.KeyboardEventHandler<HTMLElement> | undefined;
    onMouseOver: react.MouseEventHandler<HTMLElement> | undefined;
    onMouseLeave: react.MouseEventHandler<HTMLElement> | undefined;
    defaultChecked?: boolean | undefined;
    defaultValue?: string | number | readonly string[] | undefined;
    suppressContentEditableWarning?: boolean | undefined;
    suppressHydrationWarning?: boolean | undefined;
    accessKey?: string | undefined;
    autoFocus?: boolean | undefined;
    className?: string | undefined;
    contentEditable?: (boolean | "true" | "false") | "inherit" | undefined;
    contextMenu?: string | undefined;
    dir?: string | undefined;
    draggable?: (boolean | "true" | "false") | undefined;
    hidden?: boolean | undefined;
    id?: string | undefined;
    lang?: string | undefined;
    nonce?: string | undefined;
    placeholder?: string | undefined;
    slot?: string | undefined;
    spellCheck?: (boolean | "true" | "false") | undefined;
    style?: react.CSSProperties | undefined;
    title?: string | undefined;
    translate?: "yes" | "no" | undefined;
    radioGroup?: string | undefined;
    role?: react.AriaRole | undefined;
    about?: string | undefined;
    datatype?: string | undefined;
    inlist?: any;
    prefix?: string | undefined;
    property?: string | undefined;
    resource?: string | undefined;
    typeof?: string | undefined;
    vocab?: string | undefined;
    autoCapitalize?: string | undefined;
    autoCorrect?: string | undefined;
    autoSave?: string | undefined;
    color?: string | undefined;
    itemProp?: string | undefined;
    itemScope?: boolean | undefined;
    itemType?: string | undefined;
    itemID?: string | undefined;
    itemRef?: string | undefined;
    results?: number | undefined;
    security?: string | undefined;
    unselectable?: "on" | "off" | undefined;
    inputMode?: "none" | "text" | "tel" | "url" | "email" | "numeric" | "decimal" | "search" | undefined;
    is?: string | undefined;
    'aria-activedescendant'?: string | undefined;
    'aria-atomic'?: (boolean | "true" | "false") | undefined;
    'aria-autocomplete'?: "none" | "inline" | "list" | "both" | undefined;
    'aria-busy'?: (boolean | "true" | "false") | undefined;
    'aria-checked'?: boolean | "true" | "false" | "mixed" | undefined;
    'aria-colcount'?: number | undefined;
    'aria-colindex'?: number | undefined;
    'aria-colspan'?: number | undefined;
    'aria-controls'?: string | undefined;
    'aria-current'?: boolean | "true" | "false" | "page" | "step" | "location" | "date" | "time" | undefined;
    'aria-describedby'?: string | undefined;
    'aria-details'?: string | undefined;
    'aria-dropeffect'?: "copy" | "none" | "execute" | "link" | "move" | "popup" | undefined;
    'aria-errormessage'?: string | undefined;
    'aria-expanded'?: (boolean | "true" | "false") | undefined;
    'aria-flowto'?: string | undefined;
    'aria-grabbed'?: (boolean | "true" | "false") | undefined;
    'aria-haspopup'?: boolean | "true" | "false" | "menu" | "listbox" | "tree" | "grid" | "dialog" | undefined;
    'aria-hidden'?: (boolean | "true" | "false") | undefined;
    'aria-invalid'?: boolean | "true" | "false" | "grammar" | "spelling" | undefined;
    'aria-keyshortcuts'?: string | undefined;
    'aria-label'?: string | undefined;
    'aria-labelledby'?: string | undefined;
    'aria-level'?: number | undefined;
    'aria-live'?: "off" | "assertive" | "polite" | undefined;
    'aria-modal'?: (boolean | "true" | "false") | undefined;
    'aria-multiline'?: (boolean | "true" | "false") | undefined;
    'aria-multiselectable'?: (boolean | "true" | "false") | undefined;
    'aria-orientation'?: "horizontal" | "vertical" | undefined;
    'aria-owns'?: string | undefined;
    'aria-placeholder'?: string | undefined;
    'aria-posinset'?: number | undefined;
    'aria-pressed'?: boolean | "true" | "false" | "mixed" | undefined;
    'aria-readonly'?: (boolean | "true" | "false") | undefined;
    'aria-relevant'?: "text" | "additions" | "additions removals" | "additions text" | "all" | "removals" | "removals additions" | "removals text" | "text additions" | "text removals" | undefined;
    'aria-required'?: (boolean | "true" | "false") | undefined;
    'aria-roledescription'?: string | undefined;
    'aria-rowcount'?: number | undefined;
    'aria-rowindex'?: number | undefined;
    'aria-rowspan'?: number | undefined;
    'aria-selected'?: (boolean | "true" | "false") | undefined;
    'aria-setsize'?: number | undefined;
    'aria-sort'?: "none" | "ascending" | "descending" | "other" | undefined;
    'aria-valuemax'?: number | undefined;
    'aria-valuemin'?: number | undefined;
    'aria-valuenow'?: number | undefined;
    'aria-valuetext'?: string | undefined;
    children?: react.ReactNode;
    dangerouslySetInnerHTML?: {
        __html: string;
    } | undefined;
    onCopy?: react.ClipboardEventHandler<HTMLElement> | undefined;
    onCopyCapture?: react.ClipboardEventHandler<HTMLElement> | undefined;
    onCut?: react.ClipboardEventHandler<HTMLElement> | undefined;
    onCutCapture?: react.ClipboardEventHandler<HTMLElement> | undefined;
    onPaste?: react.ClipboardEventHandler<HTMLElement> | undefined;
    onPasteCapture?: react.ClipboardEventHandler<HTMLElement> | undefined;
    onCompositionEnd?: react.CompositionEventHandler<HTMLElement> | undefined;
    onCompositionEndCapture?: react.CompositionEventHandler<HTMLElement> | undefined;
    onCompositionStart?: react.CompositionEventHandler<HTMLElement> | undefined;
    onCompositionStartCapture?: react.CompositionEventHandler<HTMLElement> | undefined;
    onCompositionUpdate?: react.CompositionEventHandler<HTMLElement> | undefined;
    onCompositionUpdateCapture?: react.CompositionEventHandler<HTMLElement> | undefined;
    onFocus?: react.FocusEventHandler<HTMLElement> | undefined;
    onFocusCapture?: react.FocusEventHandler<HTMLElement> | undefined;
    onBlur?: react.FocusEventHandler<HTMLElement> | undefined;
    onBlurCapture?: react.FocusEventHandler<HTMLElement> | undefined;
    onChange?: react.FormEventHandler<HTMLElement> | undefined;
    onChangeCapture?: react.FormEventHandler<HTMLElement> | undefined;
    onBeforeInput?: react.FormEventHandler<HTMLElement> | undefined;
    onBeforeInputCapture?: react.FormEventHandler<HTMLElement> | undefined;
    onInput?: react.FormEventHandler<HTMLElement> | undefined;
    onInputCapture?: react.FormEventHandler<HTMLElement> | undefined;
    onReset?: react.FormEventHandler<HTMLElement> | undefined;
    onResetCapture?: react.FormEventHandler<HTMLElement> | undefined;
    onSubmit?: react.FormEventHandler<HTMLElement> | undefined;
    onSubmitCapture?: react.FormEventHandler<HTMLElement> | undefined;
    onInvalid?: react.FormEventHandler<HTMLElement> | undefined;
    onInvalidCapture?: react.FormEventHandler<HTMLElement> | undefined;
    onLoad?: react.ReactEventHandler<HTMLElement> | undefined;
    onLoadCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onError?: react.ReactEventHandler<HTMLElement> | undefined;
    onErrorCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onKeyDownCapture?: react.KeyboardEventHandler<HTMLElement> | undefined;
    onKeyPress?: react.KeyboardEventHandler<HTMLElement> | undefined;
    onKeyPressCapture?: react.KeyboardEventHandler<HTMLElement> | undefined;
    onKeyUpCapture?: react.KeyboardEventHandler<HTMLElement> | undefined;
    onAbort?: react.ReactEventHandler<HTMLElement> | undefined;
    onAbortCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onCanPlay?: react.ReactEventHandler<HTMLElement> | undefined;
    onCanPlayCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onCanPlayThrough?: react.ReactEventHandler<HTMLElement> | undefined;
    onCanPlayThroughCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onDurationChange?: react.ReactEventHandler<HTMLElement> | undefined;
    onDurationChangeCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onEmptied?: react.ReactEventHandler<HTMLElement> | undefined;
    onEmptiedCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onEncrypted?: react.ReactEventHandler<HTMLElement> | undefined;
    onEncryptedCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onEnded?: react.ReactEventHandler<HTMLElement> | undefined;
    onEndedCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onLoadedData?: react.ReactEventHandler<HTMLElement> | undefined;
    onLoadedDataCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onLoadedMetadata?: react.ReactEventHandler<HTMLElement> | undefined;
    onLoadedMetadataCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onLoadStart?: react.ReactEventHandler<HTMLElement> | undefined;
    onLoadStartCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onPause?: react.ReactEventHandler<HTMLElement> | undefined;
    onPauseCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onPlay?: react.ReactEventHandler<HTMLElement> | undefined;
    onPlayCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onPlaying?: react.ReactEventHandler<HTMLElement> | undefined;
    onPlayingCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onProgress?: react.ReactEventHandler<HTMLElement> | undefined;
    onProgressCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onRateChange?: react.ReactEventHandler<HTMLElement> | undefined;
    onRateChangeCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onResize?: react.ReactEventHandler<HTMLElement> | undefined;
    onResizeCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onSeeked?: react.ReactEventHandler<HTMLElement> | undefined;
    onSeekedCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onSeeking?: react.ReactEventHandler<HTMLElement> | undefined;
    onSeekingCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onStalled?: react.ReactEventHandler<HTMLElement> | undefined;
    onStalledCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onSuspend?: react.ReactEventHandler<HTMLElement> | undefined;
    onSuspendCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onTimeUpdate?: react.ReactEventHandler<HTMLElement> | undefined;
    onTimeUpdateCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onVolumeChange?: react.ReactEventHandler<HTMLElement> | undefined;
    onVolumeChangeCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onWaiting?: react.ReactEventHandler<HTMLElement> | undefined;
    onWaitingCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onAuxClick?: react.MouseEventHandler<HTMLElement> | undefined;
    onAuxClickCapture?: react.MouseEventHandler<HTMLElement> | undefined;
    onClickCapture?: react.MouseEventHandler<HTMLElement> | undefined;
    onContextMenu?: react.MouseEventHandler<HTMLElement> | undefined;
    onContextMenuCapture?: react.MouseEventHandler<HTMLElement> | undefined;
    onDoubleClick?: react.MouseEventHandler<HTMLElement> | undefined;
    onDoubleClickCapture?: react.MouseEventHandler<HTMLElement> | undefined;
    onDrag?: react.DragEventHandler<HTMLElement> | undefined;
    onDragCapture?: react.DragEventHandler<HTMLElement> | undefined;
    onDragEnd?: react.DragEventHandler<HTMLElement> | undefined;
    onDragEndCapture?: react.DragEventHandler<HTMLElement> | undefined;
    onDragEnter?: react.DragEventHandler<HTMLElement> | undefined;
    onDragEnterCapture?: react.DragEventHandler<HTMLElement> | undefined;
    onDragExit?: react.DragEventHandler<HTMLElement> | undefined;
    onDragExitCapture?: react.DragEventHandler<HTMLElement> | undefined;
    onDragLeave?: react.DragEventHandler<HTMLElement> | undefined;
    onDragLeaveCapture?: react.DragEventHandler<HTMLElement> | undefined;
    onDragOver?: react.DragEventHandler<HTMLElement> | undefined;
    onDragOverCapture?: react.DragEventHandler<HTMLElement> | undefined;
    onDragStart?: react.DragEventHandler<HTMLElement> | undefined;
    onDragStartCapture?: react.DragEventHandler<HTMLElement> | undefined;
    onDrop?: react.DragEventHandler<HTMLElement> | undefined;
    onDropCapture?: react.DragEventHandler<HTMLElement> | undefined;
    onMouseDownCapture?: react.MouseEventHandler<HTMLElement> | undefined;
    onMouseEnter?: react.MouseEventHandler<HTMLElement> | undefined;
    onMouseMove?: react.MouseEventHandler<HTMLElement> | undefined;
    onMouseMoveCapture?: react.MouseEventHandler<HTMLElement> | undefined;
    onMouseOut?: react.MouseEventHandler<HTMLElement> | undefined;
    onMouseOutCapture?: react.MouseEventHandler<HTMLElement> | undefined;
    onMouseOverCapture?: react.MouseEventHandler<HTMLElement> | undefined;
    onMouseUpCapture?: react.MouseEventHandler<HTMLElement> | undefined;
    onSelect?: react.ReactEventHandler<HTMLElement> | undefined;
    onSelectCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onTouchCancel?: react.TouchEventHandler<HTMLElement> | undefined;
    onTouchCancelCapture?: react.TouchEventHandler<HTMLElement> | undefined;
    onTouchEnd?: react.TouchEventHandler<HTMLElement> | undefined;
    onTouchEndCapture?: react.TouchEventHandler<HTMLElement> | undefined;
    onTouchMove?: react.TouchEventHandler<HTMLElement> | undefined;
    onTouchMoveCapture?: react.TouchEventHandler<HTMLElement> | undefined;
    onTouchStart?: react.TouchEventHandler<HTMLElement> | undefined;
    onTouchStartCapture?: react.TouchEventHandler<HTMLElement> | undefined;
    onPointerDown?: react.PointerEventHandler<HTMLElement> | undefined;
    onPointerDownCapture?: react.PointerEventHandler<HTMLElement> | undefined;
    onPointerMove?: react.PointerEventHandler<HTMLElement> | undefined;
    onPointerMoveCapture?: react.PointerEventHandler<HTMLElement> | undefined;
    onPointerUp?: react.PointerEventHandler<HTMLElement> | undefined;
    onPointerUpCapture?: react.PointerEventHandler<HTMLElement> | undefined;
    onPointerCancel?: react.PointerEventHandler<HTMLElement> | undefined;
    onPointerCancelCapture?: react.PointerEventHandler<HTMLElement> | undefined;
    onPointerEnter?: react.PointerEventHandler<HTMLElement> | undefined;
    onPointerEnterCapture?: react.PointerEventHandler<HTMLElement> | undefined;
    onPointerLeave?: react.PointerEventHandler<HTMLElement> | undefined;
    onPointerLeaveCapture?: react.PointerEventHandler<HTMLElement> | undefined;
    onPointerOver?: react.PointerEventHandler<HTMLElement> | undefined;
    onPointerOverCapture?: react.PointerEventHandler<HTMLElement> | undefined;
    onPointerOut?: react.PointerEventHandler<HTMLElement> | undefined;
    onPointerOutCapture?: react.PointerEventHandler<HTMLElement> | undefined;
    onGotPointerCapture?: react.PointerEventHandler<HTMLElement> | undefined;
    onGotPointerCaptureCapture?: react.PointerEventHandler<HTMLElement> | undefined;
    onLostPointerCapture?: react.PointerEventHandler<HTMLElement> | undefined;
    onLostPointerCaptureCapture?: react.PointerEventHandler<HTMLElement> | undefined;
    onScroll?: react.UIEventHandler<HTMLElement> | undefined;
    onScrollCapture?: react.UIEventHandler<HTMLElement> | undefined;
    onWheel?: react.WheelEventHandler<HTMLElement> | undefined;
    onWheelCapture?: react.WheelEventHandler<HTMLElement> | undefined;
    onAnimationStart?: react.AnimationEventHandler<HTMLElement> | undefined;
    onAnimationStartCapture?: react.AnimationEventHandler<HTMLElement> | undefined;
    onAnimationEnd?: react.AnimationEventHandler<HTMLElement> | undefined;
    onAnimationEndCapture?: react.AnimationEventHandler<HTMLElement> | undefined;
    onAnimationIteration?: react.AnimationEventHandler<HTMLElement> | undefined;
    onAnimationIterationCapture?: react.AnimationEventHandler<HTMLElement> | undefined;
    onTransitionEnd?: react.TransitionEventHandler<HTMLElement> | undefined;
    onTransitionEndCapture?: react.TransitionEventHandler<HTMLElement> | undefined;
} | {
    ref: (node: any) => void;
    role: string;
    "data-active": boolean | "true" | "false";
    "aria-disabled": "true" | undefined;
    tabIndex: number | undefined;
    onClick: (event: React.MouseEvent<HTMLElement>) => void;
    onMouseDown: (event: React.MouseEvent<HTMLElement>) => void;
    onMouseUp: (event: React.MouseEvent<HTMLElement>) => void;
    onKeyUp: (event: React.KeyboardEvent<HTMLElement>) => void;
    onKeyDown: (event: React.KeyboardEvent<HTMLElement>) => void;
    onMouseOver: (event: React.MouseEvent<HTMLElement>) => void;
    onMouseLeave: (event: React.MouseEvent<HTMLElement>) => void;
    defaultChecked?: boolean | undefined;
    defaultValue?: string | number | readonly string[] | undefined;
    suppressContentEditableWarning?: boolean | undefined;
    suppressHydrationWarning?: boolean | undefined;
    accessKey?: string | undefined;
    autoFocus?: boolean | undefined;
    className?: string | undefined;
    contentEditable?: (boolean | "true" | "false") | "inherit" | undefined;
    contextMenu?: string | undefined;
    dir?: string | undefined;
    draggable?: (boolean | "true" | "false") | undefined;
    hidden?: boolean | undefined;
    id?: string | undefined;
    lang?: string | undefined;
    nonce?: string | undefined;
    placeholder?: string | undefined;
    slot?: string | undefined;
    spellCheck?: (boolean | "true" | "false") | undefined;
    style?: react.CSSProperties | undefined;
    title?: string | undefined;
    translate?: "yes" | "no" | undefined;
    radioGroup?: string | undefined;
    about?: string | undefined;
    datatype?: string | undefined;
    inlist?: any;
    prefix?: string | undefined;
    property?: string | undefined;
    resource?: string | undefined;
    typeof?: string | undefined;
    vocab?: string | undefined;
    autoCapitalize?: string | undefined;
    autoCorrect?: string | undefined;
    autoSave?: string | undefined;
    color?: string | undefined;
    itemProp?: string | undefined;
    itemScope?: boolean | undefined;
    itemType?: string | undefined;
    itemID?: string | undefined;
    itemRef?: string | undefined;
    results?: number | undefined;
    security?: string | undefined;
    unselectable?: "on" | "off" | undefined;
    inputMode?: "none" | "text" | "tel" | "url" | "email" | "numeric" | "decimal" | "search" | undefined;
    is?: string | undefined;
    'aria-activedescendant'?: string | undefined;
    'aria-atomic'?: (boolean | "true" | "false") | undefined;
    'aria-autocomplete'?: "none" | "inline" | "list" | "both" | undefined;
    'aria-busy'?: (boolean | "true" | "false") | undefined;
    'aria-checked'?: boolean | "true" | "false" | "mixed" | undefined;
    'aria-colcount'?: number | undefined;
    'aria-colindex'?: number | undefined;
    'aria-colspan'?: number | undefined;
    'aria-controls'?: string | undefined;
    'aria-current'?: boolean | "true" | "false" | "page" | "step" | "location" | "date" | "time" | undefined;
    'aria-describedby'?: string | undefined;
    'aria-details'?: string | undefined;
    'aria-dropeffect'?: "copy" | "none" | "execute" | "link" | "move" | "popup" | undefined;
    'aria-errormessage'?: string | undefined;
    'aria-expanded'?: (boolean | "true" | "false") | undefined;
    'aria-flowto'?: string | undefined;
    'aria-grabbed'?: (boolean | "true" | "false") | undefined;
    'aria-haspopup'?: boolean | "true" | "false" | "menu" | "listbox" | "tree" | "grid" | "dialog" | undefined;
    'aria-hidden'?: (boolean | "true" | "false") | undefined;
    'aria-invalid'?: boolean | "true" | "false" | "grammar" | "spelling" | undefined;
    'aria-keyshortcuts'?: string | undefined;
    'aria-label'?: string | undefined;
    'aria-labelledby'?: string | undefined;
    'aria-level'?: number | undefined;
    'aria-live'?: "off" | "assertive" | "polite" | undefined;
    'aria-modal'?: (boolean | "true" | "false") | undefined;
    'aria-multiline'?: (boolean | "true" | "false") | undefined;
    'aria-multiselectable'?: (boolean | "true" | "false") | undefined;
    'aria-orientation'?: "horizontal" | "vertical" | undefined;
    'aria-owns'?: string | undefined;
    'aria-placeholder'?: string | undefined;
    'aria-posinset'?: number | undefined;
    'aria-pressed'?: boolean | "true" | "false" | "mixed" | undefined;
    'aria-readonly'?: (boolean | "true" | "false") | undefined;
    'aria-relevant'?: "text" | "additions" | "additions removals" | "additions text" | "all" | "removals" | "removals additions" | "removals text" | "text additions" | "text removals" | undefined;
    'aria-required'?: (boolean | "true" | "false") | undefined;
    'aria-roledescription'?: string | undefined;
    'aria-rowcount'?: number | undefined;
    'aria-rowindex'?: number | undefined;
    'aria-rowspan'?: number | undefined;
    'aria-selected'?: (boolean | "true" | "false") | undefined;
    'aria-setsize'?: number | undefined;
    'aria-sort'?: "none" | "ascending" | "descending" | "other" | undefined;
    'aria-valuemax'?: number | undefined;
    'aria-valuemin'?: number | undefined;
    'aria-valuenow'?: number | undefined;
    'aria-valuetext'?: string | undefined;
    children?: react.ReactNode;
    dangerouslySetInnerHTML?: {
        __html: string;
    } | undefined;
    onCopy?: react.ClipboardEventHandler<HTMLElement> | undefined;
    onCopyCapture?: react.ClipboardEventHandler<HTMLElement> | undefined;
    onCut?: react.ClipboardEventHandler<HTMLElement> | undefined;
    onCutCapture?: react.ClipboardEventHandler<HTMLElement> | undefined;
    onPaste?: react.ClipboardEventHandler<HTMLElement> | undefined;
    onPasteCapture?: react.ClipboardEventHandler<HTMLElement> | undefined;
    onCompositionEnd?: react.CompositionEventHandler<HTMLElement> | undefined;
    onCompositionEndCapture?: react.CompositionEventHandler<HTMLElement> | undefined;
    onCompositionStart?: react.CompositionEventHandler<HTMLElement> | undefined;
    onCompositionStartCapture?: react.CompositionEventHandler<HTMLElement> | undefined;
    onCompositionUpdate?: react.CompositionEventHandler<HTMLElement> | undefined;
    onCompositionUpdateCapture?: react.CompositionEventHandler<HTMLElement> | undefined;
    onFocus?: react.FocusEventHandler<HTMLElement> | undefined;
    onFocusCapture?: react.FocusEventHandler<HTMLElement> | undefined;
    onBlur?: react.FocusEventHandler<HTMLElement> | undefined;
    onBlurCapture?: react.FocusEventHandler<HTMLElement> | undefined;
    onChange?: react.FormEventHandler<HTMLElement> | undefined;
    onChangeCapture?: react.FormEventHandler<HTMLElement> | undefined;
    onBeforeInput?: react.FormEventHandler<HTMLElement> | undefined;
    onBeforeInputCapture?: react.FormEventHandler<HTMLElement> | undefined;
    onInput?: react.FormEventHandler<HTMLElement> | undefined;
    onInputCapture?: react.FormEventHandler<HTMLElement> | undefined;
    onReset?: react.FormEventHandler<HTMLElement> | undefined;
    onResetCapture?: react.FormEventHandler<HTMLElement> | undefined;
    onSubmit?: react.FormEventHandler<HTMLElement> | undefined;
    onSubmitCapture?: react.FormEventHandler<HTMLElement> | undefined;
    onInvalid?: react.FormEventHandler<HTMLElement> | undefined;
    onInvalidCapture?: react.FormEventHandler<HTMLElement> | undefined;
    onLoad?: react.ReactEventHandler<HTMLElement> | undefined;
    onLoadCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onError?: react.ReactEventHandler<HTMLElement> | undefined;
    onErrorCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onKeyDownCapture?: react.KeyboardEventHandler<HTMLElement> | undefined;
    onKeyPress?: react.KeyboardEventHandler<HTMLElement> | undefined;
    onKeyPressCapture?: react.KeyboardEventHandler<HTMLElement> | undefined;
    onKeyUpCapture?: react.KeyboardEventHandler<HTMLElement> | undefined;
    onAbort?: react.ReactEventHandler<HTMLElement> | undefined;
    onAbortCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onCanPlay?: react.ReactEventHandler<HTMLElement> | undefined;
    onCanPlayCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onCanPlayThrough?: react.ReactEventHandler<HTMLElement> | undefined;
    onCanPlayThroughCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onDurationChange?: react.ReactEventHandler<HTMLElement> | undefined;
    onDurationChangeCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onEmptied?: react.ReactEventHandler<HTMLElement> | undefined;
    onEmptiedCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onEncrypted?: react.ReactEventHandler<HTMLElement> | undefined;
    onEncryptedCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onEnded?: react.ReactEventHandler<HTMLElement> | undefined;
    onEndedCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onLoadedData?: react.ReactEventHandler<HTMLElement> | undefined;
    onLoadedDataCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onLoadedMetadata?: react.ReactEventHandler<HTMLElement> | undefined;
    onLoadedMetadataCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onLoadStart?: react.ReactEventHandler<HTMLElement> | undefined;
    onLoadStartCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onPause?: react.ReactEventHandler<HTMLElement> | undefined;
    onPauseCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onPlay?: react.ReactEventHandler<HTMLElement> | undefined;
    onPlayCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onPlaying?: react.ReactEventHandler<HTMLElement> | undefined;
    onPlayingCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onProgress?: react.ReactEventHandler<HTMLElement> | undefined;
    onProgressCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onRateChange?: react.ReactEventHandler<HTMLElement> | undefined;
    onRateChangeCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onResize?: react.ReactEventHandler<HTMLElement> | undefined;
    onResizeCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onSeeked?: react.ReactEventHandler<HTMLElement> | undefined;
    onSeekedCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onSeeking?: react.ReactEventHandler<HTMLElement> | undefined;
    onSeekingCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onStalled?: react.ReactEventHandler<HTMLElement> | undefined;
    onStalledCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onSuspend?: react.ReactEventHandler<HTMLElement> | undefined;
    onSuspendCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onTimeUpdate?: react.ReactEventHandler<HTMLElement> | undefined;
    onTimeUpdateCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onVolumeChange?: react.ReactEventHandler<HTMLElement> | undefined;
    onVolumeChangeCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onWaiting?: react.ReactEventHandler<HTMLElement> | undefined;
    onWaitingCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onAuxClick?: react.MouseEventHandler<HTMLElement> | undefined;
    onAuxClickCapture?: react.MouseEventHandler<HTMLElement> | undefined;
    onClickCapture?: react.MouseEventHandler<HTMLElement> | undefined;
    onContextMenu?: react.MouseEventHandler<HTMLElement> | undefined;
    onContextMenuCapture?: react.MouseEventHandler<HTMLElement> | undefined;
    onDoubleClick?: react.MouseEventHandler<HTMLElement> | undefined;
    onDoubleClickCapture?: react.MouseEventHandler<HTMLElement> | undefined;
    onDrag?: react.DragEventHandler<HTMLElement> | undefined;
    onDragCapture?: react.DragEventHandler<HTMLElement> | undefined;
    onDragEnd?: react.DragEventHandler<HTMLElement> | undefined;
    onDragEndCapture?: react.DragEventHandler<HTMLElement> | undefined;
    onDragEnter?: react.DragEventHandler<HTMLElement> | undefined;
    onDragEnterCapture?: react.DragEventHandler<HTMLElement> | undefined;
    onDragExit?: react.DragEventHandler<HTMLElement> | undefined;
    onDragExitCapture?: react.DragEventHandler<HTMLElement> | undefined;
    onDragLeave?: react.DragEventHandler<HTMLElement> | undefined;
    onDragLeaveCapture?: react.DragEventHandler<HTMLElement> | undefined;
    onDragOver?: react.DragEventHandler<HTMLElement> | undefined;
    onDragOverCapture?: react.DragEventHandler<HTMLElement> | undefined;
    onDragStart?: react.DragEventHandler<HTMLElement> | undefined;
    onDragStartCapture?: react.DragEventHandler<HTMLElement> | undefined;
    onDrop?: react.DragEventHandler<HTMLElement> | undefined;
    onDropCapture?: react.DragEventHandler<HTMLElement> | undefined;
    onMouseDownCapture?: react.MouseEventHandler<HTMLElement> | undefined;
    onMouseEnter?: react.MouseEventHandler<HTMLElement> | undefined;
    onMouseMove?: react.MouseEventHandler<HTMLElement> | undefined;
    onMouseMoveCapture?: react.MouseEventHandler<HTMLElement> | undefined;
    onMouseOut?: react.MouseEventHandler<HTMLElement> | undefined;
    onMouseOutCapture?: react.MouseEventHandler<HTMLElement> | undefined;
    onMouseOverCapture?: react.MouseEventHandler<HTMLElement> | undefined;
    onMouseUpCapture?: react.MouseEventHandler<HTMLElement> | undefined;
    onSelect?: react.ReactEventHandler<HTMLElement> | undefined;
    onSelectCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onTouchCancel?: react.TouchEventHandler<HTMLElement> | undefined;
    onTouchCancelCapture?: react.TouchEventHandler<HTMLElement> | undefined;
    onTouchEnd?: react.TouchEventHandler<HTMLElement> | undefined;
    onTouchEndCapture?: react.TouchEventHandler<HTMLElement> | undefined;
    onTouchMove?: react.TouchEventHandler<HTMLElement> | undefined;
    onTouchMoveCapture?: react.TouchEventHandler<HTMLElement> | undefined;
    onTouchStart?: react.TouchEventHandler<HTMLElement> | undefined;
    onTouchStartCapture?: react.TouchEventHandler<HTMLElement> | undefined;
    onPointerDown?: react.PointerEventHandler<HTMLElement> | undefined;
    onPointerDownCapture?: react.PointerEventHandler<HTMLElement> | undefined;
    onPointerMove?: react.PointerEventHandler<HTMLElement> | undefined;
    onPointerMoveCapture?: react.PointerEventHandler<HTMLElement> | undefined;
    onPointerUp?: react.PointerEventHandler<HTMLElement> | undefined;
    onPointerUpCapture?: react.PointerEventHandler<HTMLElement> | undefined;
    onPointerCancel?: react.PointerEventHandler<HTMLElement> | undefined;
    onPointerCancelCapture?: react.PointerEventHandler<HTMLElement> | undefined;
    onPointerEnter?: react.PointerEventHandler<HTMLElement> | undefined;
    onPointerEnterCapture?: react.PointerEventHandler<HTMLElement> | undefined;
    onPointerLeave?: react.PointerEventHandler<HTMLElement> | undefined;
    onPointerLeaveCapture?: react.PointerEventHandler<HTMLElement> | undefined;
    onPointerOver?: react.PointerEventHandler<HTMLElement> | undefined;
    onPointerOverCapture?: react.PointerEventHandler<HTMLElement> | undefined;
    onPointerOut?: react.PointerEventHandler<HTMLElement> | undefined;
    onPointerOutCapture?: react.PointerEventHandler<HTMLElement> | undefined;
    onGotPointerCapture?: react.PointerEventHandler<HTMLElement> | undefined;
    onGotPointerCaptureCapture?: react.PointerEventHandler<HTMLElement> | undefined;
    onLostPointerCapture?: react.PointerEventHandler<HTMLElement> | undefined;
    onLostPointerCaptureCapture?: react.PointerEventHandler<HTMLElement> | undefined;
    onScroll?: react.UIEventHandler<HTMLElement> | undefined;
    onScrollCapture?: react.UIEventHandler<HTMLElement> | undefined;
    onWheel?: react.WheelEventHandler<HTMLElement> | undefined;
    onWheelCapture?: react.WheelEventHandler<HTMLElement> | undefined;
    onAnimationStart?: react.AnimationEventHandler<HTMLElement> | undefined;
    onAnimationStartCapture?: react.AnimationEventHandler<HTMLElement> | undefined;
    onAnimationEnd?: react.AnimationEventHandler<HTMLElement> | undefined;
    onAnimationEndCapture?: react.AnimationEventHandler<HTMLElement> | undefined;
    onAnimationIteration?: react.AnimationEventHandler<HTMLElement> | undefined;
    onAnimationIterationCapture?: react.AnimationEventHandler<HTMLElement> | undefined;
    onTransitionEnd?: react.TransitionEventHandler<HTMLElement> | undefined;
    onTransitionEndCapture?: react.TransitionEventHandler<HTMLElement> | undefined;
};
type UseClickableReturn = ReturnType<typeof useClickable>;

export { UseClickableProps, UseClickableReturn, useClickable };
