'use client'
"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/index.ts
var src_exports = {};
__export(src_exports, {
  assignRef: () => assignRef,
  useAnimationState: () => useAnimationState,
  useBoolean: () => useBoolean,
  useCallbackRef: () => useCallbackRef,
  useClipboard: () => useClipboard,
  useConst: () => useConst,
  useControllableProp: () => useControllableProp,
  useControllableState: () => useControllableState,
  useDimensions: () => useDimensions,
  useDisclosure: () => useDisclosure,
  useEventListener: () => useEventListener,
  useEventListenerMap: () => useEventListenerMap,
  useFocusEffect: () => useFocusEffect,
  useFocusOnHide: () => useFocusOnHide,
  useFocusOnPointerDown: () => useFocusOnPointerDown,
  useFocusOnShow: () => useFocusOnShow,
  useForceUpdate: () => useForceUpdate,
  useId: () => useId,
  useIds: () => useIds,
  useInterval: () => useInterval,
  useLatestRef: () => useLatestRef,
  useMergeRefs: () => useMergeRefs,
  useMouseDownRef: () => useMouseDownRef,
  useOptionalPart: () => useOptionalPart,
  useOutsideClick: () => useOutsideClick,
  usePanGesture: () => usePanGesture,
  usePointerEvent: () => usePointerEvent,
  usePrevious: () => usePrevious,
  useSafeLayoutEffect: () => useSafeLayoutEffect,
  useShortcut: () => useShortcut,
  useTimeout: () => useTimeout,
  useUnmountEffect: () => useUnmountEffect,
  useUpdateEffect: () => useUpdateEffect,
  useWhyDidYouUpdate: () => useWhyDidYouUpdate
});
module.exports = __toCommonJS(src_exports);

// src/use-animation-state.ts
var import_utils3 = require("@chakra-ui/utils");
var import_react4 = require("react");

// src/use-event-listener.ts
var import_utils2 = require("@chakra-ui/utils");
var import_react3 = require("react");

// src/use-callback-ref.ts
var import_react2 = require("react");

// src/use-safe-layout-effect.ts
var import_utils = require("@chakra-ui/utils");
var import_react = require("react");
var useSafeLayoutEffect = import_utils.isBrowser ? import_react.useLayoutEffect : import_react.useEffect;

// src/use-callback-ref.ts
function useCallbackRef(fn, deps = []) {
  const ref = (0, import_react2.useRef)(fn);
  useSafeLayoutEffect(() => {
    ref.current = fn;
  });
  return (0, import_react2.useCallback)((...args) => {
    var _a;
    return (_a = ref.current) == null ? void 0 : _a.call(ref, ...args);
  }, deps);
}

// src/use-event-listener.ts
function useEventListener(event, handler, env, options) {
  const listener = useCallbackRef(handler);
  (0, import_react3.useEffect)(() => {
    var _a;
    const node = (_a = (0, import_utils2.runIfFn)(env)) != null ? _a : document;
    if (!handler) {
      return;
    }
    node.addEventListener(event, listener, options);
    return () => {
      node.removeEventListener(event, listener, options);
    };
  }, [event, env, options, listener, handler]);
  return () => {
    var _a;
    const node = (_a = (0, import_utils2.runIfFn)(env)) != null ? _a : document;
    node.removeEventListener(event, listener, options);
  };
}

// src/use-animation-state.ts
function useAnimationState(props) {
  const { isOpen, ref } = props;
  const [mounted, setMounted] = (0, import_react4.useState)(isOpen);
  const [once, setOnce] = (0, import_react4.useState)(false);
  (0, import_react4.useEffect)(() => {
    if (!once) {
      setMounted(isOpen);
      setOnce(true);
    }
  }, [isOpen, once, mounted]);
  useEventListener(
    "animationend",
    () => {
      setMounted(isOpen);
    },
    () => ref.current
  );
  const hidden = isOpen ? false : !mounted;
  return {
    present: !hidden,
    onComplete() {
      var _a;
      const win = (0, import_utils3.getOwnerWindow)(ref.current);
      const evt = new win.CustomEvent("animationend", { bubbles: true });
      (_a = ref.current) == null ? void 0 : _a.dispatchEvent(evt);
    }
  };
}

// src/use-boolean.ts
var import_react5 = require("react");
function useBoolean(initialState = false) {
  const [value, setValue] = (0, import_react5.useState)(initialState);
  const callbacks = (0, import_react5.useMemo)(
    () => ({
      on: () => setValue(true),
      off: () => setValue(false),
      toggle: () => setValue((prev) => !prev)
    }),
    []
  );
  return [value, callbacks];
}

// src/use-clipboard.ts
var import_react6 = require("react");
var import_copy_to_clipboard = __toESM(require("copy-to-clipboard"));
function useClipboard(value, optionsOrTimeout = {}) {
  const [hasCopied, setHasCopied] = (0, import_react6.useState)(false);
  const [valueState, setValueState] = (0, import_react6.useState)(value);
  (0, import_react6.useEffect)(() => setValueState(value), [value]);
  const { timeout = 1500, ...copyOptions } = typeof optionsOrTimeout === "number" ? { timeout: optionsOrTimeout } : optionsOrTimeout;
  const onCopy = (0, import_react6.useCallback)(() => {
    const didCopy = (0, import_copy_to_clipboard.default)(valueState, copyOptions);
    setHasCopied(didCopy);
  }, [valueState, copyOptions]);
  (0, import_react6.useEffect)(() => {
    let timeoutId = null;
    if (hasCopied) {
      timeoutId = window.setTimeout(() => {
        setHasCopied(false);
      }, timeout);
    }
    return () => {
      if (timeoutId) {
        window.clearTimeout(timeoutId);
      }
    };
  }, [timeout, hasCopied]);
  return {
    value: valueState,
    setValue: setValueState,
    onCopy,
    hasCopied
  };
}

// src/use-const.ts
var import_react7 = require("react");
function useConst(init) {
  const ref = (0, import_react7.useRef)(null);
  if (ref.current === null) {
    ref.current = typeof init === "function" ? init() : init;
  }
  return ref.current;
}

// src/use-controllable.ts
var import_utils4 = require("@chakra-ui/utils");
var import_react8 = require("react");
function useControllableProp(prop, state) {
  const isControlled = prop !== void 0;
  const value = isControlled && typeof prop !== "undefined" ? prop : state;
  return [isControlled, value];
}
function useControllableState(props) {
  const {
    value: valueProp,
    defaultValue,
    onChange,
    shouldUpdate = (prev, next) => prev !== next
  } = props;
  const onChangeProp = useCallbackRef(onChange);
  const shouldUpdateProp = useCallbackRef(shouldUpdate);
  const [valueState, setValue] = (0, import_react8.useState)(defaultValue);
  const isControlled = valueProp !== void 0;
  const value = isControlled ? valueProp : valueState;
  const updateValue = (0, import_react8.useCallback)(
    (next) => {
      const nextValue = (0, import_utils4.runIfFn)(next, value);
      if (!shouldUpdateProp(value, nextValue)) {
        return;
      }
      if (!isControlled) {
        setValue(nextValue);
      }
      onChangeProp(nextValue);
    },
    [isControlled, onChangeProp, value, shouldUpdateProp]
  );
  return [value, updateValue];
}

// src/use-dimensions.ts
var import_utils5 = require("@chakra-ui/utils");
var import_react9 = require("react");
function useDimensions(ref, observe) {
  const [dimensions, setDimensions] = (0, import_react9.useState)(null);
  const rafId = (0, import_react9.useRef)();
  useSafeLayoutEffect(() => {
    function measure() {
      const node = ref.current;
      if (!node)
        return;
      rafId.current = requestAnimationFrame(() => {
        const boxModel = (0, import_utils5.getBox)(node);
        setDimensions(boxModel);
      });
    }
    measure();
    if (observe) {
      window.addEventListener("resize", measure);
      window.addEventListener("scroll", measure);
    }
    return () => {
      if (observe) {
        window.removeEventListener("resize", measure);
        window.removeEventListener("scroll", measure);
      }
      if (rafId.current) {
        cancelAnimationFrame(rafId.current);
      }
    };
  }, [observe]);
  return dimensions;
}

// src/use-disclosure.ts
var import_utils6 = require("@chakra-ui/utils");

// src/use-id.ts
var import_react10 = require("react");
function useId(idProp, prefix) {
  const id = (0, import_react10.useId)();
  return (0, import_react10.useMemo)(
    () => idProp || [prefix, id].filter(Boolean).join("-"),
    [idProp, prefix, id]
  );
}
function useIds(idProp, ...prefixes) {
  const id = useId(idProp);
  return (0, import_react10.useMemo)(() => {
    return prefixes.map((prefix) => `${prefix}-${id}`);
  }, [id, prefixes]);
}
function useOptionalPart(partId) {
  const [id, setId] = (0, import_react10.useState)(null);
  const ref = (0, import_react10.useCallback)(
    (node) => {
      setId(node ? partId : null);
    },
    [partId]
  );
  return { ref, id, isRendered: Boolean(id) };
}

// src/use-disclosure.ts
var import_react11 = require("react");
function useDisclosure(props = {}) {
  const {
    onClose: onCloseProp,
    onOpen: onOpenProp,
    isOpen: isOpenProp,
    id: idProp
  } = props;
  const onOpenPropCallbackRef = useCallbackRef(onOpenProp);
  const onClosePropCallbackRef = useCallbackRef(onCloseProp);
  const [isOpenState, setIsOpen] = (0, import_react11.useState)(props.defaultIsOpen || false);
  const [isControlled, isOpen] = useControllableProp(isOpenProp, isOpenState);
  const id = useId(idProp, "disclosure");
  const onClose = (0, import_react11.useCallback)(() => {
    if (!isControlled) {
      setIsOpen(false);
    }
    onClosePropCallbackRef == null ? void 0 : onClosePropCallbackRef();
  }, [isControlled, onClosePropCallbackRef]);
  const onOpen = (0, import_react11.useCallback)(() => {
    if (!isControlled) {
      setIsOpen(true);
    }
    onOpenPropCallbackRef == null ? void 0 : onOpenPropCallbackRef();
  }, [isControlled, onOpenPropCallbackRef]);
  const onToggle = (0, import_react11.useCallback)(() => {
    const action = isOpen ? onClose : onOpen;
    action();
  }, [isOpen, onOpen, onClose]);
  return {
    isOpen: !!isOpen,
    onOpen,
    onClose,
    onToggle,
    isControlled,
    getButtonProps: (props2 = {}) => ({
      ...props2,
      "aria-expanded": isOpen,
      "aria-controls": id,
      onClick: (0, import_utils6.callAllHandlers)(props2.onClick, onToggle)
    }),
    getDisclosureProps: (props2 = {}) => ({
      ...props2,
      hidden: !isOpen,
      id
    })
  };
}

// src/use-event-listener-map.ts
var import_utils7 = require("@chakra-ui/utils");
var import_react12 = require("react");
function useEventListenerMap() {
  const listeners = (0, import_react12.useRef)(/* @__PURE__ */ new Map());
  const currentListeners = listeners.current;
  const add = (0, import_react12.useCallback)((el, type, listener, options) => {
    const pointerEventListener = (0, import_utils7.wrapPointerEventHandler)(
      listener,
      type === "pointerdown"
    );
    listeners.current.set(listener, {
      __listener: pointerEventListener,
      type: (0, import_utils7.getPointerEventName)(type),
      el,
      options
    });
    el.addEventListener(type, pointerEventListener, options);
  }, []);
  const remove = (0, import_react12.useCallback)(
    (el, type, listener, options) => {
      const { __listener: pointerEventListener } = listeners.current.get(listener);
      el.removeEventListener(type, pointerEventListener, options);
      listeners.current.delete(pointerEventListener);
    },
    []
  );
  (0, import_react12.useEffect)(
    () => () => {
      currentListeners.forEach((value, key) => {
        remove(value.el, value.type, key, value.options);
      });
    },
    [remove, currentListeners]
  );
  return { add, remove };
}

// src/use-focus-effect.ts
var import_utils8 = require("@chakra-ui/utils");

// src/use-update-effect.ts
var import_react13 = require("react");
var useUpdateEffect = (effect, deps) => {
  const renderCycleRef = (0, import_react13.useRef)(false);
  const effectCycleRef = (0, import_react13.useRef)(false);
  (0, import_react13.useEffect)(() => {
    const isMounted = renderCycleRef.current;
    const shouldRun = isMounted && effectCycleRef.current;
    if (shouldRun) {
      return effect();
    }
    effectCycleRef.current = true;
  }, deps);
  (0, import_react13.useEffect)(() => {
    renderCycleRef.current = true;
    return () => {
      renderCycleRef.current = false;
    };
  }, []);
};

// src/use-focus-effect.ts
function useFocusEffect(ref, options) {
  const { shouldFocus, preventScroll } = options;
  useUpdateEffect(() => {
    const node = ref.current;
    if (!node || !shouldFocus)
      return;
    if (!(0, import_utils8.hasFocusWithin)(node)) {
      (0, import_utils8.focus)(node, { preventScroll, nextTick: true });
    }
  }, [shouldFocus, ref, preventScroll]);
}

// src/use-focus-on-hide.ts
var import_utils9 = require("@chakra-ui/utils");
function preventReturnFocus(containerRef) {
  const el = containerRef.current;
  if (!el)
    return false;
  const activeElement = (0, import_utils9.getActiveElement)(el);
  if (!activeElement)
    return false;
  if ((0, import_utils9.contains)(el, activeElement))
    return false;
  if ((0, import_utils9.isTabbable)(activeElement))
    return true;
  return false;
}
function useFocusOnHide(containerRef, options) {
  const { shouldFocus: shouldFocusProp, visible, focusRef } = options;
  const shouldFocus = shouldFocusProp && !visible;
  useUpdateEffect(() => {
    if (!shouldFocus)
      return;
    if (preventReturnFocus(containerRef)) {
      return;
    }
    const el = (focusRef == null ? void 0 : focusRef.current) || containerRef.current;
    if (el) {
      (0, import_utils9.focus)(el, { nextTick: true });
    }
  }, [shouldFocus, containerRef, focusRef]);
}

// src/use-focus-on-pointerdown.ts
var import_utils11 = require("@chakra-ui/utils");

// src/use-pointer-event.ts
var import_utils10 = require("@chakra-ui/utils");
function usePointerEvent(env, eventName, handler, options) {
  return useEventListener(
    (0, import_utils10.getPointerEventName)(eventName),
    (0, import_utils10.wrapPointerEventHandler)(handler, eventName === "pointerdown"),
    env,
    options
  );
}

// src/use-focus-on-pointerdown.ts
function useFocusOnPointerDown(props) {
  const { ref, elements, enabled } = props;
  const isSafari = (0, import_utils11.detectBrowser)("Safari");
  const doc = () => (0, import_utils11.getOwnerDocument)(ref.current);
  usePointerEvent(doc, "pointerdown", (event) => {
    if (!isSafari || !enabled)
      return;
    const target = event.target;
    const els = elements != null ? elements : [ref];
    const isValidTarget = els.some((elementOrRef) => {
      const el = (0, import_utils11.isRefObject)(elementOrRef) ? elementOrRef.current : elementOrRef;
      return (0, import_utils11.contains)(el, target);
    });
    if (!(0, import_utils11.isActiveElement)(target) && isValidTarget) {
      event.preventDefault();
      (0, import_utils11.focus)(target);
    }
  });
}

// src/use-focus-on-show.ts
var import_utils12 = require("@chakra-ui/utils");
var import_react14 = require("react");
var defaultOptions = {
  preventScroll: true,
  shouldFocus: false
};
function useFocusOnShow(target, options = defaultOptions) {
  const { focusRef, preventScroll, shouldFocus, visible } = options;
  const element = (0, import_utils12.isRefObject)(target) ? target.current : target;
  const autoFocusValue = shouldFocus && visible;
  const autoFocusRef = (0, import_react14.useRef)(autoFocusValue);
  const lastVisibleRef = (0, import_react14.useRef)(visible);
  useSafeLayoutEffect(() => {
    if (!lastVisibleRef.current && visible) {
      autoFocusRef.current = autoFocusValue;
    }
    lastVisibleRef.current = visible;
  }, [visible, autoFocusValue]);
  const onFocus = (0, import_react14.useCallback)(() => {
    if (!visible || !element || !autoFocusRef.current)
      return;
    autoFocusRef.current = false;
    if ((0, import_utils12.contains)(element, document.activeElement))
      return;
    if (focusRef == null ? void 0 : focusRef.current) {
      (0, import_utils12.focus)(focusRef.current, { preventScroll, nextTick: true });
    } else {
      const tabbableEls = (0, import_utils12.getAllFocusable)(element);
      if (tabbableEls.length > 0) {
        (0, import_utils12.focus)(tabbableEls[0], { preventScroll, nextTick: true });
      }
    }
  }, [visible, preventScroll, element, focusRef]);
  useUpdateEffect(() => {
    onFocus();
  }, [onFocus]);
  useEventListener("transitionend", onFocus, element);
}

// src/use-force-update.ts
var import_react16 = require("react");

// src/use-unmount-effect.ts
var import_react15 = require("react");
function useUnmountEffect(fn, deps = []) {
  return (0, import_react15.useEffect)(
    () => () => fn(),
    // eslint-disable-next-line react-hooks/exhaustive-deps
    deps
  );
}

// src/use-force-update.ts
function useForceUpdate() {
  const unloadingRef = (0, import_react16.useRef)(false);
  const [count, setCount] = (0, import_react16.useState)(0);
  useUnmountEffect(() => {
    unloadingRef.current = true;
  });
  return (0, import_react16.useCallback)(() => {
    if (!unloadingRef.current) {
      setCount(count + 1);
    }
  }, [count]);
}

// src/use-interval.ts
var import_react17 = require("react");
function useInterval(callback, delay) {
  const fn = useCallbackRef(callback);
  (0, import_react17.useEffect)(() => {
    let intervalId = null;
    const tick = () => fn();
    if (delay !== null) {
      intervalId = window.setInterval(tick, delay);
    }
    return () => {
      if (intervalId) {
        window.clearInterval(intervalId);
      }
    };
  }, [delay, fn]);
}

// src/use-latest-ref.ts
var import_react18 = require("react");
function useLatestRef(value) {
  const ref = (0, import_react18.useRef)(null);
  ref.current = value;
  return ref;
}

// src/use-merge-refs.ts
var import_react19 = require("react");
function assignRef(ref, value) {
  if (ref == null)
    return;
  if (typeof ref === "function") {
    ref(value);
    return;
  }
  try {
    ref.current = value;
  } catch (error) {
    throw new Error(`Cannot assign value '${value}' to ref '${ref}'`);
  }
}
function useMergeRefs(...refs) {
  return (0, import_react19.useMemo)(() => {
    if (refs.every((ref) => ref == null)) {
      return null;
    }
    return (node) => {
      refs.forEach((ref) => {
        if (ref)
          assignRef(ref, node);
      });
    };
  }, refs);
}

// src/use-mouse-down-ref.ts
var import_react20 = require("react");
function useMouseDownRef(shouldListen = true) {
  const mouseDownRef = (0, import_react20.useRef)();
  useEventListener("mousedown", (event) => {
    if (shouldListen) {
      mouseDownRef.current = event.target;
    }
  });
  return mouseDownRef;
}

// src/use-outside-click.ts
var import_utils13 = require("@chakra-ui/utils");
var import_react21 = require("react");
function useOutsideClick(props) {
  const { ref, handler, enabled = true } = props;
  const savedHandler = useCallbackRef(handler);
  const stateRef = (0, import_react21.useRef)({
    isPointerDown: false,
    ignoreEmulatedMouseEvents: false
  });
  const state = stateRef.current;
  (0, import_react21.useEffect)(() => {
    if (!enabled)
      return;
    const onPointerDown = (e) => {
      if (isValidEvent(e, ref)) {
        state.isPointerDown = true;
      }
    };
    const onMouseUp = (event) => {
      if (state.ignoreEmulatedMouseEvents) {
        state.ignoreEmulatedMouseEvents = false;
        return;
      }
      if (state.isPointerDown && handler && isValidEvent(event, ref)) {
        state.isPointerDown = false;
        savedHandler(event);
      }
    };
    const onTouchEnd = (event) => {
      state.ignoreEmulatedMouseEvents = true;
      if (handler && state.isPointerDown && isValidEvent(event, ref)) {
        state.isPointerDown = false;
        savedHandler(event);
      }
    };
    const doc = (0, import_utils13.getOwnerDocument)(ref.current);
    doc.addEventListener("mousedown", onPointerDown, true);
    doc.addEventListener("mouseup", onMouseUp, true);
    doc.addEventListener("touchstart", onPointerDown, true);
    doc.addEventListener("touchend", onTouchEnd, true);
    return () => {
      doc.removeEventListener("mousedown", onPointerDown, true);
      doc.removeEventListener("mouseup", onMouseUp, true);
      doc.removeEventListener("touchstart", onPointerDown, true);
      doc.removeEventListener("touchend", onTouchEnd, true);
    };
  }, [handler, ref, savedHandler, state, enabled]);
}
function isValidEvent(event, ref) {
  var _a;
  const target = event.target;
  if (target) {
    const doc = (0, import_utils13.getOwnerDocument)(target);
    if (!doc.contains(target))
      return false;
  }
  return !((_a = ref.current) == null ? void 0 : _a.contains(target));
}

// src/use-pan-gesture.ts
var import_utils14 = require("@chakra-ui/utils");
var import_react22 = require("react");
function usePanGesture(ref, props) {
  const {
    onPan,
    onPanStart,
    onPanEnd,
    onPanSessionStart,
    onPanSessionEnd,
    threshold
  } = props;
  const hasPanEvents = Boolean(
    onPan || onPanStart || onPanEnd || onPanSessionStart || onPanSessionEnd
  );
  const panSession = (0, import_react22.useRef)(null);
  const handlers = {
    onSessionStart: onPanSessionStart,
    onSessionEnd: onPanSessionEnd,
    onStart: onPanStart,
    onMove: onPan,
    onEnd(event, info) {
      panSession.current = null;
      onPanEnd == null ? void 0 : onPanEnd(event, info);
    }
  };
  (0, import_react22.useEffect)(() => {
    var _a;
    (_a = panSession.current) == null ? void 0 : _a.updateHandlers(handlers);
  });
  function onPointerDown(event) {
    panSession.current = new import_utils14.PanSession(event, handlers, threshold);
  }
  usePointerEvent(
    () => ref.current,
    "pointerdown",
    hasPanEvents ? onPointerDown : import_utils14.noop
  );
  useUnmountEffect(() => {
    var _a;
    (_a = panSession.current) == null ? void 0 : _a.end();
    panSession.current = null;
  });
}

// src/use-previous.ts
var import_react23 = require("react");
function usePrevious(value) {
  const ref = (0, import_react23.useRef)();
  (0, import_react23.useEffect)(() => {
    ref.current = value;
  }, [value]);
  return ref.current;
}

// src/use-shortcut.ts
var import_react24 = require("react");
function isPrintableCharacter(event) {
  const { key } = event;
  return key.length === 1 || key.length > 1 && /[^a-zA-Z0-9]/.test(key);
}
function useShortcut(props = {}) {
  const { timeout = 300, preventDefault = () => true } = props;
  const [keys, setKeys] = (0, import_react24.useState)([]);
  const timeoutRef = (0, import_react24.useRef)();
  const flush = () => {
    if (timeoutRef.current) {
      clearTimeout(timeoutRef.current);
      timeoutRef.current = null;
    }
  };
  const clearKeysAfterDelay = () => {
    flush();
    timeoutRef.current = setTimeout(() => {
      setKeys([]);
      timeoutRef.current = null;
    }, timeout);
  };
  (0, import_react24.useEffect)(() => flush, []);
  function onKeyDown(fn) {
    return (event) => {
      if (event.key === "Backspace") {
        const keysCopy = [...keys];
        keysCopy.pop();
        setKeys(keysCopy);
        return;
      }
      if (isPrintableCharacter(event)) {
        const keysCopy = keys.concat(event.key);
        if (preventDefault(event)) {
          event.preventDefault();
          event.stopPropagation();
        }
        setKeys(keysCopy);
        fn(keysCopy.join(""));
        clearKeysAfterDelay();
      }
    };
  }
  return onKeyDown;
}

// src/use-timeout.ts
var import_react25 = require("react");
function useTimeout(callback, delay) {
  const fn = useCallbackRef(callback);
  (0, import_react25.useEffect)(() => {
    if (delay == null)
      return void 0;
    let timeoutId = null;
    timeoutId = window.setTimeout(() => {
      fn();
    }, delay);
    return () => {
      if (timeoutId) {
        window.clearTimeout(timeoutId);
      }
    };
  }, [delay, fn]);
}

// src/use-why-update.ts
var import_react26 = require("react");
function useWhyDidYouUpdate(name, props) {
  const previousProps = (0, import_react26.useRef)();
  (0, import_react26.useEffect)(() => {
    if (previousProps.current) {
      const allKeys = Object.keys({ ...previousProps.current, ...props });
      const changesObj = {};
      allKeys.forEach((key) => {
        if (previousProps.current[key] !== props[key]) {
          changesObj[key] = {
            from: previousProps.current[key],
            to: props[key]
          };
        }
      });
      if (Object.keys(changesObj).length) {
        console.log("[why-did-you-update]", name, changesObj);
      }
    }
    previousProps.current = props;
  });
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  assignRef,
  useAnimationState,
  useBoolean,
  useCallbackRef,
  useClipboard,
  useConst,
  useControllableProp,
  useControllableState,
  useDimensions,
  useDisclosure,
  useEventListener,
  useEventListenerMap,
  useFocusEffect,
  useFocusOnHide,
  useFocusOnPointerDown,
  useFocusOnShow,
  useForceUpdate,
  useId,
  useIds,
  useInterval,
  useLatestRef,
  useMergeRefs,
  useMouseDownRef,
  useOptionalPart,
  useOutsideClick,
  usePanGesture,
  usePointerEvent,
  usePrevious,
  useSafeLayoutEffect,
  useShortcut,
  useTimeout,
  useUnmountEffect,
  useUpdateEffect,
  useWhyDidYouUpdate
});
//# sourceMappingURL=index.js.map