'use client'
import {
  useInputGroupStyles
} from "./chunk-FKYN3ZGE.mjs";

// src/input-addon.tsx
import { chakra, forwardRef } from "@chakra-ui/system";
import { cx } from "@chakra-ui/shared-utils";
import { jsx } from "react/jsx-runtime";
var placements = {
  left: {
    marginEnd: "-1px",
    borderEndRadius: 0,
    borderEndColor: "transparent"
  },
  right: {
    marginStart: "-1px",
    borderStartRadius: 0,
    borderStartColor: "transparent"
  }
};
var StyledAddon = chakra("div", {
  baseStyle: {
    flex: "0 0 auto",
    width: "auto",
    display: "flex",
    alignItems: "center",
    whiteSpace: "nowrap"
  }
});
var InputAddon = forwardRef(
  function InputAddon2(props, ref) {
    var _a;
    const { placement = "left", ...rest } = props;
    const placementStyles = (_a = placements[placement]) != null ? _a : {};
    const styles = useInputGroupStyles();
    return /* @__PURE__ */ jsx(
      StyledAddon,
      {
        ref,
        ...rest,
        __css: {
          ...styles.addon,
          ...placementStyles
        }
      }
    );
  }
);
InputAddon.displayName = "InputAddon";
var InputLeftAddon = forwardRef(
  function InputLeftAddon2(props, ref) {
    return /* @__PURE__ */ jsx(
      InputAddon,
      {
        ref,
        placement: "left",
        ...props,
        className: cx("chakra-input__left-addon", props.className)
      }
    );
  }
);
InputLeftAddon.displayName = "InputLeftAddon";
InputLeftAddon.id = "InputLeftAddon";
var InputRightAddon = forwardRef(
  function InputRightAddon2(props, ref) {
    return /* @__PURE__ */ jsx(
      InputAddon,
      {
        ref,
        placement: "right",
        ...props,
        className: cx("chakra-input__right-addon", props.className)
      }
    );
  }
);
InputRightAddon.displayName = "InputRightAddon";
InputRightAddon.id = "InputRightAddon";

export {
  InputAddon,
  InputLeftAddon,
  InputRightAddon
};
//# sourceMappingURL=chunk-ADBZ7YHX.mjs.map