'use client'

// src/indicator.tsx
import { mapResponsive } from "@chakra-ui/breakpoint-utils";
import {
  chakra,
  forwardRef
} from "@chakra-ui/system";
import { useMemo } from "react";
import { jsx } from "react/jsx-runtime";
var Indicator = forwardRef(function Indicator2(props, ref) {
  const {
    offsetX,
    offsetY,
    offset = "0",
    placement = "top-end",
    ...rest
  } = props;
  const styles = useMemo(
    () => ({
      display: "inline-flex",
      justifyContent: "center",
      alignItems: "center",
      position: "absolute",
      insetBlockStart: mapResponsive(placement, (v) => {
        const [side] = v.split("-");
        const map = {
          top: offsetY != null ? offsetY : offset,
          middle: "50%",
          bottom: "auto"
        };
        return map[side];
      }),
      insetBlockEnd: mapResponsive(placement, (v) => {
        const [side] = v.split("-");
        const map = {
          top: "auto",
          middle: "50%",
          bottom: offsetY != null ? offsetY : offset
        };
        return map[side];
      }),
      insetStart: mapResponsive(placement, (v) => {
        const [, align] = v.split("-");
        const map = {
          start: offsetX != null ? offsetX : offset,
          center: "50%",
          end: "auto"
        };
        return map[align];
      }),
      insetEnd: mapResponsive(placement, (v) => {
        const [, align] = v.split("-");
        const map = {
          start: "auto",
          center: "50%",
          end: offsetX != null ? offsetX : offset
        };
        return map[align];
      }),
      translate: mapResponsive(placement, (v) => {
        const [side, align] = v.split("-");
        const mapX = { start: "-50%", center: "-50%", end: "50%" };
        const mapY = { top: "-50%", middle: "-50%", bottom: "50%" };
        return `${mapX[align]} ${mapY[side]}`;
      })
    }),
    [offset, offsetX, offsetY, placement]
  );
  return /* @__PURE__ */ jsx(chakra.div, { ref, __css: styles, ...rest });
});

export {
  Indicator
};
//# sourceMappingURL=chunk-FDDFQHXZ.mjs.map