'use client'

// src/grid-item.tsx
import {
  forwardRef,
  chakra
} from "@chakra-ui/system";
import { compact } from "@chakra-ui/object-utils";
import { mapResponsive } from "@chakra-ui/breakpoint-utils";
import { jsx } from "react/jsx-runtime";
function spanFn(span) {
  return mapResponsive(
    span,
    (value) => value === "auto" ? "auto" : `span ${value}/span ${value}`
  );
}
var GridItem = forwardRef(function GridItem2(props, ref) {
  const {
    area,
    colSpan,
    colStart,
    colEnd,
    rowEnd,
    rowSpan,
    rowStart,
    ...rest
  } = props;
  const styles = compact({
    gridArea: area,
    gridColumn: spanFn(colSpan),
    gridRow: spanFn(rowSpan),
    gridColumnStart: colStart,
    gridColumnEnd: colEnd,
    gridRowStart: rowStart,
    gridRowEnd: rowEnd
  });
  return /* @__PURE__ */ jsx(chakra.div, { ref, __css: styles, ...rest });
});
GridItem.displayName = "GridItem";

export {
  GridItem
};
//# sourceMappingURL=chunk-ZPFGWTBB.mjs.map