'use client'
import {
  useMenuStyles
} from "./chunk-UZJ3TPNQ.mjs";

// src/menu-icon.tsx
import { chakra } from "@chakra-ui/system";
import { cx } from "@chakra-ui/shared-utils";
import { Children, cloneElement, isValidElement } from "react";
import { jsx } from "react/jsx-runtime";
var MenuIcon = (props) => {
  const { className, children, ...rest } = props;
  const styles = useMenuStyles();
  const child = Children.only(children);
  const clone = isValidElement(child) ? cloneElement(child, {
    focusable: "false",
    "aria-hidden": true,
    className: cx("chakra-menu__icon", child.props.className)
  }) : null;
  const _className = cx("chakra-menu__icon-wrapper", className);
  return /* @__PURE__ */ jsx(chakra.span, { className: _className, ...rest, __css: styles.icon, children: clone });
};
MenuIcon.displayName = "MenuIcon";

export {
  MenuIcon
};
//# sourceMappingURL=chunk-HB6KBUMZ.mjs.map