'use client'
import {
  useMenuStyles
} from "./chunk-UZJ3TPNQ.mjs";

// src/menu-group.tsx
import { chakra, forwardRef } from "@chakra-ui/system";
import { cx } from "@chakra-ui/shared-utils";
import { jsx, jsxs } from "react/jsx-runtime";
var MenuGroup = forwardRef((props, ref) => {
  const { title, children, className, ...rest } = props;
  const _className = cx("chakra-menu__group__title", className);
  const styles = useMenuStyles();
  return /* @__PURE__ */ jsxs("div", { ref, className: "chakra-menu__group", role: "group", children: [
    title && /* @__PURE__ */ jsx(chakra.p, { className: _className, ...rest, __css: styles.groupTitle, children: title }),
    children
  ] });
});
MenuGroup.displayName = "MenuGroup";

export {
  MenuGroup
};
//# sourceMappingURL=chunk-PTXXWAJU.mjs.map