'use client'
import {
  MenuDescendantsProvider,
  MenuProvider,
  useMenu
} from "./chunk-SANI5SUM.mjs";

// src/menu.tsx
import { createContext } from "@chakra-ui/react-context";
import {
  omitThemingProps,
  useMultiStyleConfig,
  useTheme
} from "@chakra-ui/system";
import { runIfFn } from "@chakra-ui/shared-utils";
import { useMemo } from "react";
import { jsx } from "react/jsx-runtime";
var [MenuStylesProvider, useMenuStyles] = createContext({
  name: `MenuStylesContext`,
  errorMessage: `useMenuStyles returned is 'undefined'. Seems you forgot to wrap the components in "<Menu />" `
});
var Menu = (props) => {
  const { children } = props;
  const styles = useMultiStyleConfig("Menu", props);
  const ownProps = omitThemingProps(props);
  const { direction } = useTheme();
  const { descendants, ...ctx } = useMenu({ ...ownProps, direction });
  const context = useMemo(() => ctx, [ctx]);
  const { isOpen, onClose, forceUpdate } = context;
  return /* @__PURE__ */ jsx(MenuDescendantsProvider, { value: descendants, children: /* @__PURE__ */ jsx(MenuProvider, { value: context, children: /* @__PURE__ */ jsx(MenuStylesProvider, { value: styles, children: runIfFn(children, { isOpen, onClose, forceUpdate }) }) }) });
};
Menu.displayName = "Menu";

export {
  useMenuStyles,
  Menu
};
//# sourceMappingURL=chunk-UZJ3TPNQ.mjs.map