'use client'
import {
  useMenuStyles
} from "./chunk-UZJ3TPNQ.mjs";
import {
  useMenuButton
} from "./chunk-SANI5SUM.mjs";

// src/menu-button.tsx
import { forwardRef, chakra } from "@chakra-ui/system";
import { cx } from "@chakra-ui/shared-utils";
import { jsx } from "react/jsx-runtime";
var StyledMenuButton = forwardRef((props, ref) => {
  const styles = useMenuStyles();
  return /* @__PURE__ */ jsx(
    chakra.button,
    {
      ref,
      ...props,
      __css: {
        display: "inline-flex",
        appearance: "none",
        alignItems: "center",
        outline: 0,
        ...styles.button
      }
    }
  );
});
var MenuButton = forwardRef(
  (props, ref) => {
    const { children, as: As, ...rest } = props;
    const buttonProps = useMenuButton(rest, ref);
    const Element = As || StyledMenuButton;
    return /* @__PURE__ */ jsx(
      Element,
      {
        ...buttonProps,
        className: cx("chakra-menu__menu-button", props.className),
        children: /* @__PURE__ */ jsx(
          chakra.span,
          {
            __css: { pointerEvents: "none", flex: "1 1 auto", minW: 0 },
            children: props.children
          }
        )
      }
    );
  }
);
MenuButton.displayName = "MenuButton";

export {
  MenuButton
};
//# sourceMappingURL=chunk-Z3VR2BFQ.mjs.map