import * as _chakra_ui_descendant from '@chakra-ui/descendant';
import { UsePopperProps } from '@chakra-ui/popper';
import { UseDisclosureProps } from '@chakra-ui/react-use-disclosure';
import { LazyMode } from '@chakra-ui/lazy-utils';
import React from 'react';

declare const MenuDescendantsProvider: React.Provider<_chakra_ui_descendant.DescendantsManager<HTMLElement, {}>>;
declare const useMenuDescendantsContext: () => _chakra_ui_descendant.DescendantsManager<HTMLElement, {}>;
declare const useMenuDescendants: () => _chakra_ui_descendant.DescendantsManager<HTMLElement, {}>;
declare const useMenuDescendant: (options?: {
    disabled?: boolean | undefined;
    id?: string | undefined;
} | undefined) => {
    descendants: _chakra_ui_descendant.UseDescendantsReturn;
    index: number;
    enabledIndex: number;
    register: (node: HTMLElement | null) => void;
};
declare const MenuProvider: React.Provider<Omit<UseMenuReturn, "descendants">>;
declare const useMenuContext: () => Omit<UseMenuReturn, "descendants">;
interface UseMenuProps extends Omit<UsePopperProps, "enabled">, UseDisclosureProps {
    /**
     * The `ref` of the element that should receive focus when the popover opens.
     */
    initialFocusRef?: React.RefObject<{
        focus(): void;
    }>;
    /**
     * If `true`, the menu will close when a menu item is
     * clicked
     *
     * @default true
     */
    closeOnSelect?: boolean;
    /**
     * If `true`, the menu will close when you click outside
     * the menu list
     *
     * @default true
     */
    closeOnBlur?: boolean;
    /**
     * If `true`, the first enabled menu item will receive focus and be selected
     * when the menu opens.
     *
     * @default true
     */
    autoSelect?: boolean;
    /**
     * Performance 🚀:
     * If `true`, the MenuItem rendering will be deferred
     * until the menu is open.
     *
     * @default false
     */
    isLazy?: boolean;
    /**
     * Performance 🚀:
     * The lazy behavior of menu's content when not visible.
     * Only works when `isLazy={true}`
     *
     * - "unmount": The menu's content is always unmounted when not open.
     * - "keepMounted": The menu's content initially unmounted,
     * but stays mounted when menu is open.
     *
     * @default "unmount"
     */
    lazyBehavior?: LazyMode;
    /**
     * If `rtl`, proper placement positions will be flipped i.e. 'top-right' will
     * become 'top-left' and vice-verse
     */
    direction?: "ltr" | "rtl";
    computePositionOnMount?: boolean;
}
/**
 * React Hook to manage a menu
 *
 * It provides the logic and will be used with react context
 * to propagate its return value to all children
 */
declare function useMenu(props?: UseMenuProps): {
    openAndFocusMenu: () => void;
    openAndFocusFirstItem: () => void;
    openAndFocusLastItem: () => void;
    onTransitionEnd: () => void;
    unstable__animationState: {
        present: boolean;
        onComplete(): void;
    };
    descendants: _chakra_ui_descendant.DescendantsManager<HTMLElement, {}>;
    popper: any;
    buttonId: string;
    menuId: string;
    forceUpdate: any;
    orientation: string;
    isOpen: boolean;
    onToggle: () => void;
    onOpen: () => void;
    onClose: () => void;
    menuRef: React.RefObject<HTMLDivElement>;
    buttonRef: React.RefObject<HTMLButtonElement>;
    focusedIndex: number;
    closeOnSelect: boolean;
    closeOnBlur: boolean;
    autoSelect: boolean;
    setFocusedIndex: React.Dispatch<React.SetStateAction<number>>;
    isLazy: boolean | undefined;
    lazyBehavior: LazyMode;
    initialFocusRef: React.RefObject<{
        focus(): void;
    }> | undefined;
    rafId: React.MutableRefObject<number | null>;
};
interface UseMenuReturn extends ReturnType<typeof useMenu> {
}
interface UseMenuButtonProps extends Omit<React.HTMLAttributes<Element>, "color"> {
}
/**
 * React Hook to manage a menu button.
 *
 * The assumption here is that the `useMenu` hook is used
 * in a component higher up the tree, and its return value
 * is passed as `context` to this hook.
 */
declare function useMenuButton(props?: UseMenuButtonProps, externalRef?: React.Ref<any>): {
    ref: (node: any) => void;
    id: string;
    "data-active": boolean | "true" | "false";
    "aria-expanded": boolean;
    "aria-haspopup": boolean | "dialog" | "menu" | "true" | "false" | "grid" | "listbox" | "tree" | undefined;
    "aria-controls": string;
    onClick: (event: React.MouseEvent<Element, MouseEvent>) => void;
    onKeyDown: (event: React.KeyboardEvent<Element>) => void;
    defaultValue?: string | number | readonly string[] | undefined;
    children?: React.ReactNode;
    style?: React.CSSProperties | undefined;
    slot?: string | undefined;
    title?: string | undefined;
    nonce?: string | undefined;
    dangerouslySetInnerHTML?: {
        __html: string | TrustedHTML;
    } | undefined;
    content?: string | undefined;
    translate?: "yes" | "no" | undefined;
    property?: string | undefined;
    hidden?: boolean | undefined;
    'aria-disabled'?: (boolean | "true" | "false") | undefined;
    dir?: string | undefined;
    defaultChecked?: boolean | undefined;
    suppressContentEditableWarning?: boolean | undefined;
    suppressHydrationWarning?: boolean | undefined;
    accessKey?: string | undefined;
    autoFocus?: boolean | undefined;
    className?: string | undefined;
    contentEditable?: "inherit" | (boolean | "true" | "false") | undefined;
    contextMenu?: string | undefined;
    draggable?: (boolean | "true" | "false") | undefined;
    lang?: string | undefined;
    placeholder?: string | undefined;
    spellCheck?: (boolean | "true" | "false") | undefined;
    tabIndex?: number | undefined;
    radioGroup?: string | undefined;
    role?: React.AriaRole | undefined;
    about?: string | undefined;
    datatype?: string | undefined;
    inlist?: any;
    prefix?: string | undefined;
    rel?: string | undefined;
    resource?: string | undefined;
    rev?: string | undefined;
    typeof?: string | undefined;
    vocab?: string | undefined;
    autoCapitalize?: string | undefined;
    autoCorrect?: string | undefined;
    autoSave?: string | undefined;
    itemProp?: string | undefined;
    itemScope?: boolean | undefined;
    itemType?: string | undefined;
    itemID?: string | undefined;
    itemRef?: string | undefined;
    results?: number | undefined;
    security?: string | undefined;
    unselectable?: "on" | "off" | undefined;
    inputMode?: "search" | "text" | "none" | "email" | "tel" | "url" | "numeric" | "decimal" | undefined;
    is?: string | undefined;
    'aria-activedescendant'?: string | undefined;
    'aria-atomic'?: (boolean | "true" | "false") | undefined;
    'aria-autocomplete'?: "none" | "both" | "inline" | "list" | undefined;
    'aria-braillelabel'?: string | undefined;
    'aria-brailleroledescription'?: string | undefined;
    'aria-busy'?: (boolean | "true" | "false") | undefined;
    'aria-checked'?: boolean | "true" | "false" | "mixed" | undefined;
    'aria-colcount'?: number | undefined;
    'aria-colindex'?: number | undefined;
    'aria-colindextext'?: string | undefined;
    'aria-colspan'?: number | undefined;
    'aria-current'?: boolean | "time" | "true" | "false" | "page" | "location" | "step" | "date" | undefined;
    'aria-describedby'?: string | undefined;
    'aria-description'?: string | undefined;
    'aria-details'?: string | undefined;
    'aria-dropeffect'?: "link" | "none" | "copy" | "move" | "execute" | "popup" | undefined;
    'aria-errormessage'?: string | undefined;
    'aria-flowto'?: string | undefined;
    'aria-grabbed'?: (boolean | "true" | "false") | undefined;
    'aria-hidden'?: (boolean | "true" | "false") | undefined;
    'aria-invalid'?: boolean | "true" | "false" | "grammar" | "spelling" | undefined;
    'aria-keyshortcuts'?: string | undefined;
    'aria-label'?: string | undefined;
    'aria-labelledby'?: string | undefined;
    'aria-level'?: number | undefined;
    'aria-live'?: "off" | "assertive" | "polite" | undefined;
    'aria-modal'?: (boolean | "true" | "false") | undefined;
    'aria-multiline'?: (boolean | "true" | "false") | undefined;
    'aria-multiselectable'?: (boolean | "true" | "false") | undefined;
    'aria-orientation'?: "horizontal" | "vertical" | undefined;
    'aria-owns'?: string | undefined;
    'aria-placeholder'?: string | undefined;
    'aria-posinset'?: number | undefined;
    'aria-pressed'?: boolean | "true" | "false" | "mixed" | undefined;
    'aria-readonly'?: (boolean | "true" | "false") | undefined;
    'aria-relevant'?: "text" | "all" | "additions" | "additions removals" | "additions text" | "removals" | "removals additions" | "removals text" | "text additions" | "text removals" | undefined;
    'aria-required'?: (boolean | "true" | "false") | undefined;
    'aria-roledescription'?: string | undefined;
    'aria-rowcount'?: number | undefined;
    'aria-rowindex'?: number | undefined;
    'aria-rowindextext'?: string | undefined;
    'aria-rowspan'?: number | undefined;
    'aria-selected'?: (boolean | "true" | "false") | undefined;
    'aria-setsize'?: number | undefined;
    'aria-sort'?: "none" | "ascending" | "descending" | "other" | undefined;
    'aria-valuemax'?: number | undefined;
    'aria-valuemin'?: number | undefined;
    'aria-valuenow'?: number | undefined;
    'aria-valuetext'?: string | undefined;
    onCopy?: React.ClipboardEventHandler<Element> | undefined;
    onCopyCapture?: React.ClipboardEventHandler<Element> | undefined;
    onCut?: React.ClipboardEventHandler<Element> | undefined;
    onCutCapture?: React.ClipboardEventHandler<Element> | undefined;
    onPaste?: React.ClipboardEventHandler<Element> | undefined;
    onPasteCapture?: React.ClipboardEventHandler<Element> | undefined;
    onCompositionEnd?: React.CompositionEventHandler<Element> | undefined;
    onCompositionEndCapture?: React.CompositionEventHandler<Element> | undefined;
    onCompositionStart?: React.CompositionEventHandler<Element> | undefined;
    onCompositionStartCapture?: React.CompositionEventHandler<Element> | undefined;
    onCompositionUpdate?: React.CompositionEventHandler<Element> | undefined;
    onCompositionUpdateCapture?: React.CompositionEventHandler<Element> | undefined;
    onFocus?: React.FocusEventHandler<Element> | undefined;
    onFocusCapture?: React.FocusEventHandler<Element> | undefined;
    onBlur?: React.FocusEventHandler<Element> | undefined;
    onBlurCapture?: React.FocusEventHandler<Element> | undefined;
    onChange?: React.FormEventHandler<Element> | undefined;
    onChangeCapture?: React.FormEventHandler<Element> | undefined;
    onBeforeInput?: React.FormEventHandler<Element> | undefined;
    onBeforeInputCapture?: React.FormEventHandler<Element> | undefined;
    onInput?: React.FormEventHandler<Element> | undefined;
    onInputCapture?: React.FormEventHandler<Element> | undefined;
    onReset?: React.FormEventHandler<Element> | undefined;
    onResetCapture?: React.FormEventHandler<Element> | undefined;
    onSubmit?: React.FormEventHandler<Element> | undefined;
    onSubmitCapture?: React.FormEventHandler<Element> | undefined;
    onInvalid?: React.FormEventHandler<Element> | undefined;
    onInvalidCapture?: React.FormEventHandler<Element> | undefined;
    onLoad?: React.ReactEventHandler<Element> | undefined;
    onLoadCapture?: React.ReactEventHandler<Element> | undefined;
    onError?: React.ReactEventHandler<Element> | undefined;
    onErrorCapture?: React.ReactEventHandler<Element> | undefined;
    onKeyDownCapture?: React.KeyboardEventHandler<Element> | undefined;
    onKeyPress?: React.KeyboardEventHandler<Element> | undefined;
    onKeyPressCapture?: React.KeyboardEventHandler<Element> | undefined;
    onKeyUp?: React.KeyboardEventHandler<Element> | undefined;
    onKeyUpCapture?: React.KeyboardEventHandler<Element> | undefined;
    onAbort?: React.ReactEventHandler<Element> | undefined;
    onAbortCapture?: React.ReactEventHandler<Element> | undefined;
    onCanPlay?: React.ReactEventHandler<Element> | undefined;
    onCanPlayCapture?: React.ReactEventHandler<Element> | undefined;
    onCanPlayThrough?: React.ReactEventHandler<Element> | undefined;
    onCanPlayThroughCapture?: React.ReactEventHandler<Element> | undefined;
    onDurationChange?: React.ReactEventHandler<Element> | undefined;
    onDurationChangeCapture?: React.ReactEventHandler<Element> | undefined;
    onEmptied?: React.ReactEventHandler<Element> | undefined;
    onEmptiedCapture?: React.ReactEventHandler<Element> | undefined;
    onEncrypted?: React.ReactEventHandler<Element> | undefined;
    onEncryptedCapture?: React.ReactEventHandler<Element> | undefined;
    onEnded?: React.ReactEventHandler<Element> | undefined;
    onEndedCapture?: React.ReactEventHandler<Element> | undefined;
    onLoadedData?: React.ReactEventHandler<Element> | undefined;
    onLoadedDataCapture?: React.ReactEventHandler<Element> | undefined;
    onLoadedMetadata?: React.ReactEventHandler<Element> | undefined;
    onLoadedMetadataCapture?: React.ReactEventHandler<Element> | undefined;
    onLoadStart?: React.ReactEventHandler<Element> | undefined;
    onLoadStartCapture?: React.ReactEventHandler<Element> | undefined;
    onPause?: React.ReactEventHandler<Element> | undefined;
    onPauseCapture?: React.ReactEventHandler<Element> | undefined;
    onPlay?: React.ReactEventHandler<Element> | undefined;
    onPlayCapture?: React.ReactEventHandler<Element> | undefined;
    onPlaying?: React.ReactEventHandler<Element> | undefined;
    onPlayingCapture?: React.ReactEventHandler<Element> | undefined;
    onProgress?: React.ReactEventHandler<Element> | undefined;
    onProgressCapture?: React.ReactEventHandler<Element> | undefined;
    onRateChange?: React.ReactEventHandler<Element> | undefined;
    onRateChangeCapture?: React.ReactEventHandler<Element> | undefined;
    onResize?: React.ReactEventHandler<Element> | undefined;
    onResizeCapture?: React.ReactEventHandler<Element> | undefined;
    onSeeked?: React.ReactEventHandler<Element> | undefined;
    onSeekedCapture?: React.ReactEventHandler<Element> | undefined;
    onSeeking?: React.ReactEventHandler<Element> | undefined;
    onSeekingCapture?: React.ReactEventHandler<Element> | undefined;
    onStalled?: React.ReactEventHandler<Element> | undefined;
    onStalledCapture?: React.ReactEventHandler<Element> | undefined;
    onSuspend?: React.ReactEventHandler<Element> | undefined;
    onSuspendCapture?: React.ReactEventHandler<Element> | undefined;
    onTimeUpdate?: React.ReactEventHandler<Element> | undefined;
    onTimeUpdateCapture?: React.ReactEventHandler<Element> | undefined;
    onVolumeChange?: React.ReactEventHandler<Element> | undefined;
    onVolumeChangeCapture?: React.ReactEventHandler<Element> | undefined;
    onWaiting?: React.ReactEventHandler<Element> | undefined;
    onWaitingCapture?: React.ReactEventHandler<Element> | undefined;
    onAuxClick?: React.MouseEventHandler<Element> | undefined;
    onAuxClickCapture?: React.MouseEventHandler<Element> | undefined;
    onClickCapture?: React.MouseEventHandler<Element> | undefined;
    onContextMenu?: React.MouseEventHandler<Element> | undefined;
    onContextMenuCapture?: React.MouseEventHandler<Element> | undefined;
    onDoubleClick?: React.MouseEventHandler<Element> | undefined;
    onDoubleClickCapture?: React.MouseEventHandler<Element> | undefined;
    onDrag?: React.DragEventHandler<Element> | undefined;
    onDragCapture?: React.DragEventHandler<Element> | undefined;
    onDragEnd?: React.DragEventHandler<Element> | undefined;
    onDragEndCapture?: React.DragEventHandler<Element> | undefined;
    onDragEnter?: React.DragEventHandler<Element> | undefined;
    onDragEnterCapture?: React.DragEventHandler<Element> | undefined;
    onDragExit?: React.DragEventHandler<Element> | undefined;
    onDragExitCapture?: React.DragEventHandler<Element> | undefined;
    onDragLeave?: React.DragEventHandler<Element> | undefined;
    onDragLeaveCapture?: React.DragEventHandler<Element> | undefined;
    onDragOver?: React.DragEventHandler<Element> | undefined;
    onDragOverCapture?: React.DragEventHandler<Element> | undefined;
    onDragStart?: React.DragEventHandler<Element> | undefined;
    onDragStartCapture?: React.DragEventHandler<Element> | undefined;
    onDrop?: React.DragEventHandler<Element> | undefined;
    onDropCapture?: React.DragEventHandler<Element> | undefined;
    onMouseDown?: React.MouseEventHandler<Element> | undefined;
    onMouseDownCapture?: React.MouseEventHandler<Element> | undefined;
    onMouseEnter?: React.MouseEventHandler<Element> | undefined;
    onMouseLeave?: React.MouseEventHandler<Element> | undefined;
    onMouseMove?: React.MouseEventHandler<Element> | undefined;
    onMouseMoveCapture?: React.MouseEventHandler<Element> | undefined;
    onMouseOut?: React.MouseEventHandler<Element> | undefined;
    onMouseOutCapture?: React.MouseEventHandler<Element> | undefined;
    onMouseOver?: React.MouseEventHandler<Element> | undefined;
    onMouseOverCapture?: React.MouseEventHandler<Element> | undefined;
    onMouseUp?: React.MouseEventHandler<Element> | undefined;
    onMouseUpCapture?: React.MouseEventHandler<Element> | undefined;
    onSelect?: React.ReactEventHandler<Element> | undefined;
    onSelectCapture?: React.ReactEventHandler<Element> | undefined;
    onTouchCancel?: React.TouchEventHandler<Element> | undefined;
    onTouchCancelCapture?: React.TouchEventHandler<Element> | undefined;
    onTouchEnd?: React.TouchEventHandler<Element> | undefined;
    onTouchEndCapture?: React.TouchEventHandler<Element> | undefined;
    onTouchMove?: React.TouchEventHandler<Element> | undefined;
    onTouchMoveCapture?: React.TouchEventHandler<Element> | undefined;
    onTouchStart?: React.TouchEventHandler<Element> | undefined;
    onTouchStartCapture?: React.TouchEventHandler<Element> | undefined;
    onPointerDown?: React.PointerEventHandler<Element> | undefined;
    onPointerDownCapture?: React.PointerEventHandler<Element> | undefined;
    onPointerMove?: React.PointerEventHandler<Element> | undefined;
    onPointerMoveCapture?: React.PointerEventHandler<Element> | undefined;
    onPointerUp?: React.PointerEventHandler<Element> | undefined;
    onPointerUpCapture?: React.PointerEventHandler<Element> | undefined;
    onPointerCancel?: React.PointerEventHandler<Element> | undefined;
    onPointerCancelCapture?: React.PointerEventHandler<Element> | undefined;
    onPointerEnter?: React.PointerEventHandler<Element> | undefined;
    onPointerEnterCapture?: React.PointerEventHandler<Element> | undefined;
    onPointerLeave?: React.PointerEventHandler<Element> | undefined;
    onPointerLeaveCapture?: React.PointerEventHandler<Element> | undefined;
    onPointerOver?: React.PointerEventHandler<Element> | undefined;
    onPointerOverCapture?: React.PointerEventHandler<Element> | undefined;
    onPointerOut?: React.PointerEventHandler<Element> | undefined;
    onPointerOutCapture?: React.PointerEventHandler<Element> | undefined;
    onGotPointerCapture?: React.PointerEventHandler<Element> | undefined;
    onGotPointerCaptureCapture?: React.PointerEventHandler<Element> | undefined;
    onLostPointerCapture?: React.PointerEventHandler<Element> | undefined;
    onLostPointerCaptureCapture?: React.PointerEventHandler<Element> | undefined;
    onScroll?: React.UIEventHandler<Element> | undefined;
    onScrollCapture?: React.UIEventHandler<Element> | undefined;
    onWheel?: React.WheelEventHandler<Element> | undefined;
    onWheelCapture?: React.WheelEventHandler<Element> | undefined;
    onAnimationStart?: React.AnimationEventHandler<Element> | undefined;
    onAnimationStartCapture?: React.AnimationEventHandler<Element> | undefined;
    onAnimationEnd?: React.AnimationEventHandler<Element> | undefined;
    onAnimationEndCapture?: React.AnimationEventHandler<Element> | undefined;
    onAnimationIteration?: React.AnimationEventHandler<Element> | undefined;
    onAnimationIterationCapture?: React.AnimationEventHandler<Element> | undefined;
    onTransitionEnd?: React.TransitionEventHandler<Element> | undefined;
    onTransitionEndCapture?: React.TransitionEventHandler<Element> | undefined;
};
interface UseMenuListProps extends Omit<React.HTMLAttributes<Element>, "color"> {
}
/**
 * React Hook to manage a menu list.
 *
 * The assumption here is that the `useMenu` hook is used
 * in a component higher up the tree, and its return value
 * is passed as `context` to this hook.
 */
declare function useMenuList(props?: UseMenuListProps, ref?: React.Ref<any>): React.HTMLAttributes<HTMLElement> & React.RefAttributes<HTMLElement>;
declare function useMenuPositioner(props?: any): any;
interface UseMenuItemProps extends Omit<React.HTMLAttributes<Element>, "color" | "disabled"> {
    /**
     * If `true`, the menuitem will be disabled
     */
    isDisabled?: boolean;
    /**
     * If `true` and the menuitem is disabled, it'll
     * remain keyboard-focusable
     */
    isFocusable?: boolean;
    /**
     * Overrides the parent menu's `closeOnSelect` prop.
     */
    closeOnSelect?: boolean;
    /**
     * The type of the menuitem.
     */
    type?: React.ButtonHTMLAttributes<HTMLButtonElement>["type"];
}
declare function useMenuItem(props?: UseMenuItemProps, externalRef?: React.Ref<any>): {
    type: any;
    id: string;
    role: string;
    tabIndex: number;
    ref: (node: any) => void;
    "aria-disabled": boolean | undefined;
    disabled: boolean | undefined;
    onClick: (event: React.MouseEvent<HTMLElement, MouseEvent>) => void;
    onMouseDown: React.MouseEventHandler<HTMLElement> | undefined;
    onMouseUp: React.MouseEventHandler<HTMLElement> | undefined;
    onKeyUp: React.KeyboardEventHandler<HTMLElement> | undefined;
    onKeyDown: React.KeyboardEventHandler<HTMLElement> | undefined;
    onMouseOver: React.MouseEventHandler<HTMLElement> | undefined;
    onMouseLeave: React.MouseEventHandler<HTMLElement> | undefined;
    defaultChecked?: boolean | undefined;
    defaultValue?: string | number | readonly string[] | undefined;
    suppressContentEditableWarning?: boolean | undefined;
    suppressHydrationWarning?: boolean | undefined;
    accessKey?: string | undefined;
    autoFocus?: boolean | undefined;
    className?: string | undefined;
    contentEditable?: "inherit" | (boolean | "true" | "false") | undefined;
    contextMenu?: string | undefined;
    dir?: string | undefined;
    draggable?: (boolean | "true" | "false") | undefined;
    hidden?: boolean | undefined;
    lang?: string | undefined;
    nonce?: string | undefined;
    placeholder?: string | undefined;
    slot?: string | undefined;
    spellCheck?: (boolean | "true" | "false") | undefined;
    style?: React.CSSProperties | undefined;
    title?: string | undefined;
    translate?: "yes" | "no" | undefined;
    radioGroup?: string | undefined;
    about?: string | undefined;
    content?: string | undefined;
    datatype?: string | undefined;
    inlist?: any;
    prefix?: string | undefined;
    property?: string | undefined;
    rel?: string | undefined;
    resource?: string | undefined;
    rev?: string | undefined;
    typeof?: string | undefined;
    vocab?: string | undefined;
    autoCapitalize?: string | undefined;
    autoCorrect?: string | undefined;
    autoSave?: string | undefined;
    color?: string | undefined;
    itemProp?: string | undefined;
    itemScope?: boolean | undefined;
    itemType?: string | undefined;
    itemID?: string | undefined;
    itemRef?: string | undefined;
    results?: number | undefined;
    security?: string | undefined;
    unselectable?: "on" | "off" | undefined;
    inputMode?: "search" | "text" | "none" | "email" | "tel" | "url" | "numeric" | "decimal" | undefined;
    is?: string | undefined;
    'aria-activedescendant'?: string | undefined;
    'aria-atomic'?: (boolean | "true" | "false") | undefined;
    'aria-autocomplete'?: "none" | "both" | "inline" | "list" | undefined;
    'aria-braillelabel'?: string | undefined;
    'aria-brailleroledescription'?: string | undefined;
    'aria-busy'?: (boolean | "true" | "false") | undefined;
    'aria-checked'?: boolean | "true" | "false" | "mixed" | undefined;
    'aria-colcount'?: number | undefined;
    'aria-colindex'?: number | undefined;
    'aria-colindextext'?: string | undefined;
    'aria-colspan'?: number | undefined;
    'aria-controls'?: string | undefined;
    'aria-current'?: boolean | "time" | "true" | "false" | "page" | "location" | "step" | "date" | undefined;
    'aria-describedby'?: string | undefined;
    'aria-description'?: string | undefined;
    'aria-details'?: string | undefined;
    'aria-dropeffect'?: "link" | "none" | "copy" | "move" | "execute" | "popup" | undefined;
    'aria-errormessage'?: string | undefined;
    'aria-expanded'?: (boolean | "true" | "false") | undefined;
    'aria-flowto'?: string | undefined;
    'aria-grabbed'?: (boolean | "true" | "false") | undefined;
    'aria-haspopup'?: boolean | "dialog" | "menu" | "true" | "false" | "grid" | "listbox" | "tree" | undefined;
    'aria-hidden'?: (boolean | "true" | "false") | undefined;
    'aria-invalid'?: boolean | "true" | "false" | "grammar" | "spelling" | undefined;
    'aria-keyshortcuts'?: string | undefined;
    'aria-label'?: string | undefined;
    'aria-labelledby'?: string | undefined;
    'aria-level'?: number | undefined;
    'aria-live'?: "off" | "assertive" | "polite" | undefined;
    'aria-modal'?: (boolean | "true" | "false") | undefined;
    'aria-multiline'?: (boolean | "true" | "false") | undefined;
    'aria-multiselectable'?: (boolean | "true" | "false") | undefined;
    'aria-orientation'?: "horizontal" | "vertical" | undefined;
    'aria-owns'?: string | undefined;
    'aria-placeholder'?: string | undefined;
    'aria-posinset'?: number | undefined;
    'aria-pressed'?: boolean | "true" | "false" | "mixed" | undefined;
    'aria-readonly'?: (boolean | "true" | "false") | undefined;
    'aria-relevant'?: "text" | "all" | "additions" | "additions removals" | "additions text" | "removals" | "removals additions" | "removals text" | "text additions" | "text removals" | undefined;
    'aria-required'?: (boolean | "true" | "false") | undefined;
    'aria-roledescription'?: string | undefined;
    'aria-rowcount'?: number | undefined;
    'aria-rowindex'?: number | undefined;
    'aria-rowindextext'?: string | undefined;
    'aria-rowspan'?: number | undefined;
    'aria-selected'?: (boolean | "true" | "false") | undefined;
    'aria-setsize'?: number | undefined;
    'aria-sort'?: "none" | "ascending" | "descending" | "other" | undefined;
    'aria-valuemax'?: number | undefined;
    'aria-valuemin'?: number | undefined;
    'aria-valuenow'?: number | undefined;
    'aria-valuetext'?: string | undefined;
    children?: React.ReactNode;
    dangerouslySetInnerHTML?: {
        __html: string | TrustedHTML;
    } | undefined;
    onCopy?: React.ClipboardEventHandler<HTMLElement> | undefined;
    onCopyCapture?: React.ClipboardEventHandler<HTMLElement> | undefined;
    onCut?: React.ClipboardEventHandler<HTMLElement> | undefined;
    onCutCapture?: React.ClipboardEventHandler<HTMLElement> | undefined;
    onPaste?: React.ClipboardEventHandler<HTMLElement> | undefined;
    onPasteCapture?: React.ClipboardEventHandler<HTMLElement> | undefined;
    onCompositionEnd?: React.CompositionEventHandler<HTMLElement> | undefined;
    onCompositionEndCapture?: React.CompositionEventHandler<HTMLElement> | undefined;
    onCompositionStart?: React.CompositionEventHandler<HTMLElement> | undefined;
    onCompositionStartCapture?: React.CompositionEventHandler<HTMLElement> | undefined;
    onCompositionUpdate?: React.CompositionEventHandler<HTMLElement> | undefined;
    onCompositionUpdateCapture?: React.CompositionEventHandler<HTMLElement> | undefined;
    onFocus?: React.FocusEventHandler<HTMLElement> | undefined;
    onFocusCapture?: React.FocusEventHandler<HTMLElement> | undefined;
    onBlur?: React.FocusEventHandler<HTMLElement> | undefined;
    onBlurCapture?: React.FocusEventHandler<HTMLElement> | undefined;
    onChange?: React.FormEventHandler<HTMLElement> | undefined;
    onChangeCapture?: React.FormEventHandler<HTMLElement> | undefined;
    onBeforeInput?: React.FormEventHandler<HTMLElement> | undefined;
    onBeforeInputCapture?: React.FormEventHandler<HTMLElement> | undefined;
    onInput?: React.FormEventHandler<HTMLElement> | undefined;
    onInputCapture?: React.FormEventHandler<HTMLElement> | undefined;
    onReset?: React.FormEventHandler<HTMLElement> | undefined;
    onResetCapture?: React.FormEventHandler<HTMLElement> | undefined;
    onSubmit?: React.FormEventHandler<HTMLElement> | undefined;
    onSubmitCapture?: React.FormEventHandler<HTMLElement> | undefined;
    onInvalid?: React.FormEventHandler<HTMLElement> | undefined;
    onInvalidCapture?: React.FormEventHandler<HTMLElement> | undefined;
    onLoad?: React.ReactEventHandler<HTMLElement> | undefined;
    onLoadCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onError?: React.ReactEventHandler<HTMLElement> | undefined;
    onErrorCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onKeyDownCapture?: React.KeyboardEventHandler<Element> | undefined;
    onKeyPress?: React.KeyboardEventHandler<Element> | undefined;
    onKeyPressCapture?: React.KeyboardEventHandler<Element> | undefined;
    onKeyUpCapture?: React.KeyboardEventHandler<Element> | undefined;
    onAbort?: React.ReactEventHandler<HTMLElement> | undefined;
    onAbortCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onCanPlay?: React.ReactEventHandler<HTMLElement> | undefined;
    onCanPlayCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onCanPlayThrough?: React.ReactEventHandler<HTMLElement> | undefined;
    onCanPlayThroughCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onDurationChange?: React.ReactEventHandler<HTMLElement> | undefined;
    onDurationChangeCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onEmptied?: React.ReactEventHandler<HTMLElement> | undefined;
    onEmptiedCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onEncrypted?: React.ReactEventHandler<HTMLElement> | undefined;
    onEncryptedCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onEnded?: React.ReactEventHandler<HTMLElement> | undefined;
    onEndedCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onLoadedData?: React.ReactEventHandler<HTMLElement> | undefined;
    onLoadedDataCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onLoadedMetadata?: React.ReactEventHandler<HTMLElement> | undefined;
    onLoadedMetadataCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onLoadStart?: React.ReactEventHandler<HTMLElement> | undefined;
    onLoadStartCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onPause?: React.ReactEventHandler<HTMLElement> | undefined;
    onPauseCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onPlay?: React.ReactEventHandler<HTMLElement> | undefined;
    onPlayCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onPlaying?: React.ReactEventHandler<HTMLElement> | undefined;
    onPlayingCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onProgress?: React.ReactEventHandler<HTMLElement> | undefined;
    onProgressCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onRateChange?: React.ReactEventHandler<HTMLElement> | undefined;
    onRateChangeCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onResize?: React.ReactEventHandler<HTMLElement> | undefined;
    onResizeCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onSeeked?: React.ReactEventHandler<HTMLElement> | undefined;
    onSeekedCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onSeeking?: React.ReactEventHandler<HTMLElement> | undefined;
    onSeekingCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onStalled?: React.ReactEventHandler<HTMLElement> | undefined;
    onStalledCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onSuspend?: React.ReactEventHandler<HTMLElement> | undefined;
    onSuspendCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onTimeUpdate?: React.ReactEventHandler<HTMLElement> | undefined;
    onTimeUpdateCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onVolumeChange?: React.ReactEventHandler<HTMLElement> | undefined;
    onVolumeChangeCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onWaiting?: React.ReactEventHandler<HTMLElement> | undefined;
    onWaitingCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onAuxClick?: React.MouseEventHandler<HTMLElement> | undefined;
    onAuxClickCapture?: React.MouseEventHandler<HTMLElement> | undefined;
    onClickCapture?: React.MouseEventHandler<HTMLElement> | undefined;
    onContextMenu?: React.MouseEventHandler<HTMLElement> | undefined;
    onContextMenuCapture?: React.MouseEventHandler<HTMLElement> | undefined;
    onDoubleClick?: React.MouseEventHandler<HTMLElement> | undefined;
    onDoubleClickCapture?: React.MouseEventHandler<HTMLElement> | undefined;
    onDrag?: React.DragEventHandler<HTMLElement> | undefined;
    onDragCapture?: React.DragEventHandler<HTMLElement> | undefined;
    onDragEnd?: React.DragEventHandler<HTMLElement> | undefined;
    onDragEndCapture?: React.DragEventHandler<HTMLElement> | undefined;
    onDragEnter?: React.DragEventHandler<HTMLElement> | undefined;
    onDragEnterCapture?: React.DragEventHandler<HTMLElement> | undefined;
    onDragExit?: React.DragEventHandler<HTMLElement> | undefined;
    onDragExitCapture?: React.DragEventHandler<HTMLElement> | undefined;
    onDragLeave?: React.DragEventHandler<HTMLElement> | undefined;
    onDragLeaveCapture?: React.DragEventHandler<HTMLElement> | undefined;
    onDragOver?: React.DragEventHandler<HTMLElement> | undefined;
    onDragOverCapture?: React.DragEventHandler<HTMLElement> | undefined;
    onDragStart?: React.DragEventHandler<HTMLElement> | undefined;
    onDragStartCapture?: React.DragEventHandler<HTMLElement> | undefined;
    onDrop?: React.DragEventHandler<HTMLElement> | undefined;
    onDropCapture?: React.DragEventHandler<HTMLElement> | undefined;
    onMouseDownCapture?: React.MouseEventHandler<HTMLElement> | undefined;
    onMouseEnter?: React.MouseEventHandler<HTMLElement> | undefined;
    onMouseMove?: React.MouseEventHandler<HTMLElement> | undefined;
    onMouseMoveCapture?: React.MouseEventHandler<HTMLElement> | undefined;
    onMouseOut?: React.MouseEventHandler<HTMLElement> | undefined;
    onMouseOutCapture?: React.MouseEventHandler<HTMLElement> | undefined;
    onMouseOverCapture?: React.MouseEventHandler<HTMLElement> | undefined;
    onMouseUpCapture?: React.MouseEventHandler<HTMLElement> | undefined;
    onSelect?: React.ReactEventHandler<HTMLElement> | undefined;
    onSelectCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onTouchCancel?: React.TouchEventHandler<HTMLElement> | undefined;
    onTouchCancelCapture?: React.TouchEventHandler<HTMLElement> | undefined;
    onTouchEnd?: React.TouchEventHandler<HTMLElement> | undefined;
    onTouchEndCapture?: React.TouchEventHandler<HTMLElement> | undefined;
    onTouchMove?: React.TouchEventHandler<HTMLElement> | undefined;
    onTouchMoveCapture?: React.TouchEventHandler<HTMLElement> | undefined;
    onTouchStart?: React.TouchEventHandler<HTMLElement> | undefined;
    onTouchStartCapture?: React.TouchEventHandler<HTMLElement> | undefined;
    onPointerDown?: React.PointerEventHandler<HTMLElement> | undefined;
    onPointerDownCapture?: React.PointerEventHandler<HTMLElement> | undefined;
    onPointerMove?: React.PointerEventHandler<HTMLElement> | undefined;
    onPointerMoveCapture?: React.PointerEventHandler<HTMLElement> | undefined;
    onPointerUp?: React.PointerEventHandler<HTMLElement> | undefined;
    onPointerUpCapture?: React.PointerEventHandler<HTMLElement> | undefined;
    onPointerCancel?: React.PointerEventHandler<HTMLElement> | undefined;
    onPointerCancelCapture?: React.PointerEventHandler<HTMLElement> | undefined;
    onPointerEnter?: React.PointerEventHandler<HTMLElement> | undefined;
    onPointerEnterCapture?: React.PointerEventHandler<HTMLElement> | undefined;
    onPointerLeave?: React.PointerEventHandler<HTMLElement> | undefined;
    onPointerLeaveCapture?: React.PointerEventHandler<HTMLElement> | undefined;
    onPointerOver?: React.PointerEventHandler<HTMLElement> | undefined;
    onPointerOverCapture?: React.PointerEventHandler<HTMLElement> | undefined;
    onPointerOut?: React.PointerEventHandler<HTMLElement> | undefined;
    onPointerOutCapture?: React.PointerEventHandler<HTMLElement> | undefined;
    onGotPointerCapture?: React.PointerEventHandler<HTMLElement> | undefined;
    onGotPointerCaptureCapture?: React.PointerEventHandler<HTMLElement> | undefined;
    onLostPointerCapture?: React.PointerEventHandler<HTMLElement> | undefined;
    onLostPointerCaptureCapture?: React.PointerEventHandler<HTMLElement> | undefined;
    onScroll?: React.UIEventHandler<HTMLElement> | undefined;
    onScrollCapture?: React.UIEventHandler<HTMLElement> | undefined;
    onWheel?: React.WheelEventHandler<HTMLElement> | undefined;
    onWheelCapture?: React.WheelEventHandler<HTMLElement> | undefined;
    onAnimationStart?: React.AnimationEventHandler<HTMLElement> | undefined;
    onAnimationStartCapture?: React.AnimationEventHandler<HTMLElement> | undefined;
    onAnimationEnd?: React.AnimationEventHandler<HTMLElement> | undefined;
    onAnimationEndCapture?: React.AnimationEventHandler<HTMLElement> | undefined;
    onAnimationIteration?: React.AnimationEventHandler<HTMLElement> | undefined;
    onAnimationIterationCapture?: React.AnimationEventHandler<HTMLElement> | undefined;
    onTransitionEnd?: React.TransitionEventHandler<HTMLElement> | undefined;
    onTransitionEndCapture?: React.TransitionEventHandler<HTMLElement> | undefined;
} | {
    type: any;
    id: string;
    role: string;
    tabIndex: number;
    ref: (node: any) => void;
    "data-active": boolean | "true" | "false";
    "aria-disabled": "true" | undefined;
    onClick: (event: React.MouseEvent<HTMLElement, MouseEvent>) => void;
    onMouseDown: (event: React.MouseEvent<HTMLElement, MouseEvent>) => void;
    onMouseUp: (event: React.MouseEvent<HTMLElement, MouseEvent>) => void;
    onKeyUp: (event: React.KeyboardEvent<HTMLElement>) => void;
    onKeyDown: (event: React.KeyboardEvent<HTMLElement>) => void;
    onMouseOver: (event: React.MouseEvent<HTMLElement, MouseEvent>) => void;
    onMouseLeave: (event: React.MouseEvent<HTMLElement, MouseEvent>) => void;
    defaultChecked?: boolean | undefined;
    defaultValue?: string | number | readonly string[] | undefined;
    suppressContentEditableWarning?: boolean | undefined;
    suppressHydrationWarning?: boolean | undefined;
    accessKey?: string | undefined;
    autoFocus?: boolean | undefined;
    className?: string | undefined;
    contentEditable?: "inherit" | (boolean | "true" | "false") | undefined;
    contextMenu?: string | undefined;
    dir?: string | undefined;
    draggable?: (boolean | "true" | "false") | undefined;
    hidden?: boolean | undefined;
    lang?: string | undefined;
    nonce?: string | undefined;
    placeholder?: string | undefined;
    slot?: string | undefined;
    spellCheck?: (boolean | "true" | "false") | undefined;
    style?: React.CSSProperties | undefined;
    title?: string | undefined;
    translate?: "yes" | "no" | undefined;
    radioGroup?: string | undefined;
    about?: string | undefined;
    content?: string | undefined;
    datatype?: string | undefined;
    inlist?: any;
    prefix?: string | undefined;
    property?: string | undefined;
    rel?: string | undefined;
    resource?: string | undefined;
    rev?: string | undefined;
    typeof?: string | undefined;
    vocab?: string | undefined;
    autoCapitalize?: string | undefined;
    autoCorrect?: string | undefined;
    autoSave?: string | undefined;
    color?: string | undefined;
    itemProp?: string | undefined;
    itemScope?: boolean | undefined;
    itemType?: string | undefined;
    itemID?: string | undefined;
    itemRef?: string | undefined;
    results?: number | undefined;
    security?: string | undefined;
    unselectable?: "on" | "off" | undefined;
    inputMode?: "search" | "text" | "none" | "email" | "tel" | "url" | "numeric" | "decimal" | undefined;
    is?: string | undefined;
    'aria-activedescendant'?: string | undefined;
    'aria-atomic'?: (boolean | "true" | "false") | undefined;
    'aria-autocomplete'?: "none" | "both" | "inline" | "list" | undefined;
    'aria-braillelabel'?: string | undefined;
    'aria-brailleroledescription'?: string | undefined;
    'aria-busy'?: (boolean | "true" | "false") | undefined;
    'aria-checked'?: boolean | "true" | "false" | "mixed" | undefined;
    'aria-colcount'?: number | undefined;
    'aria-colindex'?: number | undefined;
    'aria-colindextext'?: string | undefined;
    'aria-colspan'?: number | undefined;
    'aria-controls'?: string | undefined;
    'aria-current'?: boolean | "time" | "true" | "false" | "page" | "location" | "step" | "date" | undefined;
    'aria-describedby'?: string | undefined;
    'aria-description'?: string | undefined;
    'aria-details'?: string | undefined;
    'aria-dropeffect'?: "link" | "none" | "copy" | "move" | "execute" | "popup" | undefined;
    'aria-errormessage'?: string | undefined;
    'aria-expanded'?: (boolean | "true" | "false") | undefined;
    'aria-flowto'?: string | undefined;
    'aria-grabbed'?: (boolean | "true" | "false") | undefined;
    'aria-haspopup'?: boolean | "dialog" | "menu" | "true" | "false" | "grid" | "listbox" | "tree" | undefined;
    'aria-hidden'?: (boolean | "true" | "false") | undefined;
    'aria-invalid'?: boolean | "true" | "false" | "grammar" | "spelling" | undefined;
    'aria-keyshortcuts'?: string | undefined;
    'aria-label'?: string | undefined;
    'aria-labelledby'?: string | undefined;
    'aria-level'?: number | undefined;
    'aria-live'?: "off" | "assertive" | "polite" | undefined;
    'aria-modal'?: (boolean | "true" | "false") | undefined;
    'aria-multiline'?: (boolean | "true" | "false") | undefined;
    'aria-multiselectable'?: (boolean | "true" | "false") | undefined;
    'aria-orientation'?: "horizontal" | "vertical" | undefined;
    'aria-owns'?: string | undefined;
    'aria-placeholder'?: string | undefined;
    'aria-posinset'?: number | undefined;
    'aria-pressed'?: boolean | "true" | "false" | "mixed" | undefined;
    'aria-readonly'?: (boolean | "true" | "false") | undefined;
    'aria-relevant'?: "text" | "all" | "additions" | "additions removals" | "additions text" | "removals" | "removals additions" | "removals text" | "text additions" | "text removals" | undefined;
    'aria-required'?: (boolean | "true" | "false") | undefined;
    'aria-roledescription'?: string | undefined;
    'aria-rowcount'?: number | undefined;
    'aria-rowindex'?: number | undefined;
    'aria-rowindextext'?: string | undefined;
    'aria-rowspan'?: number | undefined;
    'aria-selected'?: (boolean | "true" | "false") | undefined;
    'aria-setsize'?: number | undefined;
    'aria-sort'?: "none" | "ascending" | "descending" | "other" | undefined;
    'aria-valuemax'?: number | undefined;
    'aria-valuemin'?: number | undefined;
    'aria-valuenow'?: number | undefined;
    'aria-valuetext'?: string | undefined;
    children?: React.ReactNode;
    dangerouslySetInnerHTML?: {
        __html: string | TrustedHTML;
    } | undefined;
    onCopy?: React.ClipboardEventHandler<HTMLElement> | undefined;
    onCopyCapture?: React.ClipboardEventHandler<HTMLElement> | undefined;
    onCut?: React.ClipboardEventHandler<HTMLElement> | undefined;
    onCutCapture?: React.ClipboardEventHandler<HTMLElement> | undefined;
    onPaste?: React.ClipboardEventHandler<HTMLElement> | undefined;
    onPasteCapture?: React.ClipboardEventHandler<HTMLElement> | undefined;
    onCompositionEnd?: React.CompositionEventHandler<HTMLElement> | undefined;
    onCompositionEndCapture?: React.CompositionEventHandler<HTMLElement> | undefined;
    onCompositionStart?: React.CompositionEventHandler<HTMLElement> | undefined;
    onCompositionStartCapture?: React.CompositionEventHandler<HTMLElement> | undefined;
    onCompositionUpdate?: React.CompositionEventHandler<HTMLElement> | undefined;
    onCompositionUpdateCapture?: React.CompositionEventHandler<HTMLElement> | undefined;
    onFocus?: React.FocusEventHandler<HTMLElement> | undefined;
    onFocusCapture?: React.FocusEventHandler<HTMLElement> | undefined;
    onBlur?: React.FocusEventHandler<HTMLElement> | undefined;
    onBlurCapture?: React.FocusEventHandler<HTMLElement> | undefined;
    onChange?: React.FormEventHandler<HTMLElement> | undefined;
    onChangeCapture?: React.FormEventHandler<HTMLElement> | undefined;
    onBeforeInput?: React.FormEventHandler<HTMLElement> | undefined;
    onBeforeInputCapture?: React.FormEventHandler<HTMLElement> | undefined;
    onInput?: React.FormEventHandler<HTMLElement> | undefined;
    onInputCapture?: React.FormEventHandler<HTMLElement> | undefined;
    onReset?: React.FormEventHandler<HTMLElement> | undefined;
    onResetCapture?: React.FormEventHandler<HTMLElement> | undefined;
    onSubmit?: React.FormEventHandler<HTMLElement> | undefined;
    onSubmitCapture?: React.FormEventHandler<HTMLElement> | undefined;
    onInvalid?: React.FormEventHandler<HTMLElement> | undefined;
    onInvalidCapture?: React.FormEventHandler<HTMLElement> | undefined;
    onLoad?: React.ReactEventHandler<HTMLElement> | undefined;
    onLoadCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onError?: React.ReactEventHandler<HTMLElement> | undefined;
    onErrorCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onKeyDownCapture?: React.KeyboardEventHandler<Element> | undefined;
    onKeyPress?: React.KeyboardEventHandler<Element> | undefined;
    onKeyPressCapture?: React.KeyboardEventHandler<Element> | undefined;
    onKeyUpCapture?: React.KeyboardEventHandler<Element> | undefined;
    onAbort?: React.ReactEventHandler<HTMLElement> | undefined;
    onAbortCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onCanPlay?: React.ReactEventHandler<HTMLElement> | undefined;
    onCanPlayCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onCanPlayThrough?: React.ReactEventHandler<HTMLElement> | undefined;
    onCanPlayThroughCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onDurationChange?: React.ReactEventHandler<HTMLElement> | undefined;
    onDurationChangeCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onEmptied?: React.ReactEventHandler<HTMLElement> | undefined;
    onEmptiedCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onEncrypted?: React.ReactEventHandler<HTMLElement> | undefined;
    onEncryptedCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onEnded?: React.ReactEventHandler<HTMLElement> | undefined;
    onEndedCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onLoadedData?: React.ReactEventHandler<HTMLElement> | undefined;
    onLoadedDataCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onLoadedMetadata?: React.ReactEventHandler<HTMLElement> | undefined;
    onLoadedMetadataCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onLoadStart?: React.ReactEventHandler<HTMLElement> | undefined;
    onLoadStartCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onPause?: React.ReactEventHandler<HTMLElement> | undefined;
    onPauseCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onPlay?: React.ReactEventHandler<HTMLElement> | undefined;
    onPlayCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onPlaying?: React.ReactEventHandler<HTMLElement> | undefined;
    onPlayingCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onProgress?: React.ReactEventHandler<HTMLElement> | undefined;
    onProgressCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onRateChange?: React.ReactEventHandler<HTMLElement> | undefined;
    onRateChangeCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onResize?: React.ReactEventHandler<HTMLElement> | undefined;
    onResizeCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onSeeked?: React.ReactEventHandler<HTMLElement> | undefined;
    onSeekedCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onSeeking?: React.ReactEventHandler<HTMLElement> | undefined;
    onSeekingCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onStalled?: React.ReactEventHandler<HTMLElement> | undefined;
    onStalledCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onSuspend?: React.ReactEventHandler<HTMLElement> | undefined;
    onSuspendCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onTimeUpdate?: React.ReactEventHandler<HTMLElement> | undefined;
    onTimeUpdateCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onVolumeChange?: React.ReactEventHandler<HTMLElement> | undefined;
    onVolumeChangeCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onWaiting?: React.ReactEventHandler<HTMLElement> | undefined;
    onWaitingCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onAuxClick?: React.MouseEventHandler<HTMLElement> | undefined;
    onAuxClickCapture?: React.MouseEventHandler<HTMLElement> | undefined;
    onClickCapture?: React.MouseEventHandler<HTMLElement> | undefined;
    onContextMenu?: React.MouseEventHandler<HTMLElement> | undefined;
    onContextMenuCapture?: React.MouseEventHandler<HTMLElement> | undefined;
    onDoubleClick?: React.MouseEventHandler<HTMLElement> | undefined;
    onDoubleClickCapture?: React.MouseEventHandler<HTMLElement> | undefined;
    onDrag?: React.DragEventHandler<HTMLElement> | undefined;
    onDragCapture?: React.DragEventHandler<HTMLElement> | undefined;
    onDragEnd?: React.DragEventHandler<HTMLElement> | undefined;
    onDragEndCapture?: React.DragEventHandler<HTMLElement> | undefined;
    onDragEnter?: React.DragEventHandler<HTMLElement> | undefined;
    onDragEnterCapture?: React.DragEventHandler<HTMLElement> | undefined;
    onDragExit?: React.DragEventHandler<HTMLElement> | undefined;
    onDragExitCapture?: React.DragEventHandler<HTMLElement> | undefined;
    onDragLeave?: React.DragEventHandler<HTMLElement> | undefined;
    onDragLeaveCapture?: React.DragEventHandler<HTMLElement> | undefined;
    onDragOver?: React.DragEventHandler<HTMLElement> | undefined;
    onDragOverCapture?: React.DragEventHandler<HTMLElement> | undefined;
    onDragStart?: React.DragEventHandler<HTMLElement> | undefined;
    onDragStartCapture?: React.DragEventHandler<HTMLElement> | undefined;
    onDrop?: React.DragEventHandler<HTMLElement> | undefined;
    onDropCapture?: React.DragEventHandler<HTMLElement> | undefined;
    onMouseDownCapture?: React.MouseEventHandler<HTMLElement> | undefined;
    onMouseEnter?: React.MouseEventHandler<HTMLElement> | undefined;
    onMouseMove?: React.MouseEventHandler<HTMLElement> | undefined;
    onMouseMoveCapture?: React.MouseEventHandler<HTMLElement> | undefined;
    onMouseOut?: React.MouseEventHandler<HTMLElement> | undefined;
    onMouseOutCapture?: React.MouseEventHandler<HTMLElement> | undefined;
    onMouseOverCapture?: React.MouseEventHandler<HTMLElement> | undefined;
    onMouseUpCapture?: React.MouseEventHandler<HTMLElement> | undefined;
    onSelect?: React.ReactEventHandler<HTMLElement> | undefined;
    onSelectCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onTouchCancel?: React.TouchEventHandler<HTMLElement> | undefined;
    onTouchCancelCapture?: React.TouchEventHandler<HTMLElement> | undefined;
    onTouchEnd?: React.TouchEventHandler<HTMLElement> | undefined;
    onTouchEndCapture?: React.TouchEventHandler<HTMLElement> | undefined;
    onTouchMove?: React.TouchEventHandler<HTMLElement> | undefined;
    onTouchMoveCapture?: React.TouchEventHandler<HTMLElement> | undefined;
    onTouchStart?: React.TouchEventHandler<HTMLElement> | undefined;
    onTouchStartCapture?: React.TouchEventHandler<HTMLElement> | undefined;
    onPointerDown?: React.PointerEventHandler<HTMLElement> | undefined;
    onPointerDownCapture?: React.PointerEventHandler<HTMLElement> | undefined;
    onPointerMove?: React.PointerEventHandler<HTMLElement> | undefined;
    onPointerMoveCapture?: React.PointerEventHandler<HTMLElement> | undefined;
    onPointerUp?: React.PointerEventHandler<HTMLElement> | undefined;
    onPointerUpCapture?: React.PointerEventHandler<HTMLElement> | undefined;
    onPointerCancel?: React.PointerEventHandler<HTMLElement> | undefined;
    onPointerCancelCapture?: React.PointerEventHandler<HTMLElement> | undefined;
    onPointerEnter?: React.PointerEventHandler<HTMLElement> | undefined;
    onPointerEnterCapture?: React.PointerEventHandler<HTMLElement> | undefined;
    onPointerLeave?: React.PointerEventHandler<HTMLElement> | undefined;
    onPointerLeaveCapture?: React.PointerEventHandler<HTMLElement> | undefined;
    onPointerOver?: React.PointerEventHandler<HTMLElement> | undefined;
    onPointerOverCapture?: React.PointerEventHandler<HTMLElement> | undefined;
    onPointerOut?: React.PointerEventHandler<HTMLElement> | undefined;
    onPointerOutCapture?: React.PointerEventHandler<HTMLElement> | undefined;
    onGotPointerCapture?: React.PointerEventHandler<HTMLElement> | undefined;
    onGotPointerCaptureCapture?: React.PointerEventHandler<HTMLElement> | undefined;
    onLostPointerCapture?: React.PointerEventHandler<HTMLElement> | undefined;
    onLostPointerCaptureCapture?: React.PointerEventHandler<HTMLElement> | undefined;
    onScroll?: React.UIEventHandler<HTMLElement> | undefined;
    onScrollCapture?: React.UIEventHandler<HTMLElement> | undefined;
    onWheel?: React.WheelEventHandler<HTMLElement> | undefined;
    onWheelCapture?: React.WheelEventHandler<HTMLElement> | undefined;
    onAnimationStart?: React.AnimationEventHandler<HTMLElement> | undefined;
    onAnimationStartCapture?: React.AnimationEventHandler<HTMLElement> | undefined;
    onAnimationEnd?: React.AnimationEventHandler<HTMLElement> | undefined;
    onAnimationEndCapture?: React.AnimationEventHandler<HTMLElement> | undefined;
    onAnimationIteration?: React.AnimationEventHandler<HTMLElement> | undefined;
    onAnimationIterationCapture?: React.AnimationEventHandler<HTMLElement> | undefined;
    onTransitionEnd?: React.TransitionEventHandler<HTMLElement> | undefined;
    onTransitionEndCapture?: React.TransitionEventHandler<HTMLElement> | undefined;
};
interface UseMenuOptionOptions {
    value?: string;
    isChecked?: boolean;
    type?: "radio" | "checkbox";
    children?: React.ReactNode;
}
interface UseMenuOptionProps extends Omit<UseMenuItemProps, "type">, UseMenuOptionOptions {
}
declare function useMenuOption(props?: UseMenuOptionProps, ref?: React.Ref<any>): {
    role: string;
    "aria-checked": boolean | "true" | "false" | "mixed" | undefined;
    type: any;
    id: string;
    tabIndex: number;
    ref: (node: any) => void;
    "aria-disabled": boolean | undefined;
    disabled: boolean | undefined;
    onClick: (event: React.MouseEvent<HTMLElement, MouseEvent>) => void;
    onMouseDown: React.MouseEventHandler<HTMLElement> | undefined;
    onMouseUp: React.MouseEventHandler<HTMLElement> | undefined;
    onKeyUp: React.KeyboardEventHandler<HTMLElement> | undefined;
    onKeyDown: React.KeyboardEventHandler<HTMLElement> | undefined;
    onMouseOver: React.MouseEventHandler<HTMLElement> | undefined;
    onMouseLeave: React.MouseEventHandler<HTMLElement> | undefined;
    defaultChecked?: boolean | undefined;
    defaultValue?: string | number | readonly string[] | undefined;
    suppressContentEditableWarning?: boolean | undefined;
    suppressHydrationWarning?: boolean | undefined;
    accessKey?: string | undefined;
    autoFocus?: boolean | undefined;
    className?: string | undefined;
    contentEditable?: "inherit" | (boolean | "true" | "false") | undefined;
    contextMenu?: string | undefined;
    dir?: string | undefined;
    draggable?: (boolean | "true" | "false") | undefined;
    hidden?: boolean | undefined;
    lang?: string | undefined;
    nonce?: string | undefined;
    placeholder?: string | undefined;
    slot?: string | undefined;
    spellCheck?: (boolean | "true" | "false") | undefined;
    style?: React.CSSProperties | undefined;
    title?: string | undefined;
    translate?: "yes" | "no" | undefined;
    radioGroup?: string | undefined;
    about?: string | undefined;
    content?: string | undefined;
    datatype?: string | undefined;
    inlist?: any;
    prefix?: string | undefined;
    property?: string | undefined;
    rel?: string | undefined;
    resource?: string | undefined;
    rev?: string | undefined;
    typeof?: string | undefined;
    vocab?: string | undefined;
    autoCapitalize?: string | undefined;
    autoCorrect?: string | undefined;
    autoSave?: string | undefined;
    color?: string | undefined;
    itemProp?: string | undefined;
    itemScope?: boolean | undefined;
    itemType?: string | undefined;
    itemID?: string | undefined;
    itemRef?: string | undefined;
    results?: number | undefined;
    security?: string | undefined;
    unselectable?: "on" | "off" | undefined;
    inputMode?: "search" | "text" | "none" | "email" | "tel" | "url" | "numeric" | "decimal" | undefined;
    is?: string | undefined;
    'aria-activedescendant'?: string | undefined;
    'aria-atomic'?: (boolean | "true" | "false") | undefined;
    'aria-autocomplete'?: "none" | "both" | "inline" | "list" | undefined;
    'aria-braillelabel'?: string | undefined;
    'aria-brailleroledescription'?: string | undefined;
    'aria-busy'?: (boolean | "true" | "false") | undefined;
    'aria-colcount'?: number | undefined;
    'aria-colindex'?: number | undefined;
    'aria-colindextext'?: string | undefined;
    'aria-colspan'?: number | undefined;
    'aria-controls'?: string | undefined;
    'aria-current'?: boolean | "time" | "true" | "false" | "page" | "location" | "step" | "date" | undefined;
    'aria-describedby'?: string | undefined;
    'aria-description'?: string | undefined;
    'aria-details'?: string | undefined;
    'aria-dropeffect'?: "link" | "none" | "copy" | "move" | "execute" | "popup" | undefined;
    'aria-errormessage'?: string | undefined;
    'aria-expanded'?: (boolean | "true" | "false") | undefined;
    'aria-flowto'?: string | undefined;
    'aria-grabbed'?: (boolean | "true" | "false") | undefined;
    'aria-haspopup'?: boolean | "dialog" | "menu" | "true" | "false" | "grid" | "listbox" | "tree" | undefined;
    'aria-hidden'?: (boolean | "true" | "false") | undefined;
    'aria-invalid'?: boolean | "true" | "false" | "grammar" | "spelling" | undefined;
    'aria-keyshortcuts'?: string | undefined;
    'aria-label'?: string | undefined;
    'aria-labelledby'?: string | undefined;
    'aria-level'?: number | undefined;
    'aria-live'?: "off" | "assertive" | "polite" | undefined;
    'aria-modal'?: (boolean | "true" | "false") | undefined;
    'aria-multiline'?: (boolean | "true" | "false") | undefined;
    'aria-multiselectable'?: (boolean | "true" | "false") | undefined;
    'aria-orientation'?: "horizontal" | "vertical" | undefined;
    'aria-owns'?: string | undefined;
    'aria-placeholder'?: string | undefined;
    'aria-posinset'?: number | undefined;
    'aria-pressed'?: boolean | "true" | "false" | "mixed" | undefined;
    'aria-readonly'?: (boolean | "true" | "false") | undefined;
    'aria-relevant'?: "text" | "all" | "additions" | "additions removals" | "additions text" | "removals" | "removals additions" | "removals text" | "text additions" | "text removals" | undefined;
    'aria-required'?: (boolean | "true" | "false") | undefined;
    'aria-roledescription'?: string | undefined;
    'aria-rowcount'?: number | undefined;
    'aria-rowindex'?: number | undefined;
    'aria-rowindextext'?: string | undefined;
    'aria-rowspan'?: number | undefined;
    'aria-selected'?: (boolean | "true" | "false") | undefined;
    'aria-setsize'?: number | undefined;
    'aria-sort'?: "none" | "ascending" | "descending" | "other" | undefined;
    'aria-valuemax'?: number | undefined;
    'aria-valuemin'?: number | undefined;
    'aria-valuenow'?: number | undefined;
    'aria-valuetext'?: string | undefined;
    children?: React.ReactNode;
    dangerouslySetInnerHTML?: {
        __html: string | TrustedHTML;
    } | undefined;
    onCopy?: React.ClipboardEventHandler<HTMLElement> | undefined;
    onCopyCapture?: React.ClipboardEventHandler<HTMLElement> | undefined;
    onCut?: React.ClipboardEventHandler<HTMLElement> | undefined;
    onCutCapture?: React.ClipboardEventHandler<HTMLElement> | undefined;
    onPaste?: React.ClipboardEventHandler<HTMLElement> | undefined;
    onPasteCapture?: React.ClipboardEventHandler<HTMLElement> | undefined;
    onCompositionEnd?: React.CompositionEventHandler<HTMLElement> | undefined;
    onCompositionEndCapture?: React.CompositionEventHandler<HTMLElement> | undefined;
    onCompositionStart?: React.CompositionEventHandler<HTMLElement> | undefined;
    onCompositionStartCapture?: React.CompositionEventHandler<HTMLElement> | undefined;
    onCompositionUpdate?: React.CompositionEventHandler<HTMLElement> | undefined;
    onCompositionUpdateCapture?: React.CompositionEventHandler<HTMLElement> | undefined;
    onFocus?: React.FocusEventHandler<HTMLElement> | undefined;
    onFocusCapture?: React.FocusEventHandler<HTMLElement> | undefined;
    onBlur?: React.FocusEventHandler<HTMLElement> | undefined;
    onBlurCapture?: React.FocusEventHandler<HTMLElement> | undefined;
    onChange?: React.FormEventHandler<HTMLElement> | undefined;
    onChangeCapture?: React.FormEventHandler<HTMLElement> | undefined;
    onBeforeInput?: React.FormEventHandler<HTMLElement> | undefined;
    onBeforeInputCapture?: React.FormEventHandler<HTMLElement> | undefined;
    onInput?: React.FormEventHandler<HTMLElement> | undefined;
    onInputCapture?: React.FormEventHandler<HTMLElement> | undefined;
    onReset?: React.FormEventHandler<HTMLElement> | undefined;
    onResetCapture?: React.FormEventHandler<HTMLElement> | undefined;
    onSubmit?: React.FormEventHandler<HTMLElement> | undefined;
    onSubmitCapture?: React.FormEventHandler<HTMLElement> | undefined;
    onInvalid?: React.FormEventHandler<HTMLElement> | undefined;
    onInvalidCapture?: React.FormEventHandler<HTMLElement> | undefined;
    onLoad?: React.ReactEventHandler<HTMLElement> | undefined;
    onLoadCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onError?: React.ReactEventHandler<HTMLElement> | undefined;
    onErrorCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onKeyDownCapture?: React.KeyboardEventHandler<Element> | undefined;
    onKeyPress?: React.KeyboardEventHandler<Element> | undefined;
    onKeyPressCapture?: React.KeyboardEventHandler<Element> | undefined;
    onKeyUpCapture?: React.KeyboardEventHandler<Element> | undefined;
    onAbort?: React.ReactEventHandler<HTMLElement> | undefined;
    onAbortCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onCanPlay?: React.ReactEventHandler<HTMLElement> | undefined;
    onCanPlayCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onCanPlayThrough?: React.ReactEventHandler<HTMLElement> | undefined;
    onCanPlayThroughCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onDurationChange?: React.ReactEventHandler<HTMLElement> | undefined;
    onDurationChangeCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onEmptied?: React.ReactEventHandler<HTMLElement> | undefined;
    onEmptiedCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onEncrypted?: React.ReactEventHandler<HTMLElement> | undefined;
    onEncryptedCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onEnded?: React.ReactEventHandler<HTMLElement> | undefined;
    onEndedCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onLoadedData?: React.ReactEventHandler<HTMLElement> | undefined;
    onLoadedDataCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onLoadedMetadata?: React.ReactEventHandler<HTMLElement> | undefined;
    onLoadedMetadataCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onLoadStart?: React.ReactEventHandler<HTMLElement> | undefined;
    onLoadStartCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onPause?: React.ReactEventHandler<HTMLElement> | undefined;
    onPauseCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onPlay?: React.ReactEventHandler<HTMLElement> | undefined;
    onPlayCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onPlaying?: React.ReactEventHandler<HTMLElement> | undefined;
    onPlayingCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onProgress?: React.ReactEventHandler<HTMLElement> | undefined;
    onProgressCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onRateChange?: React.ReactEventHandler<HTMLElement> | undefined;
    onRateChangeCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onResize?: React.ReactEventHandler<HTMLElement> | undefined;
    onResizeCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onSeeked?: React.ReactEventHandler<HTMLElement> | undefined;
    onSeekedCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onSeeking?: React.ReactEventHandler<HTMLElement> | undefined;
    onSeekingCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onStalled?: React.ReactEventHandler<HTMLElement> | undefined;
    onStalledCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onSuspend?: React.ReactEventHandler<HTMLElement> | undefined;
    onSuspendCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onTimeUpdate?: React.ReactEventHandler<HTMLElement> | undefined;
    onTimeUpdateCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onVolumeChange?: React.ReactEventHandler<HTMLElement> | undefined;
    onVolumeChangeCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onWaiting?: React.ReactEventHandler<HTMLElement> | undefined;
    onWaitingCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onAuxClick?: React.MouseEventHandler<HTMLElement> | undefined;
    onAuxClickCapture?: React.MouseEventHandler<HTMLElement> | undefined;
    onClickCapture?: React.MouseEventHandler<HTMLElement> | undefined;
    onContextMenu?: React.MouseEventHandler<HTMLElement> | undefined;
    onContextMenuCapture?: React.MouseEventHandler<HTMLElement> | undefined;
    onDoubleClick?: React.MouseEventHandler<HTMLElement> | undefined;
    onDoubleClickCapture?: React.MouseEventHandler<HTMLElement> | undefined;
    onDrag?: React.DragEventHandler<HTMLElement> | undefined;
    onDragCapture?: React.DragEventHandler<HTMLElement> | undefined;
    onDragEnd?: React.DragEventHandler<HTMLElement> | undefined;
    onDragEndCapture?: React.DragEventHandler<HTMLElement> | undefined;
    onDragEnter?: React.DragEventHandler<HTMLElement> | undefined;
    onDragEnterCapture?: React.DragEventHandler<HTMLElement> | undefined;
    onDragExit?: React.DragEventHandler<HTMLElement> | undefined;
    onDragExitCapture?: React.DragEventHandler<HTMLElement> | undefined;
    onDragLeave?: React.DragEventHandler<HTMLElement> | undefined;
    onDragLeaveCapture?: React.DragEventHandler<HTMLElement> | undefined;
    onDragOver?: React.DragEventHandler<HTMLElement> | undefined;
    onDragOverCapture?: React.DragEventHandler<HTMLElement> | undefined;
    onDragStart?: React.DragEventHandler<HTMLElement> | undefined;
    onDragStartCapture?: React.DragEventHandler<HTMLElement> | undefined;
    onDrop?: React.DragEventHandler<HTMLElement> | undefined;
    onDropCapture?: React.DragEventHandler<HTMLElement> | undefined;
    onMouseDownCapture?: React.MouseEventHandler<HTMLElement> | undefined;
    onMouseEnter?: React.MouseEventHandler<HTMLElement> | undefined;
    onMouseMove?: React.MouseEventHandler<HTMLElement> | undefined;
    onMouseMoveCapture?: React.MouseEventHandler<HTMLElement> | undefined;
    onMouseOut?: React.MouseEventHandler<HTMLElement> | undefined;
    onMouseOutCapture?: React.MouseEventHandler<HTMLElement> | undefined;
    onMouseOverCapture?: React.MouseEventHandler<HTMLElement> | undefined;
    onMouseUpCapture?: React.MouseEventHandler<HTMLElement> | undefined;
    onSelect?: React.ReactEventHandler<HTMLElement> | undefined;
    onSelectCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onTouchCancel?: React.TouchEventHandler<HTMLElement> | undefined;
    onTouchCancelCapture?: React.TouchEventHandler<HTMLElement> | undefined;
    onTouchEnd?: React.TouchEventHandler<HTMLElement> | undefined;
    onTouchEndCapture?: React.TouchEventHandler<HTMLElement> | undefined;
    onTouchMove?: React.TouchEventHandler<HTMLElement> | undefined;
    onTouchMoveCapture?: React.TouchEventHandler<HTMLElement> | undefined;
    onTouchStart?: React.TouchEventHandler<HTMLElement> | undefined;
    onTouchStartCapture?: React.TouchEventHandler<HTMLElement> | undefined;
    onPointerDown?: React.PointerEventHandler<HTMLElement> | undefined;
    onPointerDownCapture?: React.PointerEventHandler<HTMLElement> | undefined;
    onPointerMove?: React.PointerEventHandler<HTMLElement> | undefined;
    onPointerMoveCapture?: React.PointerEventHandler<HTMLElement> | undefined;
    onPointerUp?: React.PointerEventHandler<HTMLElement> | undefined;
    onPointerUpCapture?: React.PointerEventHandler<HTMLElement> | undefined;
    onPointerCancel?: React.PointerEventHandler<HTMLElement> | undefined;
    onPointerCancelCapture?: React.PointerEventHandler<HTMLElement> | undefined;
    onPointerEnter?: React.PointerEventHandler<HTMLElement> | undefined;
    onPointerEnterCapture?: React.PointerEventHandler<HTMLElement> | undefined;
    onPointerLeave?: React.PointerEventHandler<HTMLElement> | undefined;
    onPointerLeaveCapture?: React.PointerEventHandler<HTMLElement> | undefined;
    onPointerOver?: React.PointerEventHandler<HTMLElement> | undefined;
    onPointerOverCapture?: React.PointerEventHandler<HTMLElement> | undefined;
    onPointerOut?: React.PointerEventHandler<HTMLElement> | undefined;
    onPointerOutCapture?: React.PointerEventHandler<HTMLElement> | undefined;
    onGotPointerCapture?: React.PointerEventHandler<HTMLElement> | undefined;
    onGotPointerCaptureCapture?: React.PointerEventHandler<HTMLElement> | undefined;
    onLostPointerCapture?: React.PointerEventHandler<HTMLElement> | undefined;
    onLostPointerCaptureCapture?: React.PointerEventHandler<HTMLElement> | undefined;
    onScroll?: React.UIEventHandler<HTMLElement> | undefined;
    onScrollCapture?: React.UIEventHandler<HTMLElement> | undefined;
    onWheel?: React.WheelEventHandler<HTMLElement> | undefined;
    onWheelCapture?: React.WheelEventHandler<HTMLElement> | undefined;
    onAnimationStart?: React.AnimationEventHandler<HTMLElement> | undefined;
    onAnimationStartCapture?: React.AnimationEventHandler<HTMLElement> | undefined;
    onAnimationEnd?: React.AnimationEventHandler<HTMLElement> | undefined;
    onAnimationEndCapture?: React.AnimationEventHandler<HTMLElement> | undefined;
    onAnimationIteration?: React.AnimationEventHandler<HTMLElement> | undefined;
    onAnimationIterationCapture?: React.AnimationEventHandler<HTMLElement> | undefined;
    onTransitionEnd?: React.TransitionEventHandler<HTMLElement> | undefined;
    onTransitionEndCapture?: React.TransitionEventHandler<HTMLElement> | undefined;
} | {
    role: string;
    "aria-checked": boolean | "true" | "false" | "mixed" | undefined;
    type: any;
    id: string;
    tabIndex: number;
    ref: (node: any) => void;
    "data-active": boolean | "true" | "false";
    "aria-disabled": "true" | undefined;
    onClick: (event: React.MouseEvent<HTMLElement, MouseEvent>) => void;
    onMouseDown: (event: React.MouseEvent<HTMLElement, MouseEvent>) => void;
    onMouseUp: (event: React.MouseEvent<HTMLElement, MouseEvent>) => void;
    onKeyUp: (event: React.KeyboardEvent<HTMLElement>) => void;
    onKeyDown: (event: React.KeyboardEvent<HTMLElement>) => void;
    onMouseOver: (event: React.MouseEvent<HTMLElement, MouseEvent>) => void;
    onMouseLeave: (event: React.MouseEvent<HTMLElement, MouseEvent>) => void;
    defaultChecked?: boolean | undefined;
    defaultValue?: string | number | readonly string[] | undefined;
    suppressContentEditableWarning?: boolean | undefined;
    suppressHydrationWarning?: boolean | undefined;
    accessKey?: string | undefined;
    autoFocus?: boolean | undefined;
    className?: string | undefined;
    contentEditable?: "inherit" | (boolean | "true" | "false") | undefined;
    contextMenu?: string | undefined;
    dir?: string | undefined;
    draggable?: (boolean | "true" | "false") | undefined;
    hidden?: boolean | undefined;
    lang?: string | undefined;
    nonce?: string | undefined;
    placeholder?: string | undefined;
    slot?: string | undefined;
    spellCheck?: (boolean | "true" | "false") | undefined;
    style?: React.CSSProperties | undefined;
    title?: string | undefined;
    translate?: "yes" | "no" | undefined;
    radioGroup?: string | undefined;
    about?: string | undefined;
    content?: string | undefined;
    datatype?: string | undefined;
    inlist?: any;
    prefix?: string | undefined;
    property?: string | undefined;
    rel?: string | undefined;
    resource?: string | undefined;
    rev?: string | undefined;
    typeof?: string | undefined;
    vocab?: string | undefined;
    autoCapitalize?: string | undefined;
    autoCorrect?: string | undefined;
    autoSave?: string | undefined;
    color?: string | undefined;
    itemProp?: string | undefined;
    itemScope?: boolean | undefined;
    itemType?: string | undefined;
    itemID?: string | undefined;
    itemRef?: string | undefined;
    results?: number | undefined;
    security?: string | undefined;
    unselectable?: "on" | "off" | undefined;
    inputMode?: "search" | "text" | "none" | "email" | "tel" | "url" | "numeric" | "decimal" | undefined;
    is?: string | undefined;
    'aria-activedescendant'?: string | undefined;
    'aria-atomic'?: (boolean | "true" | "false") | undefined;
    'aria-autocomplete'?: "none" | "both" | "inline" | "list" | undefined;
    'aria-braillelabel'?: string | undefined;
    'aria-brailleroledescription'?: string | undefined;
    'aria-busy'?: (boolean | "true" | "false") | undefined;
    'aria-colcount'?: number | undefined;
    'aria-colindex'?: number | undefined;
    'aria-colindextext'?: string | undefined;
    'aria-colspan'?: number | undefined;
    'aria-controls'?: string | undefined;
    'aria-current'?: boolean | "time" | "true" | "false" | "page" | "location" | "step" | "date" | undefined;
    'aria-describedby'?: string | undefined;
    'aria-description'?: string | undefined;
    'aria-details'?: string | undefined;
    'aria-dropeffect'?: "link" | "none" | "copy" | "move" | "execute" | "popup" | undefined;
    'aria-errormessage'?: string | undefined;
    'aria-expanded'?: (boolean | "true" | "false") | undefined;
    'aria-flowto'?: string | undefined;
    'aria-grabbed'?: (boolean | "true" | "false") | undefined;
    'aria-haspopup'?: boolean | "dialog" | "menu" | "true" | "false" | "grid" | "listbox" | "tree" | undefined;
    'aria-hidden'?: (boolean | "true" | "false") | undefined;
    'aria-invalid'?: boolean | "true" | "false" | "grammar" | "spelling" | undefined;
    'aria-keyshortcuts'?: string | undefined;
    'aria-label'?: string | undefined;
    'aria-labelledby'?: string | undefined;
    'aria-level'?: number | undefined;
    'aria-live'?: "off" | "assertive" | "polite" | undefined;
    'aria-modal'?: (boolean | "true" | "false") | undefined;
    'aria-multiline'?: (boolean | "true" | "false") | undefined;
    'aria-multiselectable'?: (boolean | "true" | "false") | undefined;
    'aria-orientation'?: "horizontal" | "vertical" | undefined;
    'aria-owns'?: string | undefined;
    'aria-placeholder'?: string | undefined;
    'aria-posinset'?: number | undefined;
    'aria-pressed'?: boolean | "true" | "false" | "mixed" | undefined;
    'aria-readonly'?: (boolean | "true" | "false") | undefined;
    'aria-relevant'?: "text" | "all" | "additions" | "additions removals" | "additions text" | "removals" | "removals additions" | "removals text" | "text additions" | "text removals" | undefined;
    'aria-required'?: (boolean | "true" | "false") | undefined;
    'aria-roledescription'?: string | undefined;
    'aria-rowcount'?: number | undefined;
    'aria-rowindex'?: number | undefined;
    'aria-rowindextext'?: string | undefined;
    'aria-rowspan'?: number | undefined;
    'aria-selected'?: (boolean | "true" | "false") | undefined;
    'aria-setsize'?: number | undefined;
    'aria-sort'?: "none" | "ascending" | "descending" | "other" | undefined;
    'aria-valuemax'?: number | undefined;
    'aria-valuemin'?: number | undefined;
    'aria-valuenow'?: number | undefined;
    'aria-valuetext'?: string | undefined;
    children?: React.ReactNode;
    dangerouslySetInnerHTML?: {
        __html: string | TrustedHTML;
    } | undefined;
    onCopy?: React.ClipboardEventHandler<HTMLElement> | undefined;
    onCopyCapture?: React.ClipboardEventHandler<HTMLElement> | undefined;
    onCut?: React.ClipboardEventHandler<HTMLElement> | undefined;
    onCutCapture?: React.ClipboardEventHandler<HTMLElement> | undefined;
    onPaste?: React.ClipboardEventHandler<HTMLElement> | undefined;
    onPasteCapture?: React.ClipboardEventHandler<HTMLElement> | undefined;
    onCompositionEnd?: React.CompositionEventHandler<HTMLElement> | undefined;
    onCompositionEndCapture?: React.CompositionEventHandler<HTMLElement> | undefined;
    onCompositionStart?: React.CompositionEventHandler<HTMLElement> | undefined;
    onCompositionStartCapture?: React.CompositionEventHandler<HTMLElement> | undefined;
    onCompositionUpdate?: React.CompositionEventHandler<HTMLElement> | undefined;
    onCompositionUpdateCapture?: React.CompositionEventHandler<HTMLElement> | undefined;
    onFocus?: React.FocusEventHandler<HTMLElement> | undefined;
    onFocusCapture?: React.FocusEventHandler<HTMLElement> | undefined;
    onBlur?: React.FocusEventHandler<HTMLElement> | undefined;
    onBlurCapture?: React.FocusEventHandler<HTMLElement> | undefined;
    onChange?: React.FormEventHandler<HTMLElement> | undefined;
    onChangeCapture?: React.FormEventHandler<HTMLElement> | undefined;
    onBeforeInput?: React.FormEventHandler<HTMLElement> | undefined;
    onBeforeInputCapture?: React.FormEventHandler<HTMLElement> | undefined;
    onInput?: React.FormEventHandler<HTMLElement> | undefined;
    onInputCapture?: React.FormEventHandler<HTMLElement> | undefined;
    onReset?: React.FormEventHandler<HTMLElement> | undefined;
    onResetCapture?: React.FormEventHandler<HTMLElement> | undefined;
    onSubmit?: React.FormEventHandler<HTMLElement> | undefined;
    onSubmitCapture?: React.FormEventHandler<HTMLElement> | undefined;
    onInvalid?: React.FormEventHandler<HTMLElement> | undefined;
    onInvalidCapture?: React.FormEventHandler<HTMLElement> | undefined;
    onLoad?: React.ReactEventHandler<HTMLElement> | undefined;
    onLoadCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onError?: React.ReactEventHandler<HTMLElement> | undefined;
    onErrorCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onKeyDownCapture?: React.KeyboardEventHandler<Element> | undefined;
    onKeyPress?: React.KeyboardEventHandler<Element> | undefined;
    onKeyPressCapture?: React.KeyboardEventHandler<Element> | undefined;
    onKeyUpCapture?: React.KeyboardEventHandler<Element> | undefined;
    onAbort?: React.ReactEventHandler<HTMLElement> | undefined;
    onAbortCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onCanPlay?: React.ReactEventHandler<HTMLElement> | undefined;
    onCanPlayCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onCanPlayThrough?: React.ReactEventHandler<HTMLElement> | undefined;
    onCanPlayThroughCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onDurationChange?: React.ReactEventHandler<HTMLElement> | undefined;
    onDurationChangeCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onEmptied?: React.ReactEventHandler<HTMLElement> | undefined;
    onEmptiedCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onEncrypted?: React.ReactEventHandler<HTMLElement> | undefined;
    onEncryptedCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onEnded?: React.ReactEventHandler<HTMLElement> | undefined;
    onEndedCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onLoadedData?: React.ReactEventHandler<HTMLElement> | undefined;
    onLoadedDataCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onLoadedMetadata?: React.ReactEventHandler<HTMLElement> | undefined;
    onLoadedMetadataCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onLoadStart?: React.ReactEventHandler<HTMLElement> | undefined;
    onLoadStartCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onPause?: React.ReactEventHandler<HTMLElement> | undefined;
    onPauseCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onPlay?: React.ReactEventHandler<HTMLElement> | undefined;
    onPlayCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onPlaying?: React.ReactEventHandler<HTMLElement> | undefined;
    onPlayingCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onProgress?: React.ReactEventHandler<HTMLElement> | undefined;
    onProgressCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onRateChange?: React.ReactEventHandler<HTMLElement> | undefined;
    onRateChangeCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onResize?: React.ReactEventHandler<HTMLElement> | undefined;
    onResizeCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onSeeked?: React.ReactEventHandler<HTMLElement> | undefined;
    onSeekedCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onSeeking?: React.ReactEventHandler<HTMLElement> | undefined;
    onSeekingCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onStalled?: React.ReactEventHandler<HTMLElement> | undefined;
    onStalledCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onSuspend?: React.ReactEventHandler<HTMLElement> | undefined;
    onSuspendCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onTimeUpdate?: React.ReactEventHandler<HTMLElement> | undefined;
    onTimeUpdateCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onVolumeChange?: React.ReactEventHandler<HTMLElement> | undefined;
    onVolumeChangeCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onWaiting?: React.ReactEventHandler<HTMLElement> | undefined;
    onWaitingCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onAuxClick?: React.MouseEventHandler<HTMLElement> | undefined;
    onAuxClickCapture?: React.MouseEventHandler<HTMLElement> | undefined;
    onClickCapture?: React.MouseEventHandler<HTMLElement> | undefined;
    onContextMenu?: React.MouseEventHandler<HTMLElement> | undefined;
    onContextMenuCapture?: React.MouseEventHandler<HTMLElement> | undefined;
    onDoubleClick?: React.MouseEventHandler<HTMLElement> | undefined;
    onDoubleClickCapture?: React.MouseEventHandler<HTMLElement> | undefined;
    onDrag?: React.DragEventHandler<HTMLElement> | undefined;
    onDragCapture?: React.DragEventHandler<HTMLElement> | undefined;
    onDragEnd?: React.DragEventHandler<HTMLElement> | undefined;
    onDragEndCapture?: React.DragEventHandler<HTMLElement> | undefined;
    onDragEnter?: React.DragEventHandler<HTMLElement> | undefined;
    onDragEnterCapture?: React.DragEventHandler<HTMLElement> | undefined;
    onDragExit?: React.DragEventHandler<HTMLElement> | undefined;
    onDragExitCapture?: React.DragEventHandler<HTMLElement> | undefined;
    onDragLeave?: React.DragEventHandler<HTMLElement> | undefined;
    onDragLeaveCapture?: React.DragEventHandler<HTMLElement> | undefined;
    onDragOver?: React.DragEventHandler<HTMLElement> | undefined;
    onDragOverCapture?: React.DragEventHandler<HTMLElement> | undefined;
    onDragStart?: React.DragEventHandler<HTMLElement> | undefined;
    onDragStartCapture?: React.DragEventHandler<HTMLElement> | undefined;
    onDrop?: React.DragEventHandler<HTMLElement> | undefined;
    onDropCapture?: React.DragEventHandler<HTMLElement> | undefined;
    onMouseDownCapture?: React.MouseEventHandler<HTMLElement> | undefined;
    onMouseEnter?: React.MouseEventHandler<HTMLElement> | undefined;
    onMouseMove?: React.MouseEventHandler<HTMLElement> | undefined;
    onMouseMoveCapture?: React.MouseEventHandler<HTMLElement> | undefined;
    onMouseOut?: React.MouseEventHandler<HTMLElement> | undefined;
    onMouseOutCapture?: React.MouseEventHandler<HTMLElement> | undefined;
    onMouseOverCapture?: React.MouseEventHandler<HTMLElement> | undefined;
    onMouseUpCapture?: React.MouseEventHandler<HTMLElement> | undefined;
    onSelect?: React.ReactEventHandler<HTMLElement> | undefined;
    onSelectCapture?: React.ReactEventHandler<HTMLElement> | undefined;
    onTouchCancel?: React.TouchEventHandler<HTMLElement> | undefined;
    onTouchCancelCapture?: React.TouchEventHandler<HTMLElement> | undefined;
    onTouchEnd?: React.TouchEventHandler<HTMLElement> | undefined;
    onTouchEndCapture?: React.TouchEventHandler<HTMLElement> | undefined;
    onTouchMove?: React.TouchEventHandler<HTMLElement> | undefined;
    onTouchMoveCapture?: React.TouchEventHandler<HTMLElement> | undefined;
    onTouchStart?: React.TouchEventHandler<HTMLElement> | undefined;
    onTouchStartCapture?: React.TouchEventHandler<HTMLElement> | undefined;
    onPointerDown?: React.PointerEventHandler<HTMLElement> | undefined;
    onPointerDownCapture?: React.PointerEventHandler<HTMLElement> | undefined;
    onPointerMove?: React.PointerEventHandler<HTMLElement> | undefined;
    onPointerMoveCapture?: React.PointerEventHandler<HTMLElement> | undefined;
    onPointerUp?: React.PointerEventHandler<HTMLElement> | undefined;
    onPointerUpCapture?: React.PointerEventHandler<HTMLElement> | undefined;
    onPointerCancel?: React.PointerEventHandler<HTMLElement> | undefined;
    onPointerCancelCapture?: React.PointerEventHandler<HTMLElement> | undefined;
    onPointerEnter?: React.PointerEventHandler<HTMLElement> | undefined;
    onPointerEnterCapture?: React.PointerEventHandler<HTMLElement> | undefined;
    onPointerLeave?: React.PointerEventHandler<HTMLElement> | undefined;
    onPointerLeaveCapture?: React.PointerEventHandler<HTMLElement> | undefined;
    onPointerOver?: React.PointerEventHandler<HTMLElement> | undefined;
    onPointerOverCapture?: React.PointerEventHandler<HTMLElement> | undefined;
    onPointerOut?: React.PointerEventHandler<HTMLElement> | undefined;
    onPointerOutCapture?: React.PointerEventHandler<HTMLElement> | undefined;
    onGotPointerCapture?: React.PointerEventHandler<HTMLElement> | undefined;
    onGotPointerCaptureCapture?: React.PointerEventHandler<HTMLElement> | undefined;
    onLostPointerCapture?: React.PointerEventHandler<HTMLElement> | undefined;
    onLostPointerCaptureCapture?: React.PointerEventHandler<HTMLElement> | undefined;
    onScroll?: React.UIEventHandler<HTMLElement> | undefined;
    onScrollCapture?: React.UIEventHandler<HTMLElement> | undefined;
    onWheel?: React.WheelEventHandler<HTMLElement> | undefined;
    onWheelCapture?: React.WheelEventHandler<HTMLElement> | undefined;
    onAnimationStart?: React.AnimationEventHandler<HTMLElement> | undefined;
    onAnimationStartCapture?: React.AnimationEventHandler<HTMLElement> | undefined;
    onAnimationEnd?: React.AnimationEventHandler<HTMLElement> | undefined;
    onAnimationEndCapture?: React.AnimationEventHandler<HTMLElement> | undefined;
    onAnimationIteration?: React.AnimationEventHandler<HTMLElement> | undefined;
    onAnimationIterationCapture?: React.AnimationEventHandler<HTMLElement> | undefined;
    onTransitionEnd?: React.TransitionEventHandler<HTMLElement> | undefined;
    onTransitionEndCapture?: React.TransitionEventHandler<HTMLElement> | undefined;
};
interface UseMenuOptionGroupProps {
    value?: string | string[];
    defaultValue?: string | string[];
    type?: "radio" | "checkbox";
    onChange?: (value: string | string[]) => void;
    children?: React.ReactNode;
}
declare function useMenuOptionGroup(props?: UseMenuOptionGroupProps): {
    children: React.ReactElement<any, string | React.JSXElementConstructor<any>>[];
};
declare function useMenuState(): {
    isOpen: boolean;
    onClose: () => void;
};

export { MenuDescendantsProvider, MenuProvider, UseMenuButtonProps, UseMenuItemProps, UseMenuListProps, UseMenuOptionGroupProps, UseMenuOptionOptions, UseMenuOptionProps, UseMenuProps, UseMenuReturn, useMenu, useMenuButton, useMenuContext, useMenuDescendant, useMenuDescendants, useMenuDescendantsContext, useMenuItem, useMenuList, useMenuOption, useMenuOptionGroup, useMenuPositioner, useMenuState };
