'use client'
import {
  useModalContext,
  useModalStyles
} from "./chunk-MSA2NPQT.mjs";

// src/modal-close-button.tsx
import { CloseButton } from "@chakra-ui/close-button";
import { cx, callAllHandlers } from "@chakra-ui/shared-utils";
import { forwardRef } from "@chakra-ui/system";
import { jsx } from "react/jsx-runtime";
var ModalCloseButton = forwardRef(
  (props, ref) => {
    const { onClick, className, ...rest } = props;
    const { onClose } = useModalContext();
    const _className = cx("chakra-modal__close-btn", className);
    const styles = useModalStyles();
    return /* @__PURE__ */ jsx(
      CloseButton,
      {
        ref,
        __css: styles.closeButton,
        className: _className,
        onClick: callAllHandlers(onClick, (event) => {
          event.stopPropagation();
          onClose();
        }),
        ...rest
      }
    );
  }
);
ModalCloseButton.displayName = "ModalCloseButton";

export {
  ModalCloseButton
};
//# sourceMappingURL=chunk-4FCEGNGT.mjs.map