'use client'
import {
  useModalContext,
  useModalStyles
} from "./chunk-MSA2NPQT.mjs";

// src/modal-header.tsx
import { cx } from "@chakra-ui/shared-utils";
import {
  chakra,
  forwardRef
} from "@chakra-ui/system";
import { useEffect } from "react";
import { jsx } from "react/jsx-runtime";
var ModalHeader = forwardRef(
  (props, ref) => {
    const { className, ...rest } = props;
    const { headerId, setHeaderMounted } = useModalContext();
    useEffect(() => {
      setHeaderMounted(true);
      return () => setHeaderMounted(false);
    }, [setHeaderMounted]);
    const _className = cx("chakra-modal__header", className);
    const styles = useModalStyles();
    const headerStyles = {
      flex: 0,
      ...styles.header
    };
    return /* @__PURE__ */ jsx(
      chakra.header,
      {
        ref,
        className: _className,
        id: headerId,
        ...rest,
        __css: headerStyles
      }
    );
  }
);
ModalHeader.displayName = "ModalHeader";

export {
  ModalHeader
};
//# sourceMappingURL=chunk-5FG5SY5K.mjs.map