'use client'
import {
  useDrawerContext
} from "./chunk-MCHDHFCQ.mjs";
import {
  ModalFocusScope
} from "./chunk-NABYTFTG.mjs";
import {
  useModalContext,
  useModalStyles
} from "./chunk-MSA2NPQT.mjs";

// src/drawer-content.tsx
import { cx } from "@chakra-ui/shared-utils";
import {
  chakra,
  forwardRef
} from "@chakra-ui/system";
import { Slide } from "@chakra-ui/transition";
import { jsx } from "react/jsx-runtime";
var MotionDiv = chakra(Slide);
var DrawerContent = forwardRef(
  (props, ref) => {
    const {
      className,
      children,
      motionProps,
      containerProps: rootProps,
      ...rest
    } = props;
    const { getDialogProps, getDialogContainerProps, isOpen } = useModalContext();
    const dialogProps = getDialogProps(rest, ref);
    const containerProps = getDialogContainerProps(rootProps);
    const _className = cx("chakra-modal__content", className);
    const styles = useModalStyles();
    const dialogStyles = {
      display: "flex",
      flexDirection: "column",
      position: "relative",
      width: "100%",
      outline: 0,
      ...styles.dialog
    };
    const dialogContainerStyles = {
      display: "flex",
      width: "100vw",
      height: "$100vh",
      position: "fixed",
      left: 0,
      top: 0,
      ...styles.dialogContainer
    };
    const { placement } = useDrawerContext();
    return /* @__PURE__ */ jsx(ModalFocusScope, { children: /* @__PURE__ */ jsx(
      chakra.div,
      {
        ...containerProps,
        className: "chakra-modal__content-container",
        __css: dialogContainerStyles,
        children: /* @__PURE__ */ jsx(
          MotionDiv,
          {
            motionProps,
            direction: placement,
            in: isOpen,
            className: _className,
            ...dialogProps,
            __css: dialogStyles,
            children
          }
        )
      }
    ) });
  }
);
DrawerContent.displayName = "DrawerContent";

export {
  DrawerContent
};
//# sourceMappingURL=chunk-65IR7CTH.mjs.map