'use client'
import {
  useModalContext,
  useModalStyles
} from "./chunk-MSA2NPQT.mjs";

// src/modal-overlay.tsx
import { cx } from "@chakra-ui/shared-utils";
import {
  chakra,
  forwardRef
} from "@chakra-ui/system";
import { fadeConfig } from "@chakra-ui/transition";
import { motion } from "framer-motion";
import { jsx } from "react/jsx-runtime";
var MotionDiv = chakra(motion.div);
var ModalOverlay = forwardRef(
  (props, ref) => {
    const { className, transition, motionProps: _motionProps, ...rest } = props;
    const _className = cx("chakra-modal__overlay", className);
    const styles = useModalStyles();
    const overlayStyle = {
      pos: "fixed",
      left: "0",
      top: "0",
      w: "100vw",
      h: "100vh",
      ...styles.overlay
    };
    const { motionPreset } = useModalContext();
    const defaultMotionProps = motionPreset === "none" ? {} : fadeConfig;
    const motionProps = _motionProps || defaultMotionProps;
    return /* @__PURE__ */ jsx(
      MotionDiv,
      {
        ...motionProps,
        __css: overlayStyle,
        ref,
        className: _className,
        ...rest
      }
    );
  }
);
ModalOverlay.displayName = "ModalOverlay";

export {
  ModalOverlay
};
//# sourceMappingURL=chunk-JQMJHPZH.mjs.map