'use client'
import {
  Modal
} from "./chunk-MSA2NPQT.mjs";

// src/drawer.tsx
import { createContext } from "@chakra-ui/react-context";
import { useTheme } from "@chakra-ui/system";
import { jsx } from "react/jsx-runtime";
var [DrawerContextProvider, useDrawerContext] = createContext();
var placementMap = {
  start: { ltr: "left", rtl: "right" },
  end: { ltr: "right", rtl: "left" }
};
function getDrawerPlacement(placement, dir) {
  var _a, _b;
  if (!placement)
    return;
  return (_b = (_a = placementMap[placement]) == null ? void 0 : _a[dir]) != null ? _b : placement;
}
function Drawer(props) {
  var _a;
  const {
    isOpen,
    onClose,
    placement: placementProp = "right",
    children,
    ...rest
  } = props;
  const theme = useTheme();
  const drawerStyleConfig = (_a = theme.components) == null ? void 0 : _a.Drawer;
  const placement = getDrawerPlacement(placementProp, theme.direction);
  return /* @__PURE__ */ jsx(DrawerContextProvider, { value: { placement }, children: /* @__PURE__ */ jsx(
    Modal,
    {
      isOpen,
      onClose,
      styleConfig: drawerStyleConfig,
      ...rest,
      children
    }
  ) });
}

export {
  useDrawerContext,
  Drawer
};
//# sourceMappingURL=chunk-MCHDHFCQ.mjs.map