'use client'
import {
  useModal
} from "./chunk-TJ2Q5ITW.mjs";

// src/modal.tsx
import { Portal } from "@chakra-ui/portal";
import { createContext } from "@chakra-ui/react-context";
import {
  useMultiStyleConfig
} from "@chakra-ui/system";
import { AnimatePresence } from "framer-motion";
import { jsx } from "react/jsx-runtime";
var [ModalStylesProvider, useModalStyles] = createContext({
  name: `ModalStylesContext`,
  errorMessage: `useModalStyles returned is 'undefined'. Seems you forgot to wrap the components in "<Modal />" `
});
var [ModalContextProvider, useModalContext] = createContext({
  strict: true,
  name: "ModalContext",
  errorMessage: "useModalContext: `context` is undefined. Seems you forgot to wrap modal components in `<Modal />`"
});
var Modal = (props) => {
  const modalProps = {
    scrollBehavior: "outside",
    autoFocus: true,
    trapFocus: true,
    returnFocusOnClose: true,
    blockScrollOnMount: true,
    allowPinchZoom: false,
    motionPreset: "scale",
    lockFocusAcrossFrames: true,
    ...props
  };
  const {
    portalProps,
    children,
    autoFocus,
    trapFocus,
    initialFocusRef,
    finalFocusRef,
    returnFocusOnClose,
    blockScrollOnMount,
    allowPinchZoom,
    preserveScrollBarGap,
    motionPreset,
    lockFocusAcrossFrames,
    onCloseComplete
  } = modalProps;
  const styles = useMultiStyleConfig("Modal", modalProps);
  const modal = useModal(modalProps);
  const context = {
    ...modal,
    autoFocus,
    trapFocus,
    initialFocusRef,
    finalFocusRef,
    returnFocusOnClose,
    blockScrollOnMount,
    allowPinchZoom,
    preserveScrollBarGap,
    motionPreset,
    lockFocusAcrossFrames
  };
  return /* @__PURE__ */ jsx(ModalContextProvider, { value: context, children: /* @__PURE__ */ jsx(ModalStylesProvider, { value: styles, children: /* @__PURE__ */ jsx(AnimatePresence, { onExitComplete: onCloseComplete, children: context.isOpen && /* @__PURE__ */ jsx(Portal, { ...portalProps, children }) }) }) });
};
Modal.displayName = "Modal";

export {
  useModalStyles,
  ModalContextProvider,
  useModalContext,
  Modal
};
//# sourceMappingURL=chunk-MSA2NPQT.mjs.map