'use client'
import {
  useModalContext,
  useModalStyles
} from "./chunk-MSA2NPQT.mjs";

// src/modal-body.tsx
import { cx } from "@chakra-ui/shared-utils";
import { chakra, forwardRef } from "@chakra-ui/system";
import { useEffect } from "react";
import { jsx } from "react/jsx-runtime";
var ModalBody = forwardRef((props, ref) => {
  const { className, ...rest } = props;
  const { bodyId, setBodyMounted } = useModalContext();
  useEffect(() => {
    setBodyMounted(true);
    return () => setBodyMounted(false);
  }, [setBodyMounted]);
  const _className = cx("chakra-modal__body", className);
  const styles = useModalStyles();
  return /* @__PURE__ */ jsx(
    chakra.div,
    {
      ref,
      className: _className,
      id: bodyId,
      ...rest,
      __css: styles.body
    }
  );
});
ModalBody.displayName = "ModalBody";

export {
  ModalBody
};
//# sourceMappingURL=chunk-OFOVX77R.mjs.map