import * as react_jsx_runtime from 'react/jsx-runtime';
import { ThemingProps } from '@chakra-ui/system';
import { SlideOptions } from '@chakra-ui/transition';
import { ModalProps } from './modal.mjs';
export { ModalBody as DrawerBody } from './modal-body.mjs';
export { ModalCloseButton as DrawerCloseButton } from './modal-close-button.mjs';
export { ModalFooter as DrawerFooter } from './modal-footer.mjs';
export { ModalHeader as DrawerHeader } from './modal-header.mjs';
export { ModalOverlay as DrawerOverlay } from './modal-overlay.mjs';
import 'react';
import '@chakra-ui/focus-lock';
import '@chakra-ui/portal';
import './use-modal.mjs';
import '@chakra-ui/react-types';
import '@chakra-ui/close-button';
import 'framer-motion';

declare const useDrawerContext: () => DrawerOptions;
type LogicalPlacement = "start" | "end";
type DrawerPlacement = SlideOptions["direction"] | LogicalPlacement;
interface DrawerOptions {
    /**
     * The placement of the drawer
     * @default "right"
     */
    placement?: DrawerPlacement;
    /**
     * If `true` and drawer's placement is `top` or `bottom`,
     * the drawer will occupy the viewport height (100vh)
     */
    isFullHeight?: boolean;
}
interface DrawerProps extends DrawerOptions, ThemingProps<"Drawer">, Omit<ModalProps, "scrollBehavior" | "motionPreset" | "isCentered" | keyof ThemingProps> {
}
/**
 * The Drawer component is a panel that slides out from the edge of the screen.
 * It can be useful when you need users to complete a task or view some details without leaving the current page.
 *
 * @see Docs https://chakra-ui.com/docs/components/drawer
 */
declare function Drawer(props: DrawerProps): react_jsx_runtime.JSX.Element;

export { Drawer, DrawerProps, useDrawerContext };
