'use client'
"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/modal-transition.tsx
var modal_transition_exports = {};
__export(modal_transition_exports, {
  ModalTransition: () => ModalTransition
});
module.exports = __toCommonJS(modal_transition_exports);
var import_system = require("@chakra-ui/system");
var import_transition = require("@chakra-ui/transition");
var import_framer_motion = require("framer-motion");
var import_react = require("react");
var import_jsx_runtime = require("react/jsx-runtime");
var transitions = {
  slideInBottom: {
    ...import_transition.slideFadeConfig,
    custom: { offsetY: 16, reverse: true }
  },
  slideInRight: {
    ...import_transition.slideFadeConfig,
    custom: { offsetX: 16, reverse: true }
  },
  slideInTop: {
    ...import_transition.slideFadeConfig,
    custom: { offsetY: -16, reverse: true }
  },
  slideInLeft: {
    ...import_transition.slideFadeConfig,
    custom: { offsetX: -16, reverse: true }
  },
  scale: {
    ...import_transition.scaleFadeConfig,
    custom: { initialScale: 0.95, reverse: true }
  },
  none: {}
};
var MotionSection = (0, import_system.chakra)(import_framer_motion.motion.section);
var getMotionProps = (preset) => {
  return transitions[preset || "none"];
};
var ModalTransition = (0, import_react.forwardRef)(
  (props, ref) => {
    const { preset, motionProps = getMotionProps(preset), ...rest } = props;
    return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(MotionSection, { ref, ...motionProps, ...rest });
  }
);
ModalTransition.displayName = "ModalTransition";
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  ModalTransition
});
//# sourceMappingURL=modal-transition.js.map