'use client'
import {
  useRadio
} from "./chunk-2WQJ2JCV.mjs";
import {
  useRadioGroupContext
} from "./chunk-FESYGSQT.mjs";

// src/radio.tsx
import {
  chakra,
  forwardRef,
  layoutPropNames,
  omitThemingProps,
  useMultiStyleConfig
} from "@chakra-ui/system";
import { callAll } from "@chakra-ui/shared-utils";

// ../../utilities/object-utils/src/split.ts
function split(object, keys) {
  const picked = {};
  const omitted = {};
  for (const [key, value] of Object.entries(object)) {
    if (keys.includes(key))
      picked[key] = value;
    else
      omitted[key] = value;
  }
  return [picked, omitted];
}

// src/radio.tsx
import { jsx, jsxs } from "react/jsx-runtime";
var Radio = forwardRef((props, ref) => {
  var _a;
  const group = useRadioGroupContext();
  const { onChange: onChangeProp, value: valueProp } = props;
  const styles = useMultiStyleConfig("Radio", { ...group, ...props });
  const ownProps = omitThemingProps(props);
  const {
    spacing = "0.5rem",
    children,
    isDisabled = group == null ? void 0 : group.isDisabled,
    isFocusable = group == null ? void 0 : group.isFocusable,
    inputProps: htmlInputProps,
    ...rest
  } = ownProps;
  let isChecked = props.isChecked;
  if ((group == null ? void 0 : group.value) != null && valueProp != null) {
    isChecked = group.value === valueProp;
  }
  let onChange = onChangeProp;
  if ((group == null ? void 0 : group.onChange) && valueProp != null) {
    onChange = callAll(group.onChange, onChangeProp);
  }
  const name = (_a = props == null ? void 0 : props.name) != null ? _a : group == null ? void 0 : group.name;
  const {
    getInputProps,
    getCheckboxProps,
    getLabelProps,
    getRootProps,
    htmlProps
  } = useRadio({
    ...rest,
    isChecked,
    isFocusable,
    isDisabled,
    onChange,
    name
  });
  const [layoutProps, otherProps] = split(htmlProps, layoutPropNames);
  const checkboxProps = getCheckboxProps(otherProps);
  const inputProps = getInputProps(htmlInputProps, ref);
  const labelProps = getLabelProps();
  const rootProps = Object.assign({}, layoutProps, getRootProps());
  const rootStyles = {
    display: "inline-flex",
    alignItems: "center",
    verticalAlign: "top",
    cursor: "pointer",
    position: "relative",
    ...styles.container
  };
  const checkboxStyles = {
    display: "inline-flex",
    alignItems: "center",
    justifyContent: "center",
    flexShrink: 0,
    ...styles.control
  };
  const labelStyles = {
    userSelect: "none",
    marginStart: spacing,
    ...styles.label
  };
  return /* @__PURE__ */ jsxs(chakra.label, { className: "chakra-radio", ...rootProps, __css: rootStyles, children: [
    /* @__PURE__ */ jsx("input", { className: "chakra-radio__input", ...inputProps }),
    /* @__PURE__ */ jsx(
      chakra.span,
      {
        className: "chakra-radio__control",
        ...checkboxProps,
        __css: checkboxStyles
      }
    ),
    children && /* @__PURE__ */ jsx(
      chakra.span,
      {
        className: "chakra-radio__label",
        ...labelProps,
        __css: labelStyles,
        children
      }
    )
  ] });
});
Radio.displayName = "Radio";

export {
  Radio
};
//# sourceMappingURL=chunk-RDF2AYID.mjs.map