'use client'
import {
  useChakra
} from "./chunk-7FWEOSAE.mjs";

// src/use-style-config.ts
import {
  resolveStyleConfig
} from "@chakra-ui/styled-system";
import { mergeThemeOverride } from "@chakra-ui/theme-utils";
import {
  filterUndefined,
  memoizedGet as get,
  mergeWith,
  omit
} from "@chakra-ui/utils";
import { useRef } from "react";
import isEqual from "react-fast-compare";
function useStyleConfigImpl(themeKey, props = {}) {
  var _a;
  const { styleConfig: styleConfigProp, ...rest } = props;
  const { theme, colorMode } = useChakra();
  const themeStyleConfig = themeKey ? get(theme, `components.${themeKey}`) : void 0;
  const styleConfig = styleConfigProp || themeStyleConfig;
  const mergedProps = mergeWith(
    { theme, colorMode },
    (_a = styleConfig == null ? void 0 : styleConfig.defaultProps) != null ? _a : {},
    filterUndefined(omit(rest, ["children"]))
  );
  const stylesRef = useRef({});
  if (styleConfig) {
    const getStyles = resolveStyleConfig(styleConfig);
    const styles = getStyles(mergedProps);
    const isStyleEqual = isEqual(stylesRef.current, styles);
    if (!isStyleEqual) {
      stylesRef.current = styles;
    }
  }
  return stylesRef.current;
}
function useStyleConfig(themeKey, props = {}) {
  return useStyleConfigImpl(themeKey, props);
}
function useMultiStyleConfig(themeKey, props = {}) {
  return useStyleConfigImpl(themeKey, props);
}
function useComponentStyles__unstable(themeKey, props) {
  var _a;
  const { baseConfig, ...restProps } = props;
  const { theme } = useChakra();
  const overrides = (_a = theme.components) == null ? void 0 : _a[themeKey];
  const styleConfig = overrides ? mergeThemeOverride(overrides, baseConfig) : baseConfig;
  return useStyleConfigImpl(null, {
    ...restProps,
    styleConfig
  });
}

export {
  useStyleConfig,
  useMultiStyleConfig,
  useComponentStyles__unstable
};
//# sourceMappingURL=chunk-DMO4EI7P.mjs.map