'use client'

// src/providers.tsx
import { useColorMode } from "@chakra-ui/color-mode";
import { createContext } from "@chakra-ui/react-utils";
import { css, toCSSVar } from "@chakra-ui/styled-system";
import { memoizedGet as get, runIfFn } from "@chakra-ui/utils";
import {
  Global,
  ThemeProvider as EmotionThemeProvider
} from "@emotion/react";
import { useMemo } from "react";
import { jsx, jsxs } from "react/jsx-runtime";
function ThemeProvider(props) {
  const { cssVarsRoot, theme, children } = props;
  const computedTheme = useMemo(() => toCSSVar(theme), [theme]);
  return /* @__PURE__ */ jsxs(EmotionThemeProvider, { theme: computedTheme, children: [
    /* @__PURE__ */ jsx(CSSVars, { root: cssVarsRoot }),
    children
  ] });
}
function CSSVars({ root = ":host, :root" }) {
  const selector = [root, `[data-theme]`].join(",");
  return /* @__PURE__ */ jsx(Global, { styles: (theme) => ({ [selector]: theme.__cssVars }) });
}
var [StylesProvider, useStyles] = createContext({
  name: "StylesContext",
  errorMessage: "useStyles: `styles` is undefined. Seems you forgot to wrap the components in `<StylesProvider />` "
});
function createStylesContext(componentName) {
  return createContext({
    name: `${componentName}StylesContext`,
    errorMessage: `useStyles: "styles" is undefined. Seems you forgot to wrap the components in "<${componentName} />" `
  });
}
function GlobalStyle() {
  const { colorMode } = useColorMode();
  return /* @__PURE__ */ jsx(
    Global,
    {
      styles: (theme) => {
        const styleObjectOrFn = get(theme, "styles.global");
        const globalStyles = runIfFn(styleObjectOrFn, { theme, colorMode });
        if (!globalStyles)
          return void 0;
        const styles = css(globalStyles)(theme);
        return styles;
      }
    }
  );
}

export {
  ThemeProvider,
  CSSVars,
  StylesProvider,
  useStyles,
  createStylesContext,
  GlobalStyle
};
//# sourceMappingURL=chunk-MFVQSVQB.mjs.map