"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __reExport = (target, mod, secondTarget) => (__copyProps(target, mod, "default"), secondTarget && __copyProps(secondTarget, mod, "default"));
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/index.ts
var src_exports = {};
__export(src_exports, {
  CSSVars: () => CSSVars,
  GlobalStyle: () => GlobalStyle,
  StylesProvider: () => StylesProvider,
  ThemeProvider: () => ThemeProvider,
  chakra: () => chakra,
  createStylesContext: () => createStylesContext,
  forwardRef: () => forwardRef,
  getToken: () => getToken,
  keyframes: () => import_react8.keyframes,
  shouldForwardProp: () => shouldForwardProp,
  styled: () => styled,
  toCSSObject: () => toCSSObject,
  useChakra: () => useChakra,
  useComponentStyles__unstable: () => useComponentStyles__unstable,
  useMultiStyleConfig: () => useMultiStyleConfig,
  useStyleConfig: () => useStyleConfig,
  useStyles: () => useStyles,
  useTheme: () => useTheme,
  useToken: () => useToken
});
module.exports = __toCommonJS(src_exports);
__reExport(src_exports, require("@chakra-ui/color-mode"), module.exports);
__reExport(src_exports, require("@chakra-ui/styled-system"), module.exports);
var import_react8 = require("@emotion/react");

// src/hooks.ts
var import_color_mode = require("@chakra-ui/color-mode");

// src/use-theme.ts
var import_react = require("@emotion/react");
var import_react2 = require("react");
function useTheme() {
  const theme = (0, import_react2.useContext)(
    import_react.ThemeContext
  );
  if (!theme) {
    throw Error(
      "useTheme: `theme` is undefined. Seems you forgot to wrap your app in `<ChakraProvider />` or `<ThemeProvider />`"
    );
  }
  return theme;
}

// src/hooks.ts
function useChakra() {
  const colorModeResult = (0, import_color_mode.useColorMode)();
  const theme = useTheme();
  return { ...colorModeResult, theme };
}
function getBreakpointValue(theme, value, fallback) {
  var _a2, _b;
  if (value == null)
    return value;
  const getValue = (val) => {
    var _a3, _b2;
    return (_b2 = (_a3 = theme.__breakpoints) == null ? void 0 : _a3.asArray) == null ? void 0 : _b2[val];
  };
  return (_b = (_a2 = getValue(value)) != null ? _a2 : getValue(fallback)) != null ? _b : fallback;
}
function getTokenValue(theme, value, fallback) {
  var _a2, _b;
  if (value == null)
    return value;
  const getValue = (val) => {
    var _a3, _b2;
    return (_b2 = (_a3 = theme.__cssMap) == null ? void 0 : _a3[val]) == null ? void 0 : _b2.value;
  };
  return (_b = (_a2 = getValue(value)) != null ? _a2 : getValue(fallback)) != null ? _b : fallback;
}
function useToken(scale, token, fallback) {
  const theme = useTheme();
  return getToken(scale, token, fallback)(theme);
}
function getToken(scale, token, fallback) {
  const _token = Array.isArray(token) ? token : [token];
  const _fallback = Array.isArray(fallback) ? fallback : [fallback];
  return (theme) => {
    const fallbackArr = _fallback.filter(Boolean);
    const result = _token.map((token2, index) => {
      var _a2, _b;
      if (scale === "breakpoints") {
        return getBreakpointValue(theme, token2, (_a2 = fallbackArr[index]) != null ? _a2 : token2);
      }
      const path = `${scale}.${token2}`;
      return getTokenValue(theme, path, (_b = fallbackArr[index]) != null ? _b : token2);
    });
    return Array.isArray(token) ? result : result[0];
  };
}

// src/providers.tsx
var import_color_mode2 = require("@chakra-ui/color-mode");
var import_react_utils = require("@chakra-ui/react-utils");
var import_styled_system = require("@chakra-ui/styled-system");
var import_utils = require("@chakra-ui/utils");
var import_react3 = require("@emotion/react");
var import_react4 = require("react");
var import_jsx_runtime = require("react/jsx-runtime");
function ThemeProvider(props) {
  const { cssVarsRoot, theme, children } = props;
  const computedTheme = (0, import_react4.useMemo)(() => (0, import_styled_system.toCSSVar)(theme), [theme]);
  return /* @__PURE__ */ (0, import_jsx_runtime.jsxs)(import_react3.ThemeProvider, { theme: computedTheme, children: [
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)(CSSVars, { root: cssVarsRoot }),
    children
  ] });
}
function CSSVars({ root = ":host, :root" }) {
  const selector = [root, `[data-theme]`].join(",");
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_react3.Global, { styles: (theme) => ({ [selector]: theme.__cssVars }) });
}
var [StylesProvider, useStyles] = (0, import_react_utils.createContext)({
  name: "StylesContext",
  errorMessage: "useStyles: `styles` is undefined. Seems you forgot to wrap the components in `<StylesProvider />` "
});
function createStylesContext(componentName) {
  return (0, import_react_utils.createContext)({
    name: `${componentName}StylesContext`,
    errorMessage: `useStyles: "styles" is undefined. Seems you forgot to wrap the components in "<${componentName} />" `
  });
}
function GlobalStyle() {
  const { colorMode } = (0, import_color_mode2.useColorMode)();
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
    import_react3.Global,
    {
      styles: (theme) => {
        const styleObjectOrFn = (0, import_utils.memoizedGet)(theme, "styles.global");
        const globalStyles = (0, import_utils.runIfFn)(styleObjectOrFn, { theme, colorMode });
        if (!globalStyles)
          return void 0;
        const styles = (0, import_styled_system.css)(globalStyles)(theme);
        return styles;
      }
    }
  );
}

// src/system.ts
var import_color_mode3 = require("@chakra-ui/color-mode");
var import_styled_system3 = require("@chakra-ui/styled-system");
var import_utils2 = require("@chakra-ui/utils");
var import_object_utils = require("@chakra-ui/object-utils");
var import_styled = __toESM(require("@emotion/styled"));
var import_react5 = __toESM(require("react"));

// src/should-forward-prop.ts
var import_styled_system2 = require("@chakra-ui/styled-system");
var allPropNames = /* @__PURE__ */ new Set([
  ...import_styled_system2.propNames,
  "textStyle",
  "layerStyle",
  "apply",
  "noOfLines",
  "focusBorderColor",
  "errorBorderColor",
  "as",
  "__css",
  "css",
  "sx"
]);
var validHTMLProps = /* @__PURE__ */ new Set([
  "htmlWidth",
  "htmlHeight",
  "htmlSize",
  "htmlTranslate"
]);
function shouldForwardProp(prop) {
  return validHTMLProps.has(prop) || !allPropNames.has(prop);
}

// src/system.ts
var _a;
var emotion_styled = (_a = import_styled.default.default) != null ? _a : import_styled.default;
var toCSSObject = ({ baseStyle }) => (props) => {
  const { theme, css: cssProp, __css, sx, ...rest } = props;
  const styleProps = (0, import_utils2.objectFilter)(rest, (_, prop) => (0, import_styled_system3.isStyleProp)(prop));
  const finalBaseStyle = (0, import_utils2.runIfFn)(baseStyle, props);
  const finalStyles = (0, import_object_utils.assignAfter)(
    {},
    __css,
    finalBaseStyle,
    (0, import_utils2.filterUndefined)(styleProps),
    sx
  );
  const computedCSS = (0, import_styled_system3.css)(finalStyles)(props.theme);
  return cssProp ? [computedCSS, cssProp] : computedCSS;
};
function styled(component, options) {
  const { baseStyle, ...styledOptions } = options != null ? options : {};
  if (!styledOptions.shouldForwardProp) {
    styledOptions.shouldForwardProp = shouldForwardProp;
  }
  const styleObject = toCSSObject({ baseStyle });
  const Component = emotion_styled(
    component,
    styledOptions
  )(styleObject);
  const chakraComponent = import_react5.default.forwardRef(function ChakraComponent(props, ref) {
    const { colorMode, forced } = (0, import_color_mode3.useColorMode)();
    return import_react5.default.createElement(Component, {
      ref,
      "data-theme": forced ? colorMode : void 0,
      ...props
    });
  });
  return chakraComponent;
}

// src/forward-ref.tsx
var import_react6 = require("react");
function forwardRef(component) {
  return (0, import_react6.forwardRef)(component);
}

// src/use-style-config.ts
var import_styled_system4 = require("@chakra-ui/styled-system");
var import_theme_utils = require("@chakra-ui/theme-utils");
var import_utils3 = require("@chakra-ui/utils");
var import_react7 = require("react");
var import_react_fast_compare = __toESM(require("react-fast-compare"));
function useStyleConfigImpl(themeKey, props = {}) {
  var _a2;
  const { styleConfig: styleConfigProp, ...rest } = props;
  const { theme, colorMode } = useChakra();
  const themeStyleConfig = themeKey ? (0, import_utils3.memoizedGet)(theme, `components.${themeKey}`) : void 0;
  const styleConfig = styleConfigProp || themeStyleConfig;
  const mergedProps = (0, import_utils3.mergeWith)(
    { theme, colorMode },
    (_a2 = styleConfig == null ? void 0 : styleConfig.defaultProps) != null ? _a2 : {},
    (0, import_utils3.filterUndefined)((0, import_utils3.omit)(rest, ["children"]))
  );
  const stylesRef = (0, import_react7.useRef)({});
  if (styleConfig) {
    const getStyles = (0, import_styled_system4.resolveStyleConfig)(styleConfig);
    const styles = getStyles(mergedProps);
    const isStyleEqual = (0, import_react_fast_compare.default)(stylesRef.current, styles);
    if (!isStyleEqual) {
      stylesRef.current = styles;
    }
  }
  return stylesRef.current;
}
function useStyleConfig(themeKey, props = {}) {
  return useStyleConfigImpl(themeKey, props);
}
function useMultiStyleConfig(themeKey, props = {}) {
  return useStyleConfigImpl(themeKey, props);
}
function useComponentStyles__unstable(themeKey, props) {
  var _a2;
  const { baseConfig, ...restProps } = props;
  const { theme } = useChakra();
  const overrides = (_a2 = theme.components) == null ? void 0 : _a2[themeKey];
  const styleConfig = overrides ? (0, import_theme_utils.mergeThemeOverride)(overrides, baseConfig) : baseConfig;
  return useStyleConfigImpl(null, {
    ...restProps,
    styleConfig
  });
}

// src/factory.ts
function factory() {
  const cache = /* @__PURE__ */ new Map();
  return new Proxy(styled, {
    /**
     * @example
     * const Div = chakra("div")
     * const WithChakra = chakra(AnotherComponent)
     */
    apply(target, thisArg, argArray) {
      return styled(...argArray);
    },
    /**
     * @example
     * <chakra.div />
     */
    get(_, element) {
      if (!cache.has(element)) {
        cache.set(element, styled(element));
      }
      return cache.get(element);
    }
  });
}
var chakra = factory();
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  CSSVars,
  GlobalStyle,
  StylesProvider,
  ThemeProvider,
  chakra,
  createStylesContext,
  forwardRef,
  getToken,
  keyframes,
  shouldForwardProp,
  styled,
  toCSSObject,
  useChakra,
  useComponentStyles__unstable,
  useMultiStyleConfig,
  useStyleConfig,
  useStyles,
  useTheme,
  useToken,
  ...require("@chakra-ui/color-mode"),
  ...require("@chakra-ui/styled-system")
});
//# sourceMappingURL=index.js.map