import * as react from 'react';
import * as _chakra_ui_descendant from '@chakra-ui/descendant';
import { UseClickableProps } from '@chakra-ui/clickable';
import { LazyMode } from '@chakra-ui/lazy-utils';

declare const TabsDescendantsProvider: react.Provider<_chakra_ui_descendant.DescendantsManager<HTMLButtonElement, {}>>;
declare const useTabsDescendantsContext: () => _chakra_ui_descendant.DescendantsManager<HTMLButtonElement, {}>;
declare const useTabsDescendants: () => _chakra_ui_descendant.DescendantsManager<HTMLButtonElement, {}>;
declare const useTabsDescendant: (options?: {
    disabled?: boolean | undefined;
    id?: string | undefined;
} | undefined) => {
    descendants: _chakra_ui_descendant.UseDescendantsReturn;
    index: number;
    enabledIndex: number;
    register: (node: HTMLButtonElement | null) => void;
};
interface UseTabsProps {
    /**
     * The orientation of the tab list.
     * @default "horizontal"
     */
    orientation?: "vertical" | "horizontal";
    /**
     * If `true`, the tabs will be manually activated and
     * display its panel by pressing Space or Enter.
     *
     * If `false`, the tabs will be automatically activated
     * and their panel is displayed when they receive focus.
     *
     * @default false
     */
    isManual?: boolean;
    /**
     * Callback when the index (controlled or un-controlled) changes.
     */
    onChange?: (index: number) => void;
    /**
     * The index of the selected tab (in controlled mode)
     */
    index?: number;
    /**
     * The initial index of the selected tab (in uncontrolled mode)
     */
    defaultIndex?: number;
    /**
     * The id of the tab
     */
    id?: string;
    /**
     * Performance 🚀:
     * If `true`, rendering of the tab panel's will be deferred until it is selected.
     * @default false
     */
    isLazy?: boolean;
    /**
     * Performance 🚀:
     * The lazy behavior of tab panels' content when not active.
     * Only works when `isLazy={true}`
     *
     * - "unmount": The content of inactive tab panels are always unmounted.
     * - "keepMounted": The content of inactive tab panels is initially unmounted,
     * but stays mounted when selected.
     *
     * @default "unmount"
     */
    lazyBehavior?: LazyMode;
    /**
     * The writing mode direction.
     *
     * - When in RTL, the left and right navigation is flipped
     * @default "ltr"
     */
    direction?: "rtl" | "ltr";
}
/**
 * Tabs hook that provides all the states, and accessibility
 * helpers to keep all things working properly.
 *
 * Its returned object will be passed unto a Context Provider
 * so all child components can read from it.
 * There is no document link yet
 * @see Docs https://chakra-ui.com/docs/components/useTabs
 * @see WAI-ARIA https://www.w3.org/WAI/ARIA/apg/patterns/tabpanel/
 */
declare function useTabs(props: UseTabsProps): {
    id: string;
    selectedIndex: number;
    focusedIndex: number;
    setSelectedIndex: react.Dispatch<react.SetStateAction<number>>;
    setFocusedIndex: react.Dispatch<react.SetStateAction<number>>;
    isManual: boolean | undefined;
    isLazy: boolean | undefined;
    lazyBehavior: LazyMode;
    orientation: "horizontal" | "vertical";
    descendants: _chakra_ui_descendant.DescendantsManager<HTMLButtonElement, {}>;
    direction: "ltr" | "rtl";
    htmlProps: {
        /**
         * The id of the tab
         */
        id?: string | undefined;
    };
};
type UseTabsReturn = Omit<ReturnType<typeof useTabs>, "htmlProps" | "descendants">;
declare const TabsProvider: react.Provider<UseTabsReturn>;
declare const useTabsContext: () => UseTabsReturn;
interface UseTabListProps {
    children?: React.ReactNode;
    onKeyDown?: React.KeyboardEventHandler;
    ref?: React.Ref<any>;
}
/**
 * Tabs hook to manage multiple tab buttons,
 * and ensures only one tab is selected per time.
 *
 * @param props props object for the tablist
 */
declare function useTabList<P extends UseTabListProps>(props: P): P & {
    role: string;
    "aria-orientation": "horizontal" | "vertical";
    onKeyDown: (event: react.KeyboardEvent<Element>) => void;
};
type UseTabListReturn = ReturnType<typeof useTabList>;
interface UseTabOptions {
    /**
     * If `true`, the `Tab` won't be toggleable
     * @default false
     */
    isDisabled?: boolean;
    /**
     * If `true` and `isDisabled`, the `Tab` will be focusable but not interactive.
     * @default false
     */
    isFocusable?: boolean;
}
interface UseTabProps extends Omit<UseClickableProps, "color">, UseTabOptions {
}
/**
 * Tabs hook to manage each tab button.
 *
 * A tab can be disabled and focusable, or both,
 * hence the use of `useClickable` to handle this scenario
 */
declare function useTab<P extends UseTabProps>(props: P): {
    id: string;
    role: string;
    tabIndex: number;
    type: "button";
    "aria-selected": boolean;
    "aria-controls": string;
    onFocus: ((event: react.FocusEvent<HTMLElement, Element>) => void) | undefined;
    ref: (node: any) => void;
    "aria-disabled": boolean | undefined;
    disabled: boolean | undefined;
    onClick: (event: react.MouseEvent<HTMLElement, MouseEvent>) => void;
    onMouseDown: react.MouseEventHandler<HTMLElement> | undefined;
    onMouseUp: react.MouseEventHandler<HTMLElement> | undefined;
    onKeyUp: react.KeyboardEventHandler<HTMLElement> | undefined;
    onKeyDown: react.KeyboardEventHandler<HTMLElement> | undefined;
    onMouseOver: react.MouseEventHandler<HTMLElement> | undefined;
    onMouseLeave: react.MouseEventHandler<HTMLElement> | undefined;
    defaultChecked?: boolean | undefined;
    defaultValue?: string | number | readonly string[] | undefined;
    suppressContentEditableWarning?: boolean | undefined;
    suppressHydrationWarning?: boolean | undefined;
    accessKey?: string | undefined;
    autoFocus?: boolean | undefined;
    className?: string | undefined;
    contentEditable?: "inherit" | (boolean | "true" | "false") | undefined;
    contextMenu?: string | undefined;
    dir?: string | undefined;
    draggable?: (boolean | "true" | "false") | undefined;
    hidden?: boolean | undefined;
    lang?: string | undefined;
    nonce?: string | undefined;
    placeholder?: string | undefined;
    slot?: string | undefined;
    spellCheck?: (boolean | "true" | "false") | undefined;
    style?: react.CSSProperties | undefined;
    title?: string | undefined;
    translate?: "yes" | "no" | undefined;
    radioGroup?: string | undefined;
    about?: string | undefined;
    content?: string | undefined;
    datatype?: string | undefined;
    inlist?: any;
    prefix?: string | undefined;
    property?: string | undefined;
    rel?: string | undefined;
    resource?: string | undefined;
    rev?: string | undefined;
    typeof?: string | undefined;
    vocab?: string | undefined;
    autoCapitalize?: string | undefined;
    autoCorrect?: string | undefined;
    autoSave?: string | undefined;
    color?: string | undefined;
    itemProp?: string | undefined;
    itemScope?: boolean | undefined;
    itemType?: string | undefined;
    itemID?: string | undefined;
    itemRef?: string | undefined;
    results?: number | undefined;
    security?: string | undefined;
    unselectable?: "on" | "off" | undefined;
    inputMode?: "search" | "text" | "none" | "email" | "tel" | "url" | "numeric" | "decimal" | undefined;
    is?: string | undefined;
    'aria-activedescendant'?: string | undefined;
    'aria-atomic'?: (boolean | "true" | "false") | undefined;
    'aria-autocomplete'?: "none" | "both" | "inline" | "list" | undefined;
    'aria-braillelabel'?: string | undefined;
    'aria-brailleroledescription'?: string | undefined;
    'aria-busy'?: (boolean | "true" | "false") | undefined;
    'aria-checked'?: boolean | "true" | "false" | "mixed" | undefined;
    'aria-colcount'?: number | undefined;
    'aria-colindex'?: number | undefined;
    'aria-colindextext'?: string | undefined;
    'aria-colspan'?: number | undefined;
    'aria-current'?: boolean | "true" | "false" | "time" | "page" | "location" | "step" | "date" | undefined;
    'aria-describedby'?: string | undefined;
    'aria-description'?: string | undefined;
    'aria-details'?: string | undefined;
    'aria-dropeffect'?: "link" | "none" | "copy" | "move" | "execute" | "popup" | undefined;
    'aria-errormessage'?: string | undefined;
    'aria-expanded'?: (boolean | "true" | "false") | undefined;
    'aria-flowto'?: string | undefined;
    'aria-grabbed'?: (boolean | "true" | "false") | undefined;
    'aria-haspopup'?: boolean | "true" | "false" | "dialog" | "menu" | "grid" | "listbox" | "tree" | undefined;
    'aria-hidden'?: (boolean | "true" | "false") | undefined;
    'aria-invalid'?: boolean | "true" | "false" | "grammar" | "spelling" | undefined;
    'aria-keyshortcuts'?: string | undefined;
    'aria-label'?: string | undefined;
    'aria-labelledby'?: string | undefined;
    'aria-level'?: number | undefined;
    'aria-live'?: "off" | "assertive" | "polite" | undefined;
    'aria-modal'?: (boolean | "true" | "false") | undefined;
    'aria-multiline'?: (boolean | "true" | "false") | undefined;
    'aria-multiselectable'?: (boolean | "true" | "false") | undefined;
    'aria-orientation'?: "horizontal" | "vertical" | undefined;
    'aria-owns'?: string | undefined;
    'aria-placeholder'?: string | undefined;
    'aria-posinset'?: number | undefined;
    'aria-pressed'?: boolean | "true" | "false" | "mixed" | undefined;
    'aria-readonly'?: (boolean | "true" | "false") | undefined;
    'aria-relevant'?: "text" | "all" | "additions" | "additions removals" | "additions text" | "removals" | "removals additions" | "removals text" | "text additions" | "text removals" | undefined;
    'aria-required'?: (boolean | "true" | "false") | undefined;
    'aria-roledescription'?: string | undefined;
    'aria-rowcount'?: number | undefined;
    'aria-rowindex'?: number | undefined;
    'aria-rowindextext'?: string | undefined;
    'aria-rowspan'?: number | undefined;
    'aria-setsize'?: number | undefined;
    'aria-sort'?: "none" | "ascending" | "descending" | "other" | undefined;
    'aria-valuemax'?: number | undefined;
    'aria-valuemin'?: number | undefined;
    'aria-valuenow'?: number | undefined;
    'aria-valuetext'?: string | undefined;
    children?: react.ReactNode;
    dangerouslySetInnerHTML?: {
        __html: string | TrustedHTML;
    } | undefined;
    onCopy?: react.ClipboardEventHandler<HTMLElement> | undefined;
    onCopyCapture?: react.ClipboardEventHandler<HTMLElement> | undefined;
    onCut?: react.ClipboardEventHandler<HTMLElement> | undefined;
    onCutCapture?: react.ClipboardEventHandler<HTMLElement> | undefined;
    onPaste?: react.ClipboardEventHandler<HTMLElement> | undefined;
    onPasteCapture?: react.ClipboardEventHandler<HTMLElement> | undefined;
    onCompositionEnd?: react.CompositionEventHandler<HTMLElement> | undefined;
    onCompositionEndCapture?: react.CompositionEventHandler<HTMLElement> | undefined;
    onCompositionStart?: react.CompositionEventHandler<HTMLElement> | undefined;
    onCompositionStartCapture?: react.CompositionEventHandler<HTMLElement> | undefined;
    onCompositionUpdate?: react.CompositionEventHandler<HTMLElement> | undefined;
    onCompositionUpdateCapture?: react.CompositionEventHandler<HTMLElement> | undefined;
    onFocusCapture?: react.FocusEventHandler<HTMLElement> | undefined;
    onBlur?: react.FocusEventHandler<HTMLElement> | undefined;
    onBlurCapture?: react.FocusEventHandler<HTMLElement> | undefined;
    onChange?: react.FormEventHandler<HTMLElement> | undefined;
    onChangeCapture?: react.FormEventHandler<HTMLElement> | undefined;
    onBeforeInput?: react.FormEventHandler<HTMLElement> | undefined;
    onBeforeInputCapture?: react.FormEventHandler<HTMLElement> | undefined;
    onInput?: react.FormEventHandler<HTMLElement> | undefined;
    onInputCapture?: react.FormEventHandler<HTMLElement> | undefined;
    onReset?: react.FormEventHandler<HTMLElement> | undefined;
    onResetCapture?: react.FormEventHandler<HTMLElement> | undefined;
    onSubmit?: react.FormEventHandler<HTMLElement> | undefined;
    onSubmitCapture?: react.FormEventHandler<HTMLElement> | undefined;
    onInvalid?: react.FormEventHandler<HTMLElement> | undefined;
    onInvalidCapture?: react.FormEventHandler<HTMLElement> | undefined;
    onLoad?: react.ReactEventHandler<HTMLElement> | undefined;
    onLoadCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onError?: react.ReactEventHandler<HTMLElement> | undefined;
    onErrorCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onKeyDownCapture?: react.KeyboardEventHandler<HTMLElement> | undefined;
    onKeyPress?: react.KeyboardEventHandler<HTMLElement> | undefined;
    onKeyPressCapture?: react.KeyboardEventHandler<HTMLElement> | undefined;
    onKeyUpCapture?: react.KeyboardEventHandler<HTMLElement> | undefined;
    onAbort?: react.ReactEventHandler<HTMLElement> | undefined;
    onAbortCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onCanPlay?: react.ReactEventHandler<HTMLElement> | undefined;
    onCanPlayCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onCanPlayThrough?: react.ReactEventHandler<HTMLElement> | undefined;
    onCanPlayThroughCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onDurationChange?: react.ReactEventHandler<HTMLElement> | undefined;
    onDurationChangeCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onEmptied?: react.ReactEventHandler<HTMLElement> | undefined;
    onEmptiedCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onEncrypted?: react.ReactEventHandler<HTMLElement> | undefined;
    onEncryptedCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onEnded?: react.ReactEventHandler<HTMLElement> | undefined;
    onEndedCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onLoadedData?: react.ReactEventHandler<HTMLElement> | undefined;
    onLoadedDataCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onLoadedMetadata?: react.ReactEventHandler<HTMLElement> | undefined;
    onLoadedMetadataCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onLoadStart?: react.ReactEventHandler<HTMLElement> | undefined;
    onLoadStartCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onPause?: react.ReactEventHandler<HTMLElement> | undefined;
    onPauseCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onPlay?: react.ReactEventHandler<HTMLElement> | undefined;
    onPlayCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onPlaying?: react.ReactEventHandler<HTMLElement> | undefined;
    onPlayingCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onProgress?: react.ReactEventHandler<HTMLElement> | undefined;
    onProgressCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onRateChange?: react.ReactEventHandler<HTMLElement> | undefined;
    onRateChangeCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onResize?: react.ReactEventHandler<HTMLElement> | undefined;
    onResizeCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onSeeked?: react.ReactEventHandler<HTMLElement> | undefined;
    onSeekedCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onSeeking?: react.ReactEventHandler<HTMLElement> | undefined;
    onSeekingCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onStalled?: react.ReactEventHandler<HTMLElement> | undefined;
    onStalledCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onSuspend?: react.ReactEventHandler<HTMLElement> | undefined;
    onSuspendCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onTimeUpdate?: react.ReactEventHandler<HTMLElement> | undefined;
    onTimeUpdateCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onVolumeChange?: react.ReactEventHandler<HTMLElement> | undefined;
    onVolumeChangeCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onWaiting?: react.ReactEventHandler<HTMLElement> | undefined;
    onWaitingCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onAuxClick?: react.MouseEventHandler<HTMLElement> | undefined;
    onAuxClickCapture?: react.MouseEventHandler<HTMLElement> | undefined;
    onClickCapture?: react.MouseEventHandler<HTMLElement> | undefined;
    onContextMenu?: react.MouseEventHandler<HTMLElement> | undefined;
    onContextMenuCapture?: react.MouseEventHandler<HTMLElement> | undefined;
    onDoubleClick?: react.MouseEventHandler<HTMLElement> | undefined;
    onDoubleClickCapture?: react.MouseEventHandler<HTMLElement> | undefined;
    onDrag?: react.DragEventHandler<HTMLElement> | undefined;
    onDragCapture?: react.DragEventHandler<HTMLElement> | undefined;
    onDragEnd?: react.DragEventHandler<HTMLElement> | undefined;
    onDragEndCapture?: react.DragEventHandler<HTMLElement> | undefined;
    onDragEnter?: react.DragEventHandler<HTMLElement> | undefined;
    onDragEnterCapture?: react.DragEventHandler<HTMLElement> | undefined;
    onDragExit?: react.DragEventHandler<HTMLElement> | undefined;
    onDragExitCapture?: react.DragEventHandler<HTMLElement> | undefined;
    onDragLeave?: react.DragEventHandler<HTMLElement> | undefined;
    onDragLeaveCapture?: react.DragEventHandler<HTMLElement> | undefined;
    onDragOver?: react.DragEventHandler<HTMLElement> | undefined;
    onDragOverCapture?: react.DragEventHandler<HTMLElement> | undefined;
    onDragStart?: react.DragEventHandler<HTMLElement> | undefined;
    onDragStartCapture?: react.DragEventHandler<HTMLElement> | undefined;
    onDrop?: react.DragEventHandler<HTMLElement> | undefined;
    onDropCapture?: react.DragEventHandler<HTMLElement> | undefined;
    onMouseDownCapture?: react.MouseEventHandler<HTMLElement> | undefined;
    onMouseEnter?: react.MouseEventHandler<HTMLElement> | undefined;
    onMouseMove?: react.MouseEventHandler<HTMLElement> | undefined;
    onMouseMoveCapture?: react.MouseEventHandler<HTMLElement> | undefined;
    onMouseOut?: react.MouseEventHandler<HTMLElement> | undefined;
    onMouseOutCapture?: react.MouseEventHandler<HTMLElement> | undefined;
    onMouseOverCapture?: react.MouseEventHandler<HTMLElement> | undefined;
    onMouseUpCapture?: react.MouseEventHandler<HTMLElement> | undefined;
    onSelect?: react.ReactEventHandler<HTMLElement> | undefined;
    onSelectCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onTouchCancel?: react.TouchEventHandler<HTMLElement> | undefined;
    onTouchCancelCapture?: react.TouchEventHandler<HTMLElement> | undefined;
    onTouchEnd?: react.TouchEventHandler<HTMLElement> | undefined;
    onTouchEndCapture?: react.TouchEventHandler<HTMLElement> | undefined;
    onTouchMove?: react.TouchEventHandler<HTMLElement> | undefined;
    onTouchMoveCapture?: react.TouchEventHandler<HTMLElement> | undefined;
    onTouchStart?: react.TouchEventHandler<HTMLElement> | undefined;
    onTouchStartCapture?: react.TouchEventHandler<HTMLElement> | undefined;
    onPointerDown?: react.PointerEventHandler<HTMLElement> | undefined;
    onPointerDownCapture?: react.PointerEventHandler<HTMLElement> | undefined;
    onPointerMove?: react.PointerEventHandler<HTMLElement> | undefined;
    onPointerMoveCapture?: react.PointerEventHandler<HTMLElement> | undefined;
    onPointerUp?: react.PointerEventHandler<HTMLElement> | undefined;
    onPointerUpCapture?: react.PointerEventHandler<HTMLElement> | undefined;
    onPointerCancel?: react.PointerEventHandler<HTMLElement> | undefined;
    onPointerCancelCapture?: react.PointerEventHandler<HTMLElement> | undefined;
    onPointerEnter?: react.PointerEventHandler<HTMLElement> | undefined;
    onPointerEnterCapture?: react.PointerEventHandler<HTMLElement> | undefined;
    onPointerLeave?: react.PointerEventHandler<HTMLElement> | undefined;
    onPointerLeaveCapture?: react.PointerEventHandler<HTMLElement> | undefined;
    onPointerOver?: react.PointerEventHandler<HTMLElement> | undefined;
    onPointerOverCapture?: react.PointerEventHandler<HTMLElement> | undefined;
    onPointerOut?: react.PointerEventHandler<HTMLElement> | undefined;
    onPointerOutCapture?: react.PointerEventHandler<HTMLElement> | undefined;
    onGotPointerCapture?: react.PointerEventHandler<HTMLElement> | undefined;
    onGotPointerCaptureCapture?: react.PointerEventHandler<HTMLElement> | undefined;
    onLostPointerCapture?: react.PointerEventHandler<HTMLElement> | undefined;
    onLostPointerCaptureCapture?: react.PointerEventHandler<HTMLElement> | undefined;
    onScroll?: react.UIEventHandler<HTMLElement> | undefined;
    onScrollCapture?: react.UIEventHandler<HTMLElement> | undefined;
    onWheel?: react.WheelEventHandler<HTMLElement> | undefined;
    onWheelCapture?: react.WheelEventHandler<HTMLElement> | undefined;
    onAnimationStart?: react.AnimationEventHandler<HTMLElement> | undefined;
    onAnimationStartCapture?: react.AnimationEventHandler<HTMLElement> | undefined;
    onAnimationEnd?: react.AnimationEventHandler<HTMLElement> | undefined;
    onAnimationEndCapture?: react.AnimationEventHandler<HTMLElement> | undefined;
    onAnimationIteration?: react.AnimationEventHandler<HTMLElement> | undefined;
    onAnimationIterationCapture?: react.AnimationEventHandler<HTMLElement> | undefined;
    onTransitionEnd?: react.TransitionEventHandler<HTMLElement> | undefined;
    onTransitionEndCapture?: react.TransitionEventHandler<HTMLElement> | undefined;
} | {
    id: string;
    role: string;
    tabIndex: number;
    type: "button";
    "aria-selected": boolean;
    "aria-controls": string;
    onFocus: ((event: react.FocusEvent<HTMLElement, Element>) => void) | undefined;
    ref: (node: any) => void;
    "data-active": boolean | "true" | "false";
    "aria-disabled": "true" | undefined;
    onClick: (event: react.MouseEvent<HTMLElement, MouseEvent>) => void;
    onMouseDown: (event: react.MouseEvent<HTMLElement, MouseEvent>) => void;
    onMouseUp: (event: react.MouseEvent<HTMLElement, MouseEvent>) => void;
    onKeyUp: (event: react.KeyboardEvent<HTMLElement>) => void;
    onKeyDown: (event: react.KeyboardEvent<HTMLElement>) => void;
    onMouseOver: (event: react.MouseEvent<HTMLElement, MouseEvent>) => void;
    onMouseLeave: (event: react.MouseEvent<HTMLElement, MouseEvent>) => void;
    defaultChecked?: boolean | undefined;
    defaultValue?: string | number | readonly string[] | undefined;
    suppressContentEditableWarning?: boolean | undefined;
    suppressHydrationWarning?: boolean | undefined;
    accessKey?: string | undefined;
    autoFocus?: boolean | undefined;
    className?: string | undefined;
    contentEditable?: "inherit" | (boolean | "true" | "false") | undefined;
    contextMenu?: string | undefined;
    dir?: string | undefined;
    draggable?: (boolean | "true" | "false") | undefined;
    hidden?: boolean | undefined;
    lang?: string | undefined;
    nonce?: string | undefined;
    placeholder?: string | undefined;
    slot?: string | undefined;
    spellCheck?: (boolean | "true" | "false") | undefined;
    style?: react.CSSProperties | undefined;
    title?: string | undefined;
    translate?: "yes" | "no" | undefined;
    radioGroup?: string | undefined;
    about?: string | undefined;
    content?: string | undefined;
    datatype?: string | undefined;
    inlist?: any;
    prefix?: string | undefined;
    property?: string | undefined;
    rel?: string | undefined;
    resource?: string | undefined;
    rev?: string | undefined;
    typeof?: string | undefined;
    vocab?: string | undefined;
    autoCapitalize?: string | undefined;
    autoCorrect?: string | undefined;
    autoSave?: string | undefined;
    color?: string | undefined;
    itemProp?: string | undefined;
    itemScope?: boolean | undefined;
    itemType?: string | undefined;
    itemID?: string | undefined;
    itemRef?: string | undefined;
    results?: number | undefined;
    security?: string | undefined;
    unselectable?: "on" | "off" | undefined;
    inputMode?: "search" | "text" | "none" | "email" | "tel" | "url" | "numeric" | "decimal" | undefined;
    is?: string | undefined;
    'aria-activedescendant'?: string | undefined;
    'aria-atomic'?: (boolean | "true" | "false") | undefined;
    'aria-autocomplete'?: "none" | "both" | "inline" | "list" | undefined;
    'aria-braillelabel'?: string | undefined;
    'aria-brailleroledescription'?: string | undefined;
    'aria-busy'?: (boolean | "true" | "false") | undefined;
    'aria-checked'?: boolean | "true" | "false" | "mixed" | undefined;
    'aria-colcount'?: number | undefined;
    'aria-colindex'?: number | undefined;
    'aria-colindextext'?: string | undefined;
    'aria-colspan'?: number | undefined;
    'aria-current'?: boolean | "true" | "false" | "time" | "page" | "location" | "step" | "date" | undefined;
    'aria-describedby'?: string | undefined;
    'aria-description'?: string | undefined;
    'aria-details'?: string | undefined;
    'aria-dropeffect'?: "link" | "none" | "copy" | "move" | "execute" | "popup" | undefined;
    'aria-errormessage'?: string | undefined;
    'aria-expanded'?: (boolean | "true" | "false") | undefined;
    'aria-flowto'?: string | undefined;
    'aria-grabbed'?: (boolean | "true" | "false") | undefined;
    'aria-haspopup'?: boolean | "true" | "false" | "dialog" | "menu" | "grid" | "listbox" | "tree" | undefined;
    'aria-hidden'?: (boolean | "true" | "false") | undefined;
    'aria-invalid'?: boolean | "true" | "false" | "grammar" | "spelling" | undefined;
    'aria-keyshortcuts'?: string | undefined;
    'aria-label'?: string | undefined;
    'aria-labelledby'?: string | undefined;
    'aria-level'?: number | undefined;
    'aria-live'?: "off" | "assertive" | "polite" | undefined;
    'aria-modal'?: (boolean | "true" | "false") | undefined;
    'aria-multiline'?: (boolean | "true" | "false") | undefined;
    'aria-multiselectable'?: (boolean | "true" | "false") | undefined;
    'aria-orientation'?: "horizontal" | "vertical" | undefined;
    'aria-owns'?: string | undefined;
    'aria-placeholder'?: string | undefined;
    'aria-posinset'?: number | undefined;
    'aria-pressed'?: boolean | "true" | "false" | "mixed" | undefined;
    'aria-readonly'?: (boolean | "true" | "false") | undefined;
    'aria-relevant'?: "text" | "all" | "additions" | "additions removals" | "additions text" | "removals" | "removals additions" | "removals text" | "text additions" | "text removals" | undefined;
    'aria-required'?: (boolean | "true" | "false") | undefined;
    'aria-roledescription'?: string | undefined;
    'aria-rowcount'?: number | undefined;
    'aria-rowindex'?: number | undefined;
    'aria-rowindextext'?: string | undefined;
    'aria-rowspan'?: number | undefined;
    'aria-setsize'?: number | undefined;
    'aria-sort'?: "none" | "ascending" | "descending" | "other" | undefined;
    'aria-valuemax'?: number | undefined;
    'aria-valuemin'?: number | undefined;
    'aria-valuenow'?: number | undefined;
    'aria-valuetext'?: string | undefined;
    children?: react.ReactNode;
    dangerouslySetInnerHTML?: {
        __html: string | TrustedHTML;
    } | undefined;
    onCopy?: react.ClipboardEventHandler<HTMLElement> | undefined;
    onCopyCapture?: react.ClipboardEventHandler<HTMLElement> | undefined;
    onCut?: react.ClipboardEventHandler<HTMLElement> | undefined;
    onCutCapture?: react.ClipboardEventHandler<HTMLElement> | undefined;
    onPaste?: react.ClipboardEventHandler<HTMLElement> | undefined;
    onPasteCapture?: react.ClipboardEventHandler<HTMLElement> | undefined;
    onCompositionEnd?: react.CompositionEventHandler<HTMLElement> | undefined;
    onCompositionEndCapture?: react.CompositionEventHandler<HTMLElement> | undefined;
    onCompositionStart?: react.CompositionEventHandler<HTMLElement> | undefined;
    onCompositionStartCapture?: react.CompositionEventHandler<HTMLElement> | undefined;
    onCompositionUpdate?: react.CompositionEventHandler<HTMLElement> | undefined;
    onCompositionUpdateCapture?: react.CompositionEventHandler<HTMLElement> | undefined;
    onFocusCapture?: react.FocusEventHandler<HTMLElement> | undefined;
    onBlur?: react.FocusEventHandler<HTMLElement> | undefined;
    onBlurCapture?: react.FocusEventHandler<HTMLElement> | undefined;
    onChange?: react.FormEventHandler<HTMLElement> | undefined;
    onChangeCapture?: react.FormEventHandler<HTMLElement> | undefined;
    onBeforeInput?: react.FormEventHandler<HTMLElement> | undefined;
    onBeforeInputCapture?: react.FormEventHandler<HTMLElement> | undefined;
    onInput?: react.FormEventHandler<HTMLElement> | undefined;
    onInputCapture?: react.FormEventHandler<HTMLElement> | undefined;
    onReset?: react.FormEventHandler<HTMLElement> | undefined;
    onResetCapture?: react.FormEventHandler<HTMLElement> | undefined;
    onSubmit?: react.FormEventHandler<HTMLElement> | undefined;
    onSubmitCapture?: react.FormEventHandler<HTMLElement> | undefined;
    onInvalid?: react.FormEventHandler<HTMLElement> | undefined;
    onInvalidCapture?: react.FormEventHandler<HTMLElement> | undefined;
    onLoad?: react.ReactEventHandler<HTMLElement> | undefined;
    onLoadCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onError?: react.ReactEventHandler<HTMLElement> | undefined;
    onErrorCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onKeyDownCapture?: react.KeyboardEventHandler<HTMLElement> | undefined;
    onKeyPress?: react.KeyboardEventHandler<HTMLElement> | undefined;
    onKeyPressCapture?: react.KeyboardEventHandler<HTMLElement> | undefined;
    onKeyUpCapture?: react.KeyboardEventHandler<HTMLElement> | undefined;
    onAbort?: react.ReactEventHandler<HTMLElement> | undefined;
    onAbortCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onCanPlay?: react.ReactEventHandler<HTMLElement> | undefined;
    onCanPlayCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onCanPlayThrough?: react.ReactEventHandler<HTMLElement> | undefined;
    onCanPlayThroughCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onDurationChange?: react.ReactEventHandler<HTMLElement> | undefined;
    onDurationChangeCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onEmptied?: react.ReactEventHandler<HTMLElement> | undefined;
    onEmptiedCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onEncrypted?: react.ReactEventHandler<HTMLElement> | undefined;
    onEncryptedCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onEnded?: react.ReactEventHandler<HTMLElement> | undefined;
    onEndedCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onLoadedData?: react.ReactEventHandler<HTMLElement> | undefined;
    onLoadedDataCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onLoadedMetadata?: react.ReactEventHandler<HTMLElement> | undefined;
    onLoadedMetadataCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onLoadStart?: react.ReactEventHandler<HTMLElement> | undefined;
    onLoadStartCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onPause?: react.ReactEventHandler<HTMLElement> | undefined;
    onPauseCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onPlay?: react.ReactEventHandler<HTMLElement> | undefined;
    onPlayCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onPlaying?: react.ReactEventHandler<HTMLElement> | undefined;
    onPlayingCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onProgress?: react.ReactEventHandler<HTMLElement> | undefined;
    onProgressCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onRateChange?: react.ReactEventHandler<HTMLElement> | undefined;
    onRateChangeCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onResize?: react.ReactEventHandler<HTMLElement> | undefined;
    onResizeCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onSeeked?: react.ReactEventHandler<HTMLElement> | undefined;
    onSeekedCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onSeeking?: react.ReactEventHandler<HTMLElement> | undefined;
    onSeekingCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onStalled?: react.ReactEventHandler<HTMLElement> | undefined;
    onStalledCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onSuspend?: react.ReactEventHandler<HTMLElement> | undefined;
    onSuspendCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onTimeUpdate?: react.ReactEventHandler<HTMLElement> | undefined;
    onTimeUpdateCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onVolumeChange?: react.ReactEventHandler<HTMLElement> | undefined;
    onVolumeChangeCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onWaiting?: react.ReactEventHandler<HTMLElement> | undefined;
    onWaitingCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onAuxClick?: react.MouseEventHandler<HTMLElement> | undefined;
    onAuxClickCapture?: react.MouseEventHandler<HTMLElement> | undefined;
    onClickCapture?: react.MouseEventHandler<HTMLElement> | undefined;
    onContextMenu?: react.MouseEventHandler<HTMLElement> | undefined;
    onContextMenuCapture?: react.MouseEventHandler<HTMLElement> | undefined;
    onDoubleClick?: react.MouseEventHandler<HTMLElement> | undefined;
    onDoubleClickCapture?: react.MouseEventHandler<HTMLElement> | undefined;
    onDrag?: react.DragEventHandler<HTMLElement> | undefined;
    onDragCapture?: react.DragEventHandler<HTMLElement> | undefined;
    onDragEnd?: react.DragEventHandler<HTMLElement> | undefined;
    onDragEndCapture?: react.DragEventHandler<HTMLElement> | undefined;
    onDragEnter?: react.DragEventHandler<HTMLElement> | undefined;
    onDragEnterCapture?: react.DragEventHandler<HTMLElement> | undefined;
    onDragExit?: react.DragEventHandler<HTMLElement> | undefined;
    onDragExitCapture?: react.DragEventHandler<HTMLElement> | undefined;
    onDragLeave?: react.DragEventHandler<HTMLElement> | undefined;
    onDragLeaveCapture?: react.DragEventHandler<HTMLElement> | undefined;
    onDragOver?: react.DragEventHandler<HTMLElement> | undefined;
    onDragOverCapture?: react.DragEventHandler<HTMLElement> | undefined;
    onDragStart?: react.DragEventHandler<HTMLElement> | undefined;
    onDragStartCapture?: react.DragEventHandler<HTMLElement> | undefined;
    onDrop?: react.DragEventHandler<HTMLElement> | undefined;
    onDropCapture?: react.DragEventHandler<HTMLElement> | undefined;
    onMouseDownCapture?: react.MouseEventHandler<HTMLElement> | undefined;
    onMouseEnter?: react.MouseEventHandler<HTMLElement> | undefined;
    onMouseMove?: react.MouseEventHandler<HTMLElement> | undefined;
    onMouseMoveCapture?: react.MouseEventHandler<HTMLElement> | undefined;
    onMouseOut?: react.MouseEventHandler<HTMLElement> | undefined;
    onMouseOutCapture?: react.MouseEventHandler<HTMLElement> | undefined;
    onMouseOverCapture?: react.MouseEventHandler<HTMLElement> | undefined;
    onMouseUpCapture?: react.MouseEventHandler<HTMLElement> | undefined;
    onSelect?: react.ReactEventHandler<HTMLElement> | undefined;
    onSelectCapture?: react.ReactEventHandler<HTMLElement> | undefined;
    onTouchCancel?: react.TouchEventHandler<HTMLElement> | undefined;
    onTouchCancelCapture?: react.TouchEventHandler<HTMLElement> | undefined;
    onTouchEnd?: react.TouchEventHandler<HTMLElement> | undefined;
    onTouchEndCapture?: react.TouchEventHandler<HTMLElement> | undefined;
    onTouchMove?: react.TouchEventHandler<HTMLElement> | undefined;
    onTouchMoveCapture?: react.TouchEventHandler<HTMLElement> | undefined;
    onTouchStart?: react.TouchEventHandler<HTMLElement> | undefined;
    onTouchStartCapture?: react.TouchEventHandler<HTMLElement> | undefined;
    onPointerDown?: react.PointerEventHandler<HTMLElement> | undefined;
    onPointerDownCapture?: react.PointerEventHandler<HTMLElement> | undefined;
    onPointerMove?: react.PointerEventHandler<HTMLElement> | undefined;
    onPointerMoveCapture?: react.PointerEventHandler<HTMLElement> | undefined;
    onPointerUp?: react.PointerEventHandler<HTMLElement> | undefined;
    onPointerUpCapture?: react.PointerEventHandler<HTMLElement> | undefined;
    onPointerCancel?: react.PointerEventHandler<HTMLElement> | undefined;
    onPointerCancelCapture?: react.PointerEventHandler<HTMLElement> | undefined;
    onPointerEnter?: react.PointerEventHandler<HTMLElement> | undefined;
    onPointerEnterCapture?: react.PointerEventHandler<HTMLElement> | undefined;
    onPointerLeave?: react.PointerEventHandler<HTMLElement> | undefined;
    onPointerLeaveCapture?: react.PointerEventHandler<HTMLElement> | undefined;
    onPointerOver?: react.PointerEventHandler<HTMLElement> | undefined;
    onPointerOverCapture?: react.PointerEventHandler<HTMLElement> | undefined;
    onPointerOut?: react.PointerEventHandler<HTMLElement> | undefined;
    onPointerOutCapture?: react.PointerEventHandler<HTMLElement> | undefined;
    onGotPointerCapture?: react.PointerEventHandler<HTMLElement> | undefined;
    onGotPointerCaptureCapture?: react.PointerEventHandler<HTMLElement> | undefined;
    onLostPointerCapture?: react.PointerEventHandler<HTMLElement> | undefined;
    onLostPointerCaptureCapture?: react.PointerEventHandler<HTMLElement> | undefined;
    onScroll?: react.UIEventHandler<HTMLElement> | undefined;
    onScrollCapture?: react.UIEventHandler<HTMLElement> | undefined;
    onWheel?: react.WheelEventHandler<HTMLElement> | undefined;
    onWheelCapture?: react.WheelEventHandler<HTMLElement> | undefined;
    onAnimationStart?: react.AnimationEventHandler<HTMLElement> | undefined;
    onAnimationStartCapture?: react.AnimationEventHandler<HTMLElement> | undefined;
    onAnimationEnd?: react.AnimationEventHandler<HTMLElement> | undefined;
    onAnimationEndCapture?: react.AnimationEventHandler<HTMLElement> | undefined;
    onAnimationIteration?: react.AnimationEventHandler<HTMLElement> | undefined;
    onAnimationIterationCapture?: react.AnimationEventHandler<HTMLElement> | undefined;
    onTransitionEnd?: react.TransitionEventHandler<HTMLElement> | undefined;
    onTransitionEndCapture?: react.TransitionEventHandler<HTMLElement> | undefined;
};
interface UseTabPanelsProps {
    children?: React.ReactNode;
}
/**
 * Tabs hook for managing the visibility of multiple tab panels.
 *
 * Since only one panel can be show at a time, we use `cloneElement`
 * to inject `selected` panel to each TabPanel.
 *
 * It returns a cloned version of its children with
 * all functionality included.
 */
declare function useTabPanels<P extends UseTabPanelsProps>(props: P): P & {
    children: react.FunctionComponentElement<react.ProviderProps<{
        isSelected: boolean;
        id: string;
        tabId: string;
        selectedIndex: number;
    }>>[];
};
/**
 * Tabs hook for managing the visible/hidden states
 * of the tab panel.
 *
 * @param props props object for the tab panel
 */
declare function useTabPanel(props: Record<string, any>): {
    children: any;
    role: string;
    "aria-labelledby": string;
    hidden: boolean;
    id: string;
    tabIndex: number;
};
/**
 * Tabs hook to show an animated indicators that
 * follows the active tab.
 *
 * The way we do it is by measuring the DOM Rect (or dimensions)
 * of the active tab, and return that as CSS style for
 * the indicator.
 */
declare function useTabIndicator(): React.CSSProperties;

export { TabsDescendantsProvider, TabsProvider, UseTabListProps, UseTabListReturn, UseTabOptions, UseTabPanelsProps, UseTabProps, UseTabsProps, UseTabsReturn, useTab, useTabIndicator, useTabList, useTabPanel, useTabPanels, useTabs, useTabsContext, useTabsDescendant, useTabsDescendants, useTabsDescendantsContext };
