// src/components/card.ts
import { cardAnatomy as parts } from "@chakra-ui/anatomy";
import { createMultiStyleConfigHelpers, cssVar } from "@chakra-ui/styled-system";
var { definePartsStyle, defineMultiStyleConfig } = createMultiStyleConfigHelpers(parts.keys);
var $bg = cssVar("card-bg");
var $padding = cssVar("card-padding");
var $shadow = cssVar("card-shadow");
var $radius = cssVar("card-radius");
var $border = cssVar("card-border-width", "0");
var $borderColor = cssVar("card-border-color");
var baseStyle = definePartsStyle({
  container: {
    [$bg.variable]: "colors.chakra-body-bg",
    backgroundColor: $bg.reference,
    boxShadow: $shadow.reference,
    borderRadius: $radius.reference,
    color: "chakra-body-text",
    borderWidth: $border.reference,
    borderColor: $borderColor.reference
  },
  body: {
    padding: $padding.reference,
    flex: "1 1 0%"
  },
  header: {
    padding: $padding.reference
  },
  footer: {
    padding: $padding.reference
  }
});
var sizes = {
  sm: definePartsStyle({
    container: {
      [$radius.variable]: "radii.base",
      [$padding.variable]: "space.3"
    }
  }),
  md: definePartsStyle({
    container: {
      [$radius.variable]: "radii.md",
      [$padding.variable]: "space.5"
    }
  }),
  lg: definePartsStyle({
    container: {
      [$radius.variable]: "radii.xl",
      [$padding.variable]: "space.7"
    }
  })
};
var variants = {
  elevated: definePartsStyle({
    container: {
      [$shadow.variable]: "shadows.base",
      _dark: {
        [$bg.variable]: "colors.gray.700"
      }
    }
  }),
  outline: definePartsStyle({
    container: {
      [$border.variable]: "1px",
      [$borderColor.variable]: "colors.chakra-border-color"
    }
  }),
  filled: definePartsStyle({
    container: {
      [$bg.variable]: "colors.chakra-subtle-bg"
    }
  }),
  unstyled: {
    body: {
      [$padding.variable]: 0
    },
    header: {
      [$padding.variable]: 0
    },
    footer: {
      [$padding.variable]: 0
    }
  }
};
var cardTheme = defineMultiStyleConfig({
  baseStyle,
  variants,
  sizes,
  defaultProps: {
    variant: "elevated",
    size: "md"
  }
});

export {
  cardTheme
};
//# sourceMappingURL=chunk-F7CKIHPM.mjs.map