// src/components/spinner.ts
import { defineStyle, defineStyleConfig } from "@chakra-ui/styled-system";
import { cssVar } from "@chakra-ui/theme-tools";
var $size = cssVar("spinner-size");
var baseStyle = defineStyle({
  width: [$size.reference],
  height: [$size.reference]
});
var sizes = {
  xs: defineStyle({
    [$size.variable]: "sizes.3"
  }),
  sm: defineStyle({
    [$size.variable]: "sizes.4"
  }),
  md: defineStyle({
    [$size.variable]: "sizes.6"
  }),
  lg: defineStyle({
    [$size.variable]: "sizes.8"
  }),
  xl: defineStyle({
    [$size.variable]: "sizes.12"
  })
};
var spinnerTheme = defineStyleConfig({
  baseStyle,
  sizes,
  defaultProps: {
    size: "md"
  }
});

export {
  spinnerTheme
};
//# sourceMappingURL=chunk-L3YAB6CV.mjs.map