import {
  sizes_default
} from "./chunk-NJCYBKFH.mjs";
import {
  runIfFn
} from "./chunk-UV3F75RF.mjs";

// src/components/avatar.ts
import { avatarAnatomy as parts } from "@chakra-ui/anatomy";
import {
  createMultiStyleConfigHelpers,
  cssVar,
  defineStyle
} from "@chakra-ui/styled-system";
import { isDark, randomColor } from "@chakra-ui/theme-tools";
var { definePartsStyle, defineMultiStyleConfig } = createMultiStyleConfigHelpers(parts.keys);
var $border = cssVar("avatar-border-color");
var $bg = cssVar("avatar-bg");
var $fs = cssVar("avatar-font-size");
var $size = cssVar("avatar-size");
var baseStyleBadge = defineStyle({
  borderRadius: "full",
  border: "0.2em solid",
  borderColor: $border.reference,
  [$border.variable]: "white",
  _dark: {
    [$border.variable]: "colors.gray.800"
  }
});
var baseStyleExcessLabel = defineStyle({
  bg: $bg.reference,
  fontSize: $fs.reference,
  width: $size.reference,
  height: $size.reference,
  lineHeight: "1",
  [$bg.variable]: "colors.gray.200",
  _dark: {
    [$bg.variable]: "colors.whiteAlpha.400"
  }
});
var baseStyleContainer = defineStyle((props) => {
  const { name, theme } = props;
  const bg = name ? randomColor({ string: name }) : "colors.gray.400";
  const isBgDark = isDark(bg)(theme);
  let color = "white";
  if (!isBgDark)
    color = "gray.800";
  return {
    bg: $bg.reference,
    fontSize: $fs.reference,
    color,
    borderColor: $border.reference,
    verticalAlign: "top",
    width: $size.reference,
    height: $size.reference,
    "&:not([data-loaded])": {
      [$bg.variable]: bg
    },
    [$border.variable]: "colors.white",
    _dark: {
      [$border.variable]: "colors.gray.800"
    }
  };
});
var baseStyleLabel = defineStyle({
  fontSize: $fs.reference,
  lineHeight: "1"
});
var baseStyle = definePartsStyle((props) => ({
  badge: runIfFn(baseStyleBadge, props),
  excessLabel: runIfFn(baseStyleExcessLabel, props),
  container: runIfFn(baseStyleContainer, props),
  label: baseStyleLabel
}));
function getSize(size) {
  const themeSize = size !== "100%" ? sizes_default[size] : void 0;
  return definePartsStyle({
    container: {
      [$size.variable]: themeSize != null ? themeSize : size,
      [$fs.variable]: `calc(${themeSize != null ? themeSize : size} / 2.5)`
    },
    excessLabel: {
      [$size.variable]: themeSize != null ? themeSize : size,
      [$fs.variable]: `calc(${themeSize != null ? themeSize : size} / 2.5)`
    }
  });
}
var sizes = {
  "2xs": getSize(4),
  xs: getSize(6),
  sm: getSize(8),
  md: getSize(12),
  lg: getSize(16),
  xl: getSize(24),
  "2xl": getSize(32),
  full: getSize("100%")
};
var avatarTheme = defineMultiStyleConfig({
  baseStyle,
  sizes,
  defaultProps: {
    size: "md"
  }
});

export {
  avatarTheme
};
//# sourceMappingURL=chunk-Q5ZQE4MD.mjs.map