// src/components/tooltip.ts
import { defineStyle, defineStyleConfig } from "@chakra-ui/styled-system";
import { cssVar } from "@chakra-ui/theme-tools";
var $bg = cssVar("tooltip-bg");
var $fg = cssVar("tooltip-fg");
var $arrowBg = cssVar("popper-arrow-bg");
var baseStyle = defineStyle({
  bg: $bg.reference,
  color: $fg.reference,
  [$bg.variable]: "colors.gray.700",
  [$fg.variable]: "colors.whiteAlpha.900",
  _dark: {
    [$bg.variable]: "colors.gray.300",
    [$fg.variable]: "colors.gray.900"
  },
  [$arrowBg.variable]: $bg.reference,
  px: "2",
  py: "0.5",
  borderRadius: "sm",
  fontWeight: "medium",
  fontSize: "sm",
  boxShadow: "md",
  maxW: "xs",
  zIndex: "tooltip"
});
var tooltipTheme = defineStyleConfig({
  baseStyle
});

export {
  tooltipTheme
};
//# sourceMappingURL=chunk-R7ZISUMV.mjs.map