import { ToastPosition } from './toast.placement.mjs';
import { b as ToastOptions, a as ToastId, T as ToastState } from './toast.types-84753540.js';
import '@chakra-ui/system';
import '@chakra-ui/alert';
import 'react';

/**
 * Given an array of toasts for a specific position.
 * It returns the toast that matches the `id` passed
 */
declare const findById: (arr: ToastOptions[], id: ToastId) => ToastOptions | undefined;
/**
 * Given the toast manager state, finds the toast that matches
 * the id and return its position and index
 */
declare function findToast(toasts: ToastState, id: ToastId): {
    position: ToastPosition | undefined;
    index: number;
};
/**
 * Given the toast manager state, finds the position of the toast that
 * matches the `id`
 */
declare function getToastPosition(toasts: ToastState, id: ToastId): ToastPosition | undefined;
/**
 * Given the toast manager state, checks if a specific toast is
 * still in the state, which means it is still visible on screen.
 */
declare const isVisible: (toasts: ToastState, id: ToastId) => boolean;
/**
 * Gets the styles to be applied to a toast's container
 * based on its position in the manager
 */
declare function getToastStyle(position: ToastPosition): React.CSSProperties;
/**
 * Compute the style of a toast based on its position
 */
declare function getToastListStyle(position: ToastPosition): React.CSSProperties;

export { findById, findToast, getToastListStyle, getToastPosition, getToastStyle, isVisible };
