'use client'
import {
  scale
} from "./chunk-XRZH7COS.mjs";
import {
  useTooltip
} from "./chunk-P7BNLW77.mjs";

// src/tooltip.tsx
import { popperCSSVars } from "@chakra-ui/popper";
import { Portal } from "@chakra-ui/portal";
import {
  chakra,
  forwardRef,
  omitThemingProps,
  useStyleConfig,
  useTheme,
  getCSSVar
} from "@chakra-ui/system";

// ../../utilities/object-utils/src/omit.ts
function omit(object, keysToOmit = []) {
  const clone = Object.assign({}, object);
  for (const key of keysToOmit) {
    if (key in clone) {
      delete clone[key];
    }
  }
  return clone;
}

// ../../utilities/object-utils/src/pick.ts
function pick(object, keysToPick) {
  const result = {};
  for (const key of keysToPick) {
    if (key in object) {
      result[key] = object[key];
    }
  }
  return result;
}

// src/tooltip.tsx
import { AnimatePresence, motion } from "framer-motion";
import { Children, cloneElement } from "react";
import { Fragment, jsx, jsxs } from "react/jsx-runtime";
var MotionDiv = chakra(motion.div);
var Tooltip = forwardRef((props, ref) => {
  var _a, _b;
  const styles = useStyleConfig("Tooltip", props);
  const ownProps = omitThemingProps(props);
  const theme = useTheme();
  const {
    children,
    label,
    shouldWrapChildren,
    "aria-label": ariaLabel,
    hasArrow,
    bg,
    portalProps,
    background,
    backgroundColor,
    bgColor,
    motionProps,
    ...rest
  } = ownProps;
  const userDefinedBg = (_b = (_a = background != null ? background : backgroundColor) != null ? _a : bg) != null ? _b : bgColor;
  if (userDefinedBg) {
    styles.bg = userDefinedBg;
    const bgVar = getCSSVar(theme, "colors", userDefinedBg);
    styles[popperCSSVars.arrowBg.var] = bgVar;
  }
  const tooltip = useTooltip({ ...rest, direction: theme.direction });
  const shouldWrap = typeof children === "string" || shouldWrapChildren;
  let trigger;
  if (shouldWrap) {
    trigger = /* @__PURE__ */ jsx(
      chakra.span,
      {
        display: "inline-block",
        tabIndex: 0,
        ...tooltip.getTriggerProps(),
        children
      }
    );
  } else {
    const child = Children.only(children);
    trigger = cloneElement(
      child,
      tooltip.getTriggerProps(child.props, child.ref)
    );
  }
  const hasAriaLabel = !!ariaLabel;
  const _tooltipProps = tooltip.getTooltipProps({}, ref);
  const tooltipProps = hasAriaLabel ? omit(_tooltipProps, ["role", "id"]) : _tooltipProps;
  const srOnlyProps = pick(_tooltipProps, ["role", "id"]);
  if (!label) {
    return /* @__PURE__ */ jsx(Fragment, { children });
  }
  return /* @__PURE__ */ jsxs(Fragment, { children: [
    trigger,
    /* @__PURE__ */ jsx(AnimatePresence, { children: tooltip.isOpen && /* @__PURE__ */ jsx(Portal, { ...portalProps, children: /* @__PURE__ */ jsx(
      chakra.div,
      {
        ...tooltip.getTooltipPositionerProps(),
        __css: {
          zIndex: styles.zIndex,
          pointerEvents: "none"
        },
        children: /* @__PURE__ */ jsxs(
          MotionDiv,
          {
            variants: scale,
            initial: "exit",
            animate: "enter",
            exit: "exit",
            ...motionProps,
            ...tooltipProps,
            __css: styles,
            children: [
              label,
              hasAriaLabel && /* @__PURE__ */ jsx(chakra.span, { srOnly: true, ...srOnlyProps, children: ariaLabel }),
              hasArrow && /* @__PURE__ */ jsx(
                chakra.div,
                {
                  "data-popper-arrow": true,
                  className: "chakra-tooltip__arrow-wrapper",
                  children: /* @__PURE__ */ jsx(
                    chakra.div,
                    {
                      "data-popper-arrow-inner": true,
                      className: "chakra-tooltip__arrow",
                      __css: { bg: styles.bg }
                    }
                  )
                }
              )
            ]
          }
        )
      }
    ) }) })
  ] });
});
Tooltip.displayName = "Tooltip";

export {
  Tooltip
};
//# sourceMappingURL=chunk-TK6VMDNP.mjs.map