import * as _chakra_ui_system from '@chakra-ui/system';

/**
 * Visually hidden component used to hide
 * elements on screen
 *
 * @see Docs https://chakra-ui.com/docs/components/visually-hidden
 */
declare const VisuallyHidden: _chakra_ui_system.ChakraComponent<"span", {}>;
/**
 * Visually hidden input component for designing
 * custom input components using the html `input`
 * as a proxy
 *
 * @see Docs https://chakra-ui.com/docs/components/visually-hidden#visually-hidden-input
 */
declare const VisuallyHiddenInput: _chakra_ui_system.ChakraComponent<"input", {}>;

export { VisuallyHidden, VisuallyHiddenInput, VisuallyHidden as default };
